/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.client.utils.TextureUtils;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.cache.texture.BlueAbstractTexture;
import software.bluelib.loader.cache.texture.GlowingTextureMeta;

public class AutoGlowingTexture
extends BlueAbstractTexture {
    @NotNull
    private static final RenderStateShard.ShaderStateShard SHADER_STATE = new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeEntityTranslucentEmissiveShader);
    @NotNull
    private static final RenderStateShard.TransparencyStateShard TRANSPARENCY_STATE = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    @NotNull
    private static final RenderStateShard.WriteMaskStateShard WRITE_MASK = new RenderStateShard.WriteMaskStateShard(true, true);
    @NotNull
    private static final BiFunction<ResourceLocation, Boolean, RenderType> GLOWING_RENDER_TYPE = Util.memoize((texture, isGlowing) -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.create((String)"glowing_layer", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(SHADER_STATE).setTextureState((RenderStateShard.EmptyTextureStateShard)textureState).setTransparencyState(TRANSPARENCY_STATE).setOverlayState(new RenderStateShard.OverlayStateShard(true)).setWriteMaskState(WRITE_MASK).createCompositeState(isGlowing.booleanValue()));
    });
    @NotNull
    private static final String APPENDIX = "_glowmask";
    public static boolean PRINT_DEBUG_IMAGES = false;
    @NotNull
    protected final ResourceLocation textureBase;
    @NotNull
    protected final ResourceLocation glowLayer;

    public AutoGlowingTexture(@NotNull ResourceLocation pOriginalLocation, @NotNull ResourceLocation pLocation) {
        this.textureBase = pOriginalLocation;
        this.glowLayer = pLocation;
    }

    @NotNull
    public static ResourceLocation getEmissiveResource(@NotNull ResourceLocation pBaseResource) {
        ResourceLocation path = AutoGlowingTexture.appendToPath(pBaseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.register(path, (AbstractTexture)new AutoGlowingTexture(pBaseResource, path)));
        return path;
    }

    @Override
    @Nullable
    protected RenderCall loadTexture(@NotNull ResourceManager pResourceManager) throws IOException {
        AnimatableTexture animatableTexture;
        boolean animated;
        NativeImage nativeImage;
        AbstractTexture originalTexture;
        try {
            originalTexture = (AbstractTexture)Minecraft.getInstance().submit(() -> TextureUtils.getTexture(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + String.valueOf(this.textureBase), e);
        }
        Resource textureBaseResource = (Resource)pResourceManager.getResource(this.textureBase).get();
        if (originalTexture instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
            nativeImage = dynamicTexture.getPixels();
        } else {
            nativeImage = NativeImage.read((InputStream)textureBaseResource.open());
        }
        NativeImage baseImage = nativeImage;
        NativeImage glowImage = null;
        Optional textureBaseMeta = textureBaseResource.metadata().getSection((MetadataSectionSerializer)TextureMetadataSection.SERIALIZER);
        boolean blur = textureBaseMeta.isPresent() && ((TextureMetadataSection)textureBaseMeta.get()).isBlur();
        boolean clamp = textureBaseMeta.isPresent() && ((TextureMetadataSection)textureBaseMeta.get()).isClamp();
        try {
            Optional glowLayerResource = pResourceManager.getResource(this.glowLayer);
            GlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource.isPresent()) {
                glowImage = NativeImage.read((InputStream)((Resource)glowLayerResource.get()).open());
                glowLayerMeta = GlowingTextureMeta.fromExistingImage(glowImage);
            } else {
                Optional meta = textureBaseResource.metadata().getSection(GlowingTextureMeta.DESERIALIZER);
                if (meta.isPresent()) {
                    glowLayerMeta = (GlowingTextureMeta)meta.get();
                    glowImage = new NativeImage(baseImage.getWidth(), baseImage.getHeight(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (PRINT_DEBUG_IMAGES && BlueLibConstants.PlatformHelper.PLATFORM.isDevelopmentEnvironment()) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            BaseLogger.log(BaseLogLevel.WARNING, "Resource failed to open for glowlayer meta: " + String.valueOf(this.glowLayer), e);
        }
        NativeImage mask = glowImage;
        if (mask == null) {
            return null;
        }
        boolean bl = animated = originalTexture instanceof AnimatableTexture && (animatableTexture = (AnimatableTexture)originalTexture).isAnimated();
        if (animated) {
            ((AnimatableTexture)originalTexture).animationContents.animatedTexture.setGlowMaskTexture(this, baseImage, mask);
        }
        return () -> {
            if (!animated) {
                AutoGlowingTexture.uploadSimple(this.getId(), mask, blur, clamp);
            }
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                dynamicTexture.upload();
            } else {
                AutoGlowingTexture.uploadSimple(originalTexture.getId(), baseImage, blur, clamp);
            }
        };
    }

    @NotNull
    public static RenderType getRenderType(@NotNull ResourceLocation pTexture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(pTexture), false);
    }

    @NotNull
    public static RenderType getOutlineRenderType(@NotNull ResourceLocation pTexture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(pTexture), true);
    }
}

