/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.variants;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.minecraft.CompoundTagUtils;
import software.bluelib.loader.cache.variants.VariantCache;

public record EntityCache(@NotNull String formatVersion, @NotNull Map<String, VariantCache> variants) {
    @NotNull
    public static final Codec<EntityCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)EntityCache.readFromNBT(tag));
    }, entityCache -> {
        CompoundTag tag = new CompoundTag();
        entityCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<EntityCache> ENTITY_CACHE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putString("formatVersion", this.formatVersion);
        CompoundTagUtils.writeMap(pTag, "variants", this.variants, (tag, key) -> tag.putString("name", key), (tag, value) -> value.writeToNBT((CompoundTag)tag), "name", "data");
    }

    @NotNull
    public static EntityCache readFromNBT(@NotNull CompoundTag pTag) {
        String formatVersion = pTag.getString("formatVersion");
        Map<String, VariantCache> variants = CompoundTagUtils.readMap(pTag, "variants", tag -> tag.getString("name"), VariantCache::readFromNBT, "name", "data");
        return new EntityCache(formatVersion, variants);
    }

    @NotNull
    public Set<String> getVariantNames() {
        return this.variants.keySet();
    }

    @Nullable
    public VariantCache getVariant(@NotNull String pName) {
        return this.variants.get(pName);
    }
}

