/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.geckolib.math;

import com.google.common.collect.Streams;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToDoubleFunction;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import software.bluelib.client.utils.PlayerUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.geckolib.math.value.Variable;

public final class MoLangQueries {
    public static final String ACTOR_COUNT = "q.actor_count";
    public static final String ANIM_TIME = "q.anim_time";
    public static final String BLOCKING = "q.blocking";
    public static final String BLOCK_STATE = "q.block_state";
    public static final String BODY_X_ROTATION = "q.body_x_rotation";
    public static final String BODY_Y_ROTATION = "q.body_y_rotation";
    public static final String CAN_CLIMB = "q.can_climb";
    public static final String CAN_FLY = "q.can_fly";
    public static final String CAN_SWIM = "q.can_swim";
    public static final String CAN_WALK = "q.can_walk";
    public static final String CARDINAL_FACING = "q.cardinal_facing";
    public static final String CARDINAL_FACING_2D = "q.cardinal_facing_2d";
    public static final String CARDINAL_PLAYER_FACING = "q.cardinal_player_facing";
    public static final String CONTROLLER_SPEED = "q.controller_speed";
    public static final String DAY = "q.day";
    public static final String DEATH_TICKS = "q.death_ticks";
    public static final String DISTANCE_FROM_CAMERA = "q.distance_from_camera";
    public static final String EQUIPMENT_COUNT = "q.equipment_count";
    public static final String FRAME_ALPHA = "q.frame_alpha";
    public static final String GET_ACTOR_INFO_ID = "q.get_actor_info_id";
    public static final String GROUND_SPEED = "q.ground_speed";
    public static final String HAS_CAPE = "q.has_cape";
    public static final String HAS_COLLISION = "q.has_collision";
    public static final String HAS_GRAVITY = "q.has_gravity";
    public static final String HAS_HEAD_GEAR = "q.has_head_gear";
    public static final String HAS_OWNER = "q.has_owner";
    public static final String HAS_PLAYER_RIDER = "q.has_player_rider";
    public static final String HAS_RIDER = "q.has_rider";
    public static final String HEAD_X_ROTATION = "q.head_x_rotation";
    public static final String HEAD_Y_ROTATION = "q.head_y_rotation";
    public static final String HEALTH = "q.health";
    public static final String HURT_TIME = "q.hurt_time";
    public static final String INVULNERABLE_TICKS = "q.invulnerable_ticks";
    public static final String IS_ALIVE = "q.is_alive";
    public static final String IS_ANGRY = "q.is_angry";
    public static final String IS_BABY = "q.is_baby";
    public static final String IS_BREATHING = "q.is_breathing";
    public static final String IS_ENCHANTED = "q.is_enchanted";
    public static final String IS_FIRE_IMMUNE = "q.is_fire_immune";
    public static final String IS_FIRST_PERSON = "q.is_first_person";
    public static final String IS_INVISIBLE = "q.is_invisible";
    public static final String IS_IN_CONTACT_WITH_WATER = "q.is_in_contact_with_water";
    public static final String IS_IN_LAVA = "q.is_in_lava";
    public static final String IS_IN_WATER = "q.is_in_water";
    public static final String IS_IN_WATER_OR_RAIN = "q.is_in_water_or_rain";
    public static final String IS_LEASHED = "q.is_leashed";
    public static final String IS_MOVING = "q.is_moving";
    public static final String IS_ON_FIRE = "q.is_on_fire";
    public static final String IS_ON_GROUND = "q.is_on_ground";
    public static final String IS_POWERED = "q.is_powered";
    public static final String IS_RIDING = "q.is_riding";
    public static final String IS_SADDLED = "q.is_saddled";
    public static final String IS_SILENT = "q.is_silent";
    public static final String IS_SLEEPING = "q.is_sleeping";
    public static final String IS_SNEAKING = "q.is_sneaking";
    public static final String IS_SPRINTING = "q.is_sprinting";
    public static final String IS_STACKABLE = "q.is_stackable";
    public static final String IS_SWIMMING = "q.is_swimming";
    public static final String IS_USING_ITEM = "q.is_using_item";
    public static final String IS_WALL_CLIMBING = "q.is_wall_climbing";
    public static final String ITEM_MAX_USE_DURATION = "q.item_max_use_duration";
    public static final String LIFE_TIME = "q.life_time";
    public static final String MAIN_HAND_ITEM_MAX_DURATION = "q.main_hand_item_max_duration";
    public static final String MAIN_HAND_ITEM_USE_DURATION = "q.main_hand_item_use_duration";
    public static final String MAX_DURABILITY = "q.max_durability";
    public static final String MAX_HEALTH = "q.max_health";
    public static final String MOON_BRIGHTNESS = "q.moon_brightness";
    public static final String MOON_PHASE = "q.moon_phase";
    public static final String MOVEMENT_DIRECTION = "q.movement_direction";
    public static final String PLAYER_LEVEL = "q.player_level";
    public static final String REMAINING_DURABILITY = "q.remaining_durability";
    public static final String RIDER_BODY_X_ROTATION = "q.rider_body_x_rotation";
    public static final String RIDER_BODY_Y_ROTATION = "q.rider_body_y_rotation";
    public static final String RIDER_HEAD_X_ROTATION = "q.rider_head_x_rotation";
    public static final String RIDER_HEAD_Y_ROTATION = "q.rider_head_y_rotation";
    public static final String SCALE = "q.scale";
    public static final String SLEEP_ROTATION = "q.sleep_rotation";
    public static final String TIME_OF_DAY = "q.time_of_day";
    public static final String TIME_STAMP = "q.time_stamp";
    public static final String VERTICAL_SPEED = "q.vertical_speed";
    public static final String YAW_SPEED = "q.yaw_speed";
    private static final Map<String, Variable> VARIABLES = new ConcurrentHashMap<String, Variable>();
    private static Actor<?> ACTOR = null;

    public static boolean isExistingVariable(String pName) {
        return VARIABLES.containsKey(pName);
    }

    static void registerVariable(Variable pVariable) {
        VARIABLES.put(pVariable.name(), pVariable);
    }

    static Variable getVariableFor(String pName) {
        return VARIABLES.computeIfAbsent(MoLangQueries.applyPrefixAliases(pName, "q.", "q."), key -> new Variable((String)key, 0.0));
    }

    private static String applyPrefixAliases(String pText, String pProperName, String ... pAliases) {
        for (String alias : pAliases) {
            if (!pText.startsWith(alias)) continue;
            return pProperName + pText.substring(alias.length());
        }
        return pText;
    }

    public static void updateActor(AnimationState<? extends BlueAnimatable> pAnimationState, double pAnimTime) {
        ACTOR = new Actor<BlueAnimatable>(pAnimationState, pAnimationState.getAnimatable(), pAnimTime, Minecraft.getInstance(), (Level)Minecraft.getInstance().level);
    }

    public static void clearActor() {
        ACTOR = null;
    }

    public static <T> void setActorVariable(String pName, ToDoubleFunction<Actor<T>> pValue) {
        MoLangQueries.getVariableFor(pName).set(() -> pValue.applyAsDouble(MoLangQueries.getActor()));
    }

    private static Actor<?> getActor() {
        return ACTOR;
    }

    private static void setDefaultQueryValues() {
        MoLangQueries.getVariableFor("PI").set(Math.PI);
        MoLangQueries.getVariableFor("E").set(Math.E);
        MoLangQueries.setActorVariable(CONTROLLER_SPEED, actor -> actor.animationState.getController().getAnimationSpeed());
        MoLangQueries.setActorVariable(CARDINAL_PLAYER_FACING, actor -> actor.mc.player.getDirection().ordinal());
        MoLangQueries.setActorVariable(DAY, actor -> (double)actor.level.getGameTime() / 24000.0);
        MoLangQueries.setActorVariable(FRAME_ALPHA, actor -> actor.animationState().getPartialTick());
        MoLangQueries.setActorVariable(HAS_CAPE, actor -> actor.mc.player.getSkin().capeTexture() != null ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_FIRST_PERSON, actor -> actor.mc.options.getCameraType() == CameraType.FIRST_PERSON ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(LIFE_TIME, actor -> actor.animTime / 20.0);
        MoLangQueries.setActorVariable(MOON_BRIGHTNESS, actor -> actor.level.getMoonBrightness());
        MoLangQueries.setActorVariable(MOON_PHASE, actor -> actor.level.getMoonPhase());
        MoLangQueries.setActorVariable(PLAYER_LEVEL, actor -> actor.mc.player.experienceLevel);
        MoLangQueries.setActorVariable(TIME_OF_DAY, actor -> (float)actor.level.getDayTime() / 24000.0f);
        MoLangQueries.setActorVariable(TIME_STAMP, actor -> actor.mc.level.getGameTime());
        MoLangQueries.setDefaultBlockEntityQueryValues();
        MoLangQueries.setDefaultEntityQueryValues();
        MoLangQueries.setDefaultLivingEntityQueryValues();
        MoLangQueries.setDefaultMobQueryValues();
        MoLangQueries.setDefaultItemQueryValues();
    }

    private static void setDefaultBlockEntityQueryValues() {
        MoLangQueries.setActorVariable(BLOCK_STATE, actor -> ((BlockEntity)actor.animatable).getBlockState().getBlock().getStateDefinition().getPossibleStates().indexOf((Object)((BlockEntity)actor.animatable).getBlockState()));
    }

    private static void setDefaultEntityQueryValues() {
        MoLangQueries.setActorVariable(BODY_X_ROTATION, actor -> actor.animatable instanceof LivingEntity ? 0.0 : (double)((Entity)actor.animatable).getViewXRot(actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(BODY_Y_ROTATION, actor -> {
            float f;
            Object patt0$temp = actor.animatable;
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                f = Mth.lerp((float)actor.animationState.getPartialTick(), (float)living.yBodyRotO, (float)living.yBodyRot);
            } else {
                f = ((Entity)actor.animatable).getViewYRot(actor.animationState.getPartialTick());
            }
            return f;
        });
        MoLangQueries.setActorVariable(CARDINAL_FACING, actor -> ((Entity)actor.animatable).getDirection().get3DDataValue());
        MoLangQueries.setActorVariable(CARDINAL_FACING_2D, actor -> {
            int directionId = ((Entity)actor.animatable).getDirection().get3DDataValue();
            return directionId < 2 ? 6.0 : (double)directionId;
        });
        MoLangQueries.setActorVariable(DISTANCE_FROM_CAMERA, actor -> actor.mc.gameRenderer.getMainCamera().getPosition().distanceTo(((Entity)actor.animatable).position()));
        MoLangQueries.setActorVariable(GET_ACTOR_INFO_ID, actor -> ((Entity)actor.animatable).getId());
        MoLangQueries.setActorVariable(HAS_COLLISION, actor -> !((Entity)actor.animatable).noPhysics ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(HAS_GRAVITY, actor -> !((Entity)actor.animatable).isNoGravity() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(HAS_OWNER, actor -> {
            OwnableEntity ownable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof OwnableEntity && (ownable = (OwnableEntity)patt0$temp).getOwnerUUID() != null ? 1 : 0;
        });
        MoLangQueries.setActorVariable(HAS_PLAYER_RIDER, actor -> ((Entity)actor.animatable).hasPassenger(Player.class::isInstance) ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(HAS_RIDER, actor -> ((Entity)actor.animatable).isVehicle() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_ALIVE, actor -> ((Entity)actor.animatable).isAlive() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_ANGRY, actor -> {
            NeutralMob neutralMob;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof NeutralMob && (neutralMob = (NeutralMob)patt0$temp).isAngry() ? 1 : 0;
        });
        MoLangQueries.setActorVariable(IS_BREATHING, actor -> ((Entity)actor.animatable).getAirSupply() >= ((Entity)actor.animatable).getMaxAirSupply() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_FIRE_IMMUNE, actor -> ((Entity)actor.animatable).getType().fireImmune() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_INVISIBLE, actor -> ((Entity)actor.animatable).isInvisible() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_IN_CONTACT_WITH_WATER, actor -> ((Entity)actor.animatable).isInWaterRainOrBubble() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_IN_LAVA, actor -> ((Entity)actor.animatable).isInLava() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_IN_WATER, actor -> ((Entity)actor.animatable).isInWater() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_IN_WATER_OR_RAIN, actor -> ((Entity)actor.animatable).isInWaterOrRain() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_LEASHED, actor -> {
            Leashable leashable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof Leashable && (leashable = (Leashable)patt0$temp).isLeashed() ? 1 : 0;
        });
        MoLangQueries.setActorVariable(IS_MOVING, actor -> actor.animationState.isMoving() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_ON_FIRE, actor -> ((Entity)actor.animatable).isOnFire() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_ON_GROUND, actor -> ((Entity)actor.animatable).onGround() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_POWERED, actor -> {
            PowerableMob powerable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof PowerableMob && (powerable = (PowerableMob)patt0$temp).isPowered() ? 1 : 0;
        });
        MoLangQueries.setActorVariable(IS_RIDING, actor -> ((Entity)actor.animatable).isPassenger() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SADDLED, actor -> {
            Saddleable saddleable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof Saddleable && (saddleable = (Saddleable)patt0$temp).isSaddled() ? 1 : 0;
        });
        MoLangQueries.setActorVariable(IS_SILENT, actor -> ((Entity)actor.animatable).isSilent() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SNEAKING, actor -> ((Entity)actor.animatable).isCrouching() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SPRINTING, actor -> ((Entity)actor.animatable).isSprinting() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SWIMMING, actor -> ((Entity)actor.animatable).isSwimming() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(MOVEMENT_DIRECTION, actor -> actor.animationState.isMoving() ? (double)Direction.getNearest((Vec3)((Entity)actor.animatable).getDeltaMovement()).get3DDataValue() : 6.0);
        MoLangQueries.setActorVariable(RIDER_BODY_X_ROTATION, actor -> ((Entity)actor.animatable).isVehicle() ? (((Entity)actor.animatable).getFirstPassenger() instanceof LivingEntity ? 0.0 : (double)((Entity)actor.animatable).getFirstPassenger().getViewXRot(actor.animationState.getPartialTick())) : 0.0);
        MoLangQueries.setActorVariable(RIDER_BODY_Y_ROTATION, actor -> {
            float f;
            if (((Entity)actor.animatable).isVehicle()) {
                Entity patt0$temp = ((Entity)actor.animatable).getFirstPassenger();
                if (patt0$temp instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)patt0$temp;
                    f = Mth.lerp((float)actor.animationState.getPartialTick(), (float)living.yBodyRotO, (float)living.yBodyRot);
                } else {
                    f = ((Entity)actor.animatable).getFirstPassenger().getViewYRot(actor.animationState.getPartialTick());
                }
            } else {
                f = 0.0f;
            }
            return f;
        });
        MoLangQueries.setActorVariable(RIDER_HEAD_X_ROTATION, actor -> {
            double d;
            Entity patt0$temp = ((Entity)actor.animatable).getFirstPassenger();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                d = living.getViewXRot(actor.animationState.getPartialTick());
            } else {
                d = 0.0;
            }
            return d;
        });
        MoLangQueries.setActorVariable(RIDER_HEAD_Y_ROTATION, actor -> {
            double d;
            Entity patt0$temp = ((Entity)actor.animatable).getFirstPassenger();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                d = living.getViewYRot(actor.animationState.getPartialTick());
            } else {
                d = 0.0;
            }
            return d;
        });
        MoLangQueries.setActorVariable(VERTICAL_SPEED, actor -> ((Entity)actor.animatable).getDeltaMovement().y);
        MoLangQueries.setActorVariable(YAW_SPEED, actor -> ((Entity)actor.animatable).getYRot() - ((Entity)actor.animatable).yRotO);
    }

    private static void setDefaultLivingEntityQueryValues() {
        MoLangQueries.setActorVariable(BLOCKING, actor -> ((LivingEntity)actor.animatable).isBlocking() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(DEATH_TICKS, actor -> ((LivingEntity)actor.animatable).deathTime == 0 ? 0.0 : (double)((float)((LivingEntity)actor.animatable).deathTime + actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(EQUIPMENT_COUNT, actor -> Streams.stream((Iterable)((LivingEntity)actor.animatable).getArmorSlots()).filter(stack -> !stack.isEmpty()).count());
        MoLangQueries.setActorVariable(GROUND_SPEED, actor -> ((LivingEntity)actor.animatable).getDeltaMovement().horizontalDistance());
        MoLangQueries.setActorVariable(HAS_HEAD_GEAR, actor -> !((LivingEntity)actor.animatable).getItemBySlot(EquipmentSlot.HEAD).isEmpty() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(HEAD_X_ROTATION, actor -> ((LivingEntity)actor.animatable).getViewXRot(actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(HEAD_Y_ROTATION, actor -> ((LivingEntity)actor.animatable).getViewYRot(actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(HEALTH, actor -> ((LivingEntity)actor.animatable).getHealth());
        MoLangQueries.setActorVariable(HURT_TIME, actor -> ((LivingEntity)actor.animatable).hurtTime == 0 ? 0.0 : (double)((float)((LivingEntity)actor.animatable).hurtTime - actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(INVULNERABLE_TICKS, actor -> ((LivingEntity)actor.animatable).invulnerableTime == 0 ? 0.0 : (double)((float)((LivingEntity)actor.animatable).invulnerableTime - actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(IS_BABY, actor -> ((LivingEntity)actor.animatable).isBaby() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SLEEPING, actor -> ((LivingEntity)actor.animatable).isSleeping() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_USING_ITEM, actor -> ((LivingEntity)actor.animatable).isUsingItem() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_WALL_CLIMBING, actor -> ((LivingEntity)actor.animatable).onClimbable() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(MAIN_HAND_ITEM_MAX_DURATION, actor -> ((LivingEntity)actor.animatable).getMainHandItem().getUseDuration((LivingEntity)actor.animatable));
        MoLangQueries.setActorVariable(MAIN_HAND_ITEM_USE_DURATION, actor -> ((LivingEntity)actor.animatable).getUsedItemHand() == InteractionHand.MAIN_HAND ? (double)((LivingEntity)actor.animatable).getTicksUsingItem() / 20.0 + (double)actor.animationState.getPartialTick() : 0.0);
        MoLangQueries.setActorVariable(MAX_HEALTH, actor -> ((LivingEntity)actor.animatable).getMaxHealth());
        MoLangQueries.setActorVariable(SCALE, actor -> ((LivingEntity)actor.animatable).getScale());
        MoLangQueries.setActorVariable(SLEEP_ROTATION, actor -> Optional.ofNullable(((LivingEntity)actor.animatable).getBedOrientation()).map(Direction::toYRot).orElse(Float.valueOf(0.0f)).floatValue());
    }

    private static void setDefaultMobQueryValues() {
        MoLangQueries.setActorVariable(CAN_CLIMB, actor -> !((Mob)actor.animatable).isNoAi() && ((Mob)actor.animatable).getNavigation() instanceof WallClimberNavigation ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(CAN_FLY, actor -> !((Mob)actor.animatable).isNoAi() && ((Mob)actor.animatable).getNavigation() instanceof FlyingPathNavigation ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(CAN_SWIM, actor -> !((Mob)actor.animatable).isNoAi() && ((Mob)actor.animatable).getNavigation() instanceof WaterBoundPathNavigation || ((Mob)actor.animatable).getNavigation() instanceof AmphibiousPathNavigation ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(CAN_WALK, actor -> !((Mob)actor.animatable).isNoAi() && ((Mob)actor.animatable).getNavigation() instanceof GroundPathNavigation || ((Mob)actor.animatable).getNavigation() instanceof AmphibiousPathNavigation ? 1.0 : 0.0);
    }

    private static void setDefaultItemQueryValues() {
        MoLangQueries.setActorVariable(IS_ENCHANTED, actor -> actor.animationState.getData(DataTickets.ITEMSTACK).isEnchanted() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_STACKABLE, actor -> actor.animationState.getData(DataTickets.ITEMSTACK).isStackable() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(ITEM_MAX_USE_DURATION, actor -> actor.animationState.getData(DataTickets.ITEMSTACK).getUseDuration((LivingEntity)PlayerUtils.getClientPlayer()));
        MoLangQueries.setActorVariable(MAX_DURABILITY, actor -> actor.animationState.getData(DataTickets.ITEMSTACK).getMaxDamage());
        MoLangQueries.setActorVariable(REMAINING_DURABILITY, actor -> {
            ItemStack stack = actor.animationState.getData(DataTickets.ITEMSTACK);
            return stack.isDamageableItem() ? (double)(stack.getMaxDamage() - stack.getDamageValue()) : 1.0;
        });
    }

    static {
        MoLangQueries.setDefaultQueryValues();
    }

    public record Actor<T>(AnimationState<? extends BlueAnimatable> animationState, T animatable, double animTime, Minecraft mc, Level level) {
    }
}

