/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.animation;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.doubles.DoubleObjectPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.exception.CompoundException;
import software.bluelib.api.utils.loader.JsonUtils;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.loader.animation.math.Easing;
import software.bluelib.loader.cache.animations.AnimationCache;
import software.bluelib.loader.cache.animations.AnimationLibraryCache;
import software.bluelib.loader.cache.animations.keyframe.BoneAnimationCache;
import software.bluelib.loader.cache.animations.keyframe.KeyframeCache;
import software.bluelib.loader.cache.animations.keyframe.KeyframeLibraryCache;
import software.bluelib.loader.cache.animations.keyframe.KeyframeStackCache;
import software.bluelib.loader.geckolib.math.MathParser;
import software.bluelib.loader.geckolib.math.MathValue;
import software.bluelib.loader.geckolib.math.value.Constant;

public class BakedAnimationsAdapter
implements JsonDeserializer<AnimationLibraryCache> {
    @Nullable
    public static ConcurrentMap<Double, Constant> COMPRESSION_CACHE = null;

    @NotNull
    public AnimationLibraryCache deserialize(@NotNull JsonElement pJson, @NotNull Type pType, @NotNull JsonDeserializationContext pContext) throws RuntimeException {
        JsonObject obj = pJson.getAsJsonObject();
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap(obj.size());
        for (Map.Entry entry : obj.entrySet()) {
            try {
                animations.put((String)entry.getKey(), this.bakeAnimation((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject(), pContext));
            }
            catch (Exception pException) {
                if (pException instanceof CompoundException) {
                    CompoundException compoundEx = (CompoundException)pException;
                    BaseLogger.log(BaseLogLevel.ERROR, compoundEx.withMessage("Unable to parse animation: " + (String)entry.getKey()).getLocalizedMessage(), compoundEx);
                }
                throw new JsonParseException("Failed to parse animations", (Throwable)pException);
            }
        }
        return new AnimationLibraryCache((Map<String, AnimationCache>)animations);
    }

    @NotNull
    private AnimationCache bakeAnimation(@NotNull String pName, @NotNull JsonObject pAnimationObj, @NotNull JsonDeserializationContext pContext) throws CompoundException {
        double length = pAnimationObj.has("animation_length") ? GsonHelper.getAsDouble((JsonObject)pAnimationObj, (String)"animation_length") * 20.0 : -1.0;
        AnimationCache.LoopType loopType = AnimationCache.LoopType.fromJson(pAnimationObj.get("loop"));
        BoneAnimationCache[] boneAnimationCaches = this.bakeBoneAnimations(GsonHelper.getAsJsonObject((JsonObject)pAnimationObj, (String)"bones", (JsonObject)new JsonObject()));
        KeyframeLibraryCache keyframes = (KeyframeLibraryCache)pContext.deserialize((JsonElement)pAnimationObj, KeyframeLibraryCache.class);
        if (length == -1.0) {
            length = BakedAnimationsAdapter.calculateAnimationLength(boneAnimationCaches);
        }
        return new AnimationCache(pName, length, loopType, boneAnimationCaches, keyframes);
    }

    @NotNull
    private BoneAnimationCache[] bakeBoneAnimations(@NotNull JsonObject pBonesObj) throws CompoundException {
        BoneAnimationCache[] animations = new BoneAnimationCache[pBonesObj.size()];
        int index = 0;
        for (Map.Entry entry : pBonesObj.entrySet()) {
            JsonObject entryObj = ((JsonElement)entry.getValue()).getAsJsonObject();
            KeyframeStackCache<KeyframeCache<MathValue>> scaleFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getKeyframes(entryObj.get("scale")), false);
            KeyframeStackCache<KeyframeCache<MathValue>> positionFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getKeyframes(entryObj.get("position")), false);
            KeyframeStackCache<KeyframeCache<MathValue>> rotationFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getKeyframes(entryObj.get("rotation")), true);
            animations[index] = new BoneAnimationCache((String)entry.getKey(), rotationFrames, positionFrames, scaleFrames);
            ++index;
        }
        return animations;
    }

    @NotNull
    private static List<DoubleObjectPair<JsonElement>> getKeyframes(@Nullable JsonElement pElement) {
        if (pElement == null) {
            return List.of();
        }
        if (pElement instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)pElement;
            JsonArray array = new JsonArray(3);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            pElement = array;
        }
        if (pElement instanceof JsonArray) {
            JsonArray array = (JsonArray)pElement;
            return ObjectArrayList.of((Object[])new DoubleObjectPair[]{DoubleObjectPair.of((double)0.0, (Object)array)});
        }
        if (pElement instanceof JsonObject) {
            JsonObject obj = (JsonObject)pElement;
            if (obj.has("vector")) {
                return ObjectArrayList.of((Object[])new DoubleObjectPair[]{DoubleObjectPair.of((double)0.0, (Object)obj)});
            }
            ObjectArrayList list = new ObjectArrayList();
            for (Map.Entry entry : obj.entrySet()) {
                JsonObject entryObj;
                double timestamp = BakedAnimationsAdapter.readTimestamp((String)entry.getKey());
                if (timestamp == 0.0 && !list.isEmpty()) {
                    throw new JsonParseException("Invalid keyframe data - multiple starting keyframes?" + (String)entry.getKey());
                }
                Object v = entry.getValue();
                if (v instanceof JsonObject && !(entryObj = (JsonObject)v).has("vector")) {
                    BakedAnimationsAdapter.addBedrockKeyframes(timestamp, entryObj, (List<DoubleObjectPair<JsonElement>>)list);
                    continue;
                }
                list.add(DoubleObjectPair.of((double)timestamp, (Object)((JsonElement)entry.getValue())));
            }
            return list;
        }
        throw new JsonParseException("Invalid object type provided to getTripletObj, got: " + String.valueOf(pElement));
    }

    private static void addBedrockKeyframes(double pTimestamp, @NotNull JsonObject pKeyframe, @NotNull List<DoubleObjectPair<JsonElement>> pKeyframes) {
        boolean addedFrame = false;
        if (pKeyframe.has("pre")) {
            JsonElement pre = pKeyframe.get("pre");
            addedFrame = true;
            pKeyframes.add((DoubleObjectPair<JsonElement>)DoubleObjectPair.of((double)(pTimestamp == 0.0 ? pTimestamp : pTimestamp - 0.001), (Object)(pre.isJsonArray() ? pre.getAsJsonArray() : GsonHelper.getAsJsonArray((JsonObject)pre.getAsJsonObject(), (String)"vector"))));
        }
        if (pKeyframe.has("post")) {
            JsonArray values;
            JsonElement post = pKeyframe.get("post");
            JsonArray jsonArray = values = post.isJsonArray() ? post.getAsJsonArray() : GsonHelper.getAsJsonArray((JsonObject)post.getAsJsonObject(), (String)"vector");
            if (pKeyframe.has("lerp_mode")) {
                JsonObject keyframeObj = new JsonObject();
                keyframeObj.add("vector", (JsonElement)values);
                keyframeObj.add("easing", pKeyframe.get("lerp_mode"));
                pKeyframes.add((DoubleObjectPair<JsonElement>)DoubleObjectPair.of((double)pTimestamp, (Object)keyframeObj));
            } else {
                pKeyframes.add((DoubleObjectPair<JsonElement>)DoubleObjectPair.of((double)pTimestamp, (Object)values));
            }
            return;
        }
        if (!addedFrame) {
            throw new JsonParseException("Invalid keyframe data - expected array, found " + String.valueOf(pKeyframe));
        }
    }

    @NotNull
    private KeyframeStackCache<KeyframeCache<MathValue>> buildKeyframeStack(@NotNull List<DoubleObjectPair<JsonElement>> pEntries, boolean pIsForRotation) throws CompoundException {
        if (pEntries.isEmpty()) {
            return new KeyframeStackCache<KeyframeCache<MathValue>>();
        }
        ObjectArrayList xFrames = new ObjectArrayList();
        ObjectArrayList yFrames = new ObjectArrayList();
        ObjectArrayList zFrames = new ObjectArrayList();
        MathValue xPrev = null;
        MathValue yPrev = null;
        MathValue zPrev = null;
        DoubleObjectPair<JsonElement> prevEntry = null;
        for (DoubleObjectPair<JsonElement> entry : pEntries) {
            JsonObject obj;
            JsonArray array;
            JsonElement element = (JsonElement)entry.right();
            double prevTime = prevEntry != null ? prevEntry.leftDouble() : 0.0;
            double curTime = entry.leftDouble();
            double timeDelta = curTime - prevTime;
            JsonArray keyFrameVector = element instanceof JsonArray ? (array = (JsonArray)element) : GsonHelper.getAsJsonArray((JsonObject)element.getAsJsonObject(), (String)"vector");
            MathValue rawXValue = MathParser.parseJson(keyFrameVector.get(0));
            MathValue rawYValue = MathParser.parseJson(keyFrameVector.get(1));
            MathValue rawZValue = MathParser.parseJson(keyFrameVector.get(2));
            MathValue xValue = this.compressMathValue(pIsForRotation && rawXValue instanceof Constant ? new Constant(Math.toRadians(-rawXValue.get())) : rawXValue);
            MathValue yValue = this.compressMathValue(pIsForRotation && rawYValue instanceof Constant ? new Constant(Math.toRadians(-rawYValue.get())) : rawYValue);
            MathValue zValue = this.compressMathValue(pIsForRotation && rawZValue instanceof Constant ? new Constant(Math.toRadians(rawZValue.get())) : rawZValue);
            JsonObject entryObj = element instanceof JsonObject ? (obj = (JsonObject)element) : null;
            Easing easing = entryObj != null && entryObj.has("easing") ? Easing.fromJson(entryObj.get("easing")) : Easing.LINEAR;
            ObjectArrayList easingArgs = entryObj != null && entryObj.has("easingArgs") ? JsonUtils.jsonArrayToList(GsonHelper.getAsJsonArray((JsonObject)entryObj, (String)"easingArgs"), ele -> new Constant(ele.getAsDouble())) : new ObjectArrayList();
            xFrames.add(new KeyframeCache<MathValue>(timeDelta * 20.0, prevEntry == null ? xValue : xPrev, xValue, easing, (List<MathValue>)easingArgs));
            yFrames.add(new KeyframeCache<MathValue>(timeDelta * 20.0, prevEntry == null ? yValue : yPrev, yValue, easing, (List<MathValue>)easingArgs));
            zFrames.add(new KeyframeCache<MathValue>(timeDelta * 20.0, prevEntry == null ? zValue : zPrev, zValue, easing, (List<MathValue>)easingArgs));
            xPrev = xValue;
            yPrev = yValue;
            zPrev = zValue;
            prevEntry = entry;
        }
        return new KeyframeStackCache<KeyframeCache<MathValue>>(this.addSplineArgs((List<KeyframeCache<MathValue>>)xFrames), this.addSplineArgs((List<KeyframeCache<MathValue>>)yFrames), this.addSplineArgs((List<KeyframeCache<MathValue>>)zFrames));
    }

    @NotNull
    private List<KeyframeCache<MathValue>> addSplineArgs(@NotNull List<KeyframeCache<MathValue>> pFrames) {
        KeyframeCache<MathValue> frame;
        if (pFrames.size() == 1 && (frame = pFrames.getFirst()).easing() != Easing.LINEAR) {
            pFrames.set(0, new KeyframeCache<MathValue>(frame.length(), frame.startValue(), frame.endValue()));
            return pFrames;
        }
        for (int i = 0; i < pFrames.size(); ++i) {
            KeyframeCache<MathValue> frame2 = pFrames.get(i);
            if (frame2.easing() != Easing.CATMULLROM) continue;
            pFrames.set(i, new KeyframeCache<MathValue>(frame2.length(), frame2.startValue(), frame2.endValue(), frame2.easing(), (List<MathValue>)ObjectArrayList.of((Object[])new MathValue[]{i == 0 ? frame2.startValue() : pFrames.get(i - 1).endValue(), i + 1 >= pFrames.size() ? frame2.endValue() : pFrames.get(i + 1).endValue()})));
        }
        return pFrames;
    }

    @NotNull
    private MathValue compressMathValue(@NotNull MathValue pInput) {
        if (COMPRESSION_CACHE == null || pInput.isMutable()) {
            return pInput;
        }
        return COMPRESSION_CACHE.computeIfAbsent(pInput.get(), Constant::new);
    }

    private static double calculateAnimationLength(@NotNull BoneAnimationCache[] pBoneAnimationCaches) {
        double length = 0.0;
        for (BoneAnimationCache animation : pBoneAnimationCaches) {
            length = Math.max(length, animation.rotationKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.positionKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.scaleKeyFrames().getLastKeyframeTime());
        }
        return length == 0.0 ? Double.MAX_VALUE : length;
    }

    private static double readTimestamp(@NotNull String pTimestamp) {
        return NumberUtils.isCreatable((String)pTimestamp) ? Double.parseDouble(pTimestamp) : 0.0;
    }
}

