/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.CubeCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.json.CacheFactory;
import software.bluelib.loader.json.deserialize.model.Bone;
import software.bluelib.loader.json.deserialize.model.Cube;
import software.bluelib.loader.json.deserialize.model.FaceUV;
import software.bluelib.loader.json.deserialize.model.Model;
import software.bluelib.loader.json.deserialize.model.ModelDescription;
import software.bluelib.loader.json.deserialize.model.UVUnion;
import software.bluelib.loader.json.model.object.BoneStructure;
import software.bluelib.loader.json.model.object.BoneTree;
import software.bluelib.loader.json.object.QuadData;
import software.bluelib.loader.json.object.VertexData;

public interface ModelCacheFactory
extends CacheFactory<ModelCache, Model> {
    @NotNull
    public static final Map<String, ModelCacheFactory> FACTORIES = new Object2ObjectOpenHashMap(1);
    @NotNull
    public static final ModelCacheFactory DEFAULT_FACTORY = new Builtin();
    @NotNull
    public static final CacheFactory.Registry<ModelCache, Model, ModelCacheFactory> REGISTRY = new CacheFactory.Registry<ModelCache, Model, ModelCacheFactory>(){

        @Override
        @NotNull
        public Map<String, ModelCacheFactory> factories() {
            return FACTORIES;
        }

        @Override
        @NotNull
        public ModelCacheFactory defaultFactory() {
            return DEFAULT_FACTORY;
        }
    };

    @Override
    @NotNull
    default public ModelCache construct(@NotNull Model pSource) {
        return this.constructBlueModel(pSource);
    }

    @NotNull
    public ModelCache constructBlueModel(@NotNull Model var1);

    @NotNull
    public BoneCache constructBone(@NotNull BoneStructure var1, @Nullable ModelDescription var2, @Nullable BoneCache var3);

    @NotNull
    public CubeCache constructCube(@NotNull Cube var1, @Nullable ModelDescription var2, @NotNull BoneCache var3);

    @NotNull
    default public List<QuadData> buildQuads(@NotNull UVUnion pUvUnion, @NotNull VertexSet pVertices, @NotNull Cube pCube, @NotNull Float pTextureWidth, @NotNull Float pTextureHeight, boolean pMirror) {
        ArrayList<QuadData> quads = new ArrayList<QuadData>(6);
        quads.add(this.buildQuad(pVertices, pCube, pUvUnion, pTextureWidth, pTextureHeight, pMirror, Direction.WEST));
        quads.add(this.buildQuad(pVertices, pCube, pUvUnion, pTextureWidth, pTextureHeight, pMirror, Direction.EAST));
        quads.add(this.buildQuad(pVertices, pCube, pUvUnion, pTextureWidth, pTextureHeight, pMirror, Direction.NORTH));
        quads.add(this.buildQuad(pVertices, pCube, pUvUnion, pTextureWidth, pTextureHeight, pMirror, Direction.SOUTH));
        quads.add(this.buildQuad(pVertices, pCube, pUvUnion, pTextureWidth, pTextureHeight, pMirror, Direction.UP));
        quads.add(this.buildQuad(pVertices, pCube, pUvUnion, pTextureWidth, pTextureHeight, pMirror, Direction.DOWN));
        return quads;
    }

    @NotNull
    default public QuadData buildQuad(@NotNull VertexSet pVertices, @NotNull Cube pCube, @NotNull UVUnion pUvUnion, @NotNull Float pTextureWidth, @NotNull Float pTextureHeight, boolean pMirror, @NotNull Direction pDirection) {
        if (!pUvUnion.isBoxUV()) {
            FaceUV faceUV = pUvUnion.faceUV().fromDirection(pDirection);
            return QuadData.build(pVertices.verticesForQuad(pDirection, false, pMirror || pCube.mirror() == Boolean.TRUE), faceUV.uv(), faceUV.uvSize(), faceUV.uvRotation(), pTextureWidth, pTextureHeight, pMirror, pDirection);
        }
        List<Float> uv = pCube.uvUnion().boxUVCoords();
        List<Float> uvSize = pCube.size();
        Vec3 uvSizeVec = new Vec3((double)((float)Math.floor(uvSize.get(0).floatValue())), (double)((float)Math.floor(uvSize.get(1).floatValue())), (double)((float)Math.floor(uvSize.get(2).floatValue())));
        List<List<Float>> uvData = switch (pDirection) {
            default -> throw new MatchException(null, null);
            case Direction.WEST -> List.of(List.of(Float.valueOf(uv.get(0).floatValue() + (float)uvSizeVec.z + (float)uvSizeVec.x), Float.valueOf(uv.get(1).floatValue() + (float)uvSizeVec.z)), List.of(Float.valueOf((float)uvSizeVec.z), Float.valueOf((float)uvSizeVec.y)));
            case Direction.EAST -> List.of(List.of(uv.get(0), Float.valueOf(uv.get(1).floatValue() + (float)uvSizeVec.z)), List.of(Float.valueOf((float)uvSizeVec.z), Float.valueOf((float)uvSizeVec.y)));
            case Direction.NORTH -> List.of(List.of(Float.valueOf(uv.get(0).floatValue() + (float)uvSizeVec.z), Float.valueOf(uv.get(1).floatValue() + (float)uvSizeVec.z)), List.of(Float.valueOf((float)uvSizeVec.x), Float.valueOf((float)uvSizeVec.y)));
            case Direction.SOUTH -> List.of(List.of(Float.valueOf(uv.get(0).floatValue() + (float)uvSizeVec.z + (float)uvSizeVec.x + (float)uvSizeVec.z), Float.valueOf(uv.get(1).floatValue() + (float)uvSizeVec.z)), List.of(Float.valueOf((float)uvSizeVec.x), Float.valueOf((float)uvSizeVec.y)));
            case Direction.UP -> List.of(List.of(Float.valueOf(uv.get(0).floatValue() + (float)uvSizeVec.z), uv.get(1)), List.of(Float.valueOf((float)uvSizeVec.x), Float.valueOf((float)uvSizeVec.z)));
            case Direction.DOWN -> List.of(List.of(Float.valueOf(uv.get(0).floatValue() + (float)uvSizeVec.z + (float)uvSizeVec.x), Float.valueOf(uv.get(1).floatValue() + (float)uvSizeVec.z)), List.of(Float.valueOf((float)uvSizeVec.x), Float.valueOf(-((float)uvSizeVec.z))));
        };
        return QuadData.build(pVertices.verticesForQuad(pDirection, true, pMirror || pCube.mirror() == Boolean.TRUE), uvData.get(0), uvData.get(1), FaceUV.Rotation.NONE, pTextureWidth, pTextureHeight, pMirror, pDirection);
    }

    public record VertexSet(@NotNull VertexData bottomLeftBack, @NotNull VertexData bottomRightBack, @NotNull VertexData topLeftBack, @NotNull VertexData topRightBack, @NotNull VertexData topLeftFront, @NotNull VertexData topRightFront, @NotNull VertexData bottomLeftFront, @NotNull VertexData bottomRightFront) {
        public VertexSet(@NotNull Vec3 pOrigin, @NotNull Vec3 pVertexSize, @NotNull Double pInflation) {
            this(new VertexData(pOrigin.x - pInflation, pOrigin.y - pInflation, pOrigin.z - pInflation), new VertexData(pOrigin.x - pInflation, pOrigin.y - pInflation, pOrigin.z + pVertexSize.z + pInflation), new VertexData(pOrigin.x - pInflation, pOrigin.y + pVertexSize.y + pInflation, pOrigin.z - pInflation), new VertexData(pOrigin.x - pInflation, pOrigin.y + pVertexSize.y + pInflation, pOrigin.z + pVertexSize.z + pInflation), new VertexData(pOrigin.x + pVertexSize.x + pInflation, pOrigin.y + pVertexSize.y + pInflation, pOrigin.z - pInflation), new VertexData(pOrigin.x + pVertexSize.x + pInflation, pOrigin.y + pVertexSize.y + pInflation, pOrigin.z + pVertexSize.z + pInflation), new VertexData(pOrigin.x + pVertexSize.x + pInflation, pOrigin.y - pInflation, pOrigin.z - pInflation), new VertexData(pOrigin.x + pVertexSize.x + pInflation, pOrigin.y - pInflation, pOrigin.z + pVertexSize.z + pInflation));
        }

        @NotNull
        public List<VertexData> quadWest() {
            return List.of(this.topRightBack, this.topLeftBack, this.bottomLeftBack, this.bottomRightBack);
        }

        @NotNull
        public List<VertexData> quadEast() {
            return List.of(this.topLeftFront, this.topRightFront, this.bottomRightFront, this.bottomLeftFront);
        }

        @NotNull
        public List<VertexData> quadNorth() {
            return List.of(this.topLeftBack, this.topLeftFront, this.bottomLeftFront, this.bottomLeftBack);
        }

        @NotNull
        public List<VertexData> quadSouth() {
            return List.of(this.topRightFront, this.topRightBack, this.bottomRightBack, this.bottomRightFront);
        }

        @NotNull
        public List<VertexData> quadUp() {
            return List.of(this.topRightBack, this.topRightFront, this.topLeftFront, this.topLeftBack);
        }

        @NotNull
        public List<VertexData> quadDown() {
            return List.of(this.bottomLeftBack, this.bottomLeftFront, this.bottomRightFront, this.bottomRightBack);
        }

        @NotNull
        public List<VertexData> verticesForQuad(@NotNull Direction pDirection, boolean pBoxUv, boolean pMirror) {
            return switch (pDirection) {
                default -> throw new MatchException(null, null);
                case Direction.WEST -> new ArrayList<VertexData>(pMirror ? this.quadEast() : this.quadWest());
                case Direction.EAST -> new ArrayList<VertexData>(pMirror ? this.quadWest() : this.quadEast());
                case Direction.NORTH -> new ArrayList<VertexData>(this.quadNorth());
                case Direction.SOUTH -> new ArrayList<VertexData>(this.quadSouth());
                case Direction.UP -> new ArrayList<VertexData>(pMirror && !pBoxUv ? this.quadDown() : this.quadUp());
                case Direction.DOWN -> new ArrayList<VertexData>(pMirror && !pBoxUv ? this.quadUp() : this.quadDown());
            };
        }
    }

    public static final class Builtin
    implements ModelCacheFactory {
        @Override
        @NotNull
        public ModelCache constructBlueModel(@NotNull Model pModel) {
            BoneTree boneTree = BoneTree.fromModel(pModel);
            ObjectArrayList bones = new ObjectArrayList();
            for (BoneStructure boneStructure : boneTree.topLevelBones().values()) {
                bones.add(this.constructBone(boneStructure, boneTree.description(), null));
            }
            return new ModelCache((List<BoneCache>)bones, boneTree.description());
        }

        @Override
        @NotNull
        public BoneCache constructBone(@NotNull BoneStructure pBoneStructure, @Nullable ModelDescription pModelDescription, @Nullable BoneCache pParent) {
            Bone bone = pBoneStructure.self();
            BoneCache newBone = new BoneCache(pParent, bone.name(), bone.mirror(), bone.inflate(), bone.neverRender(), bone.reset());
            Vec3 rotation = RenderUtils.listToVec(bone.rotation());
            Vec3 pivot = RenderUtils.listToVec(bone.pivot());
            newBone.updateRotation((float)Math.toRadians(-rotation.x), (float)Math.toRadians(-rotation.y), (float)Math.toRadians(rotation.z));
            newBone.updatePivot((float)(-pivot.x), (float)pivot.y, (float)pivot.z);
            for (Cube cube : bone.cubes()) {
                newBone.getCubes().add(this.constructCube(cube, pModelDescription, newBone));
            }
            for (BoneStructure child : pBoneStructure.children().values()) {
                newBone.getChildBones().add(this.constructBone(child, pModelDescription, newBone));
            }
            return newBone;
        }

        @Override
        @NotNull
        public CubeCache constructCube(@NotNull Cube pCube, @Nullable ModelDescription pModelDescription, @NotNull BoneCache pBone) {
            boolean mirror;
            boolean bl = mirror = pCube.mirror() == Boolean.TRUE;
            double inflate = pCube.inflate() != null ? (double)(pCube.inflate().floatValue() / 16.0f) : (double)(pBone.getInflate() == null ? 0.0f : pBone.getInflate().floatValue() / 16.0f);
            Vec3 size = RenderUtils.listToVec(pCube.size());
            Vec3 origin = RenderUtils.listToVec(pCube.origin());
            Vec3 rotation = RenderUtils.listToVec(pCube.rotation());
            Vec3 pivot = RenderUtils.listToVec(pCube.pivot());
            origin = new Vec3(-(origin.x + size.x) / 16.0, origin.y / 16.0, origin.z / 16.0);
            Vec3 vertexSize = size.multiply(0.0625, 0.0625, 0.0625);
            pivot = pivot.multiply(-1.0, 1.0, 1.0);
            rotation = new Vec3(Math.toRadians(-rotation.x), Math.toRadians(-rotation.y), Math.toRadians(rotation.z));
            List<QuadData> quads = this.buildQuads(pCube.uvUnion(), new VertexSet(origin, vertexSize, inflate), pCube, Float.valueOf(pModelDescription.textureWidth()), Float.valueOf(pModelDescription.textureHeight()), mirror);
            return new CubeCache(quads, pivot, rotation, size, inflate, mirror);
        }
    }
}

