/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.utils.Color;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.CubeCache;
import software.bluelib.loader.renderer.armor.BlueArmorRenderer;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.IRenderContext;

public class ItemArmorBlueLayer<T extends LivingEntity>
extends BlueRenderLayer<T> {
    @NotNull
    protected static final HumanoidModel<LivingEntity> INNER_ARMOR_MODEL = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
    @NotNull
    protected static final HumanoidModel<LivingEntity> OUTER_ARMOR_MODEL = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR));
    @Nullable
    protected ItemStack mainHandStack;
    @Nullable
    protected ItemStack offhandStack;
    @Nullable
    protected ItemStack helmetStack;
    @Nullable
    protected ItemStack chestplateStack;
    @Nullable
    protected ItemStack leggingsStack;
    @Nullable
    protected ItemStack bootsStack;

    public ItemArmorBlueLayer(@NotNull BlueRenderer<T> pBlueRenderer) {
        super(pBlueRenderer);
    }

    @NotNull
    protected EquipmentSlot getEquipmentSlotForBone(@NotNull BoneCache pBone, @NotNull ItemStack pStack, @NotNull T pAnimatable) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || pStack != pAnimatable.getItemBySlot(slot)) continue;
            return slot;
        }
        return EquipmentSlot.CHEST;
    }

    @NotNull
    protected ModelPart getModelPartForBone(@NotNull BoneCache pBone, @NotNull EquipmentSlot pSlot, @NotNull ItemStack pStack, @NotNull T pAnimatable, @NotNull HumanoidModel<?> pBaseModel) {
        return pBaseModel.body;
    }

    @Nullable
    protected ItemStack getArmorItemForBone(@NotNull BoneCache pBone, @NotNull T pAnimatable) {
        return null;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.mainHandStack = ((LivingEntity)pContext.animatable()).getItemBySlot(EquipmentSlot.MAINHAND);
        this.offhandStack = ((LivingEntity)pContext.animatable()).getItemBySlot(EquipmentSlot.OFFHAND);
        this.helmetStack = ((LivingEntity)pContext.animatable()).getItemBySlot(EquipmentSlot.HEAD);
        this.chestplateStack = ((LivingEntity)pContext.animatable()).getItemBySlot(EquipmentSlot.CHEST);
        this.leggingsStack = ((LivingEntity)pContext.animatable()).getItemBySlot(EquipmentSlot.LEGS);
        this.bootsStack = ((LivingEntity)pContext.animatable()).getItemBySlot(EquipmentSlot.FEET);
    }

    @Override
    public void renderForBone(@NotNull BoneCache pBone, @NotNull IRenderContext<T> pContext) {
        BlockItem blockItem;
        ItemStack armorStack = this.getArmorItemForBone(pBone, (LivingEntity)pContext.animatable());
        if (armorStack == null) {
            return;
        }
        Item item = armorStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item;
            this.renderSkullAsArmor(pContext.poseStack(), pBone, armorStack, skullBlock, pContext.bufferSource(), pContext.packedLight());
        } else {
            EquipmentSlot slot = this.getEquipmentSlotForBone(pBone, armorStack, (LivingEntity)pContext.animatable());
            HumanoidModel<?> model = this.getModelForItem(pBone, slot, armorStack, (LivingEntity)pContext.animatable());
            ModelPart modelPart = this.getModelPartForBone(pBone, slot, armorStack, (LivingEntity)pContext.animatable(), model);
            if (!modelPart.cubes.isEmpty()) {
                pContext.poseStack().pushPose();
                pContext.poseStack().scale(-1.0f, -1.0f, 1.0f);
                if (model instanceof BlueArmorRenderer) {
                    BlueArmorRenderer BlueArmorRenderer2 = (BlueArmorRenderer)model;
                    this.prepModelPartForRender(pContext.poseStack(), pBone, modelPart);
                    BlueArmorRenderer2.applyBoneVisibilityByPart(slot, modelPart, model);
                    BlueArmorRenderer2.renderToBuffer(pContext.poseStack(), null, pContext.packedLight(), pContext.packedOverlay(), Color.WHITE.argbInt());
                } else if (armorStack.getItem() instanceof ArmorItem) {
                    this.prepModelPartForRender(pContext.poseStack(), pBone, modelPart);
                    this.renderVanillaArmorPiece(pContext.poseStack(), (LivingEntity)pContext.animatable(), pBone, slot, armorStack, modelPart, pContext.bufferSource(), pContext.partialTick(), pContext.packedLight(), pContext.packedOverlay());
                }
                pContext.poseStack().popPose();
            }
        }
    }

    protected <I extends Item> void renderVanillaArmorPiece(@NotNull PoseStack pPoseStack, @NotNull T pAnimatable, @NotNull BoneCache pBone, @NotNull EquipmentSlot pSlot, @NotNull ItemStack pArmorStack, @NotNull ModelPart pModelPart, @NotNull MultiBufferSource pBufferSource, float pPartialTick, int pPackedLight, int pPackedOverlay) {
        Holder material = ((ArmorItem)pArmorStack.getItem()).getMaterial();
        for (ArmorMaterial.Layer layer : ((ArmorMaterial)material.value()).layers()) {
            int color = pArmorStack.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)pArmorStack, (int)-6265536) : -1;
            VertexConsumer buffer = this.getVanillaArmorBuffer(pBufferSource, pAnimatable, pArmorStack, pSlot, pBone, layer, pPackedLight, pPackedOverlay, false);
            pModelPart.render(pPoseStack, buffer, pPackedLight, pPackedOverlay, color);
        }
        ArmorTrim trim = (ArmorTrim)pArmorStack.get(DataComponents.TRIM);
        if (trim != null) {
            TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET).getSprite(pSlot == EquipmentSlot.LEGS ? trim.innerTexture(material) : trim.outerTexture(material));
            VertexConsumer buffer = sprite.wrap(pBufferSource.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
            pModelPart.render(pPoseStack, buffer, pPackedLight, pPackedOverlay);
        }
        if (pArmorStack.hasFoil()) {
            pModelPart.render(pPoseStack, this.getVanillaArmorBuffer(pBufferSource, pAnimatable, pArmorStack, pSlot, pBone, null, pPackedLight, pPackedOverlay, true), pPackedLight, pPackedOverlay, Color.WHITE.argbInt());
        }
    }

    @NotNull
    protected VertexConsumer getVanillaArmorBuffer(@NotNull MultiBufferSource pBufferSource, @NotNull T pAnimatable, @NotNull ItemStack pStack, @NotNull EquipmentSlot pSlot, @NotNull BoneCache pBone, @Nullable ArmorMaterial.Layer pLayer, int pPackedLight, int pPackedOverlay, boolean pForGlint) {
        if (pForGlint) {
            return pBufferSource.getBuffer(RenderType.armorEntityGlint());
        }
        return pBufferSource.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)pLayer.texture(pSlot == EquipmentSlot.LEGS)));
    }

    @NotNull
    protected HumanoidModel<?> getModelForItem(@NotNull BoneCache pBone, @NotNull EquipmentSlot pSlot, @NotNull ItemStack pStack, @NotNull T pAnimatable) {
        HumanoidModel<LivingEntity> defaultModel = pSlot == EquipmentSlot.LEGS ? INNER_ARMOR_MODEL : OUTER_ARMOR_MODEL;
        return BlueLibConstants.PlatformHelper.ITEM_RENDERING.getArmorModelForItem(pAnimatable, pStack, pSlot, defaultModel);
    }

    protected void renderSkullAsArmor(@NotNull PoseStack pPoseStack, @NotNull BoneCache pBone, @NotNull ItemStack pStack, @NotNull AbstractSkullBlock pSkullBlock, @NotNull MultiBufferSource pBufferSource, int pPackedLight) {
        SkullBlock.Type type = pSkullBlock.getType();
        SkullModelBase model = (SkullModelBase)SkullBlockRenderer.createSkullRenderers((EntityModelSet)Minecraft.getInstance().getEntityModels()).get(type);
        RenderType pRenderType = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, (ResolvableProfile)((ResolvableProfile)pStack.get(DataComponents.PROFILE)));
        pPoseStack.pushPose();
        RenderUtils.translateAndRotateMatrixForBone(pPoseStack, pBone);
        pPoseStack.scale(1.1875f, 1.1875f, 1.1875f);
        pPoseStack.translate(-0.5f, 0.0f, -0.5f);
        SkullBlockRenderer.renderSkull(null, (float)0.0f, (float)0.0f, (PoseStack)pPoseStack, (MultiBufferSource)pBufferSource, (int)pPackedLight, (SkullModelBase)model, (RenderType)pRenderType);
        pPoseStack.popPose();
    }

    protected void prepModelPartForRender(@NotNull PoseStack pPoseStack, @NotNull BoneCache pBone, @NotNull ModelPart pSourcePart) {
        CubeCache firstCube = pBone.getCubes().getFirst();
        ModelPart.Cube armorCube = this.getReferenceCubeForModel(pBone, pSourcePart);
        double armorBoneSizeX = firstCube.size().x();
        double armorBoneSizeY = firstCube.size().y();
        double armorBoneSizeZ = firstCube.size().z();
        double actualArmorSizeX = Math.abs(armorCube.maxX - armorCube.minX);
        double actualArmorSizeY = Math.abs(armorCube.maxY - armorCube.minY);
        double actualArmorSizeZ = Math.abs(armorCube.maxZ - armorCube.minZ);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        pSourcePart.setPos(-(pBone.getPivotX() - (pBone.getPivotX() * scaleX - pBone.getPivotX()) / scaleX), -(pBone.getPivotY() - (pBone.getPivotY() * scaleY - pBone.getPivotY()) / scaleY), pBone.getPivotZ() - (pBone.getPivotZ() * scaleZ - pBone.getPivotZ()) / scaleZ);
        pSourcePart.xRot = -pBone.getRotX();
        pSourcePart.yRot = -pBone.getRotY();
        pSourcePart.zRot = pBone.getRotZ();
        pPoseStack.scale(scaleX, scaleY, scaleZ);
    }

    protected ModelPart.Cube getReferenceCubeForModel(@NotNull BoneCache pBone, @NotNull ModelPart pSourcePart) {
        return (ModelPart.Cube)pSourcePart.cubes.getFirst();
    }
}

