/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.markdown.syntax;

import java.util.regex.Pattern;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.IsValidUtils;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.config.MarkdownConfig;
import software.bluelib.internal.BlueTranslation;
import software.bluelib.markdown.MarkdownFeature;

public class Hyperlink
extends MarkdownFeature {
    @Override
    @NotNull
    public MutableComponent apply(@NotNull MutableComponent pComponent) {
        if (!MarkdownConfig.isHyperlinkEnabled) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("markdown.hyperlink.disabled"));
            return pComponent;
        }
        Pattern pattern = Pattern.compile(Pattern.quote(MarkdownConfig.hyperlinkPrefix) + "(.*?)" + Pattern.quote(MarkdownConfig.hyperlinkSuffix) + "\\((.*?)\\)");
        MutableComponent result = Component.empty();
        if (pComponent.getSiblings().isEmpty()) {
            this.processComponentTextWithHyperlinks(pComponent.getString(), pComponent.getStyle(), result, pattern);
        } else {
            result = this.processSiblingsWithHyperlinks(pComponent, pattern);
        }
        return result;
    }

    protected void processComponentTextWithHyperlinks(@NotNull String pText, @NotNull Style pOriginalStyle, @NotNull MutableComponent pResult, @NotNull Pattern pPattern) {
        this.processComponentText(pText, pOriginalStyle, pResult, pPattern, (matcher, res) -> {
            String url = matcher.group(2);
            if (url != null && !url.isEmpty()) {
                this.appendHyperlink(matcher.group(1), url, pOriginalStyle, (MutableComponent)res);
            }
        });
    }

    @NotNull
    public MutableComponent processSiblingsWithHyperlinks(@NotNull MutableComponent pComponent, @NotNull Pattern pPattern) {
        return this.processSiblings(pComponent, pPattern, this::processComponentTextWithHyperlinks);
    }

    private void appendHyperlink(@NotNull String pText, @NotNull String pUrl, @NotNull Style pOriginalStyle, @NotNull MutableComponent pResult) {
        if (!IsValidUtils.isValidURL(pUrl).booleanValue()) {
            pResult.append((Component)Component.literal((String)(MarkdownConfig.hyperlinkPrefix + pText + MarkdownConfig.hyperlinkSuffix + "(" + pUrl + ")")).setStyle(pOriginalStyle));
            return;
        }
        MutableComponent hyperlink = Component.literal((String)pText).setStyle(pOriginalStyle.withColor(TextColor.fromRgb((int)2056161)).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, pUrl)));
        pResult.append((Component)hyperlink);
    }

    @Override
    @NotNull
    protected Boolean isFeatureEnabled() {
        return MarkdownConfig.isHyperlinkEnabled;
    }

    @Override
    @NotNull
    protected String getFeatureName() {
        return "Hyperlink";
    }
}

