/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.mixin.common.variant;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bluelib.entity.variant.IVariantAccessor;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements IVariantAccessor {
    @Unique
    @NotNull
    private static final EntityDataAccessor<String> bluelib$VARIANT = SynchedEntityData.defineId(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    @Inject(method={"defineSynchedData"}, at={@At(value="HEAD")})
    protected void defineSynchedData(@NotNull // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull @NotNull SynchedEntityData.Builder pBuilder, @NotNull CallbackInfo pCi) {
        pBuilder.define(bluelib$VARIANT, (Object)"normal");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound, @NotNull CallbackInfo pCi) {
        pCompound.putString("Variant", this.bluelib$getVariantName());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound, @NotNull CallbackInfo pCi) {
        this.bluelib$setVariantName(pCompound.getString("Variant"));
    }

    @Unique
    public void bluelib$setVariantName(@NotNull String pName) {
        ((Entity)this).getEntityData().set(bluelib$VARIANT, (Object)pName);
    }

    @Unique
    @NotNull
    public String bluelib$getVariantName() {
        return (String)((Entity)this).getEntityData().get(bluelib$VARIANT);
    }

    @Override
    public void setEntityVariantName(@NotNull String pVariantName) {
        this.bluelib$setVariantName(pVariantName);
    }

    @Override
    @NotNull
    public String getEntityVariantName() {
        return this.bluelib$getVariantName();
    }
}

