/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.net;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.ClientNetworkPacketHandler;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.api.net.ServerNetworkPacketHandler;
import software.bluelib.net.PacketRegisterInfo;

public record NeoForgePacketInfo<T extends NetworkPacket<T>>(@NotNull PacketRegisterInfo<T> info) {
    @NotNull
    private static final Set<ResourceLocation> REGISTERED_CLIENT_PAYLOADS = new HashSet<ResourceLocation>();
    @NotNull
    private static final Set<ResourceLocation> REGISTERED_SERVER_PAYLOADS = new HashSet<ResourceLocation>();

    public void registerToClient(@NotNull PayloadRegistrar pRegistrar) {
        if (!REGISTERED_CLIENT_PAYLOADS.add(this.info.getId())) {
            return;
        }
        IPayloadHandler handler = (arg, unused) -> {
            ClientNetworkPacketHandler clientHandler = (ClientNetworkPacketHandler)this.info.getHandler();
            clientHandler.handle(arg, Minecraft.getInstance());
        };
        pRegistrar.playToClient(this.info.getPayloadId(), this.info.getCodec(), handler);
    }

    public void registerToServer(@NotNull PayloadRegistrar pRegistrar) {
        if (!REGISTERED_SERVER_PAYLOADS.add(this.info.getId())) {
            return;
        }
        IPayloadHandler handler = (arg, ctx) -> {
            ServerNetworkPacketHandler serverHandler = (ServerNetworkPacketHandler)this.info.getHandler();
            serverHandler.handle(arg, ctx.player().getServer(), (ServerPlayer)ctx.player());
        };
        pRegistrar.playToServer(this.info.getPayloadId(), this.info.getCodec(), handler);
    }
}

