/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.net;

import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.net.Encodable;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.api.net.PacketHandler;

public class PacketRegisterInfo<T extends NetworkPacket<T> & Encodable> {
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final Function<RegistryFriendlyByteBuf, T> decoder;
    @NotNull
    private final PacketHandler<T> handler;
    @NotNull
    private final CustomPacketPayload.Type<T> payloadId;
    @NotNull
    private final StreamCodec<RegistryFriendlyByteBuf, T> codec;

    public PacketRegisterInfo(@NotNull ResourceLocation pId, @NotNull Function<RegistryFriendlyByteBuf, T> pDecoder, @NotNull PacketHandler<T> pHandler, @Nullable StreamCodec<RegistryFriendlyByteBuf, T> pCodec) {
        this.id = pId;
        this.decoder = pDecoder;
        this.handler = pHandler;
        this.payloadId = new CustomPacketPayload.Type(pId);
        this.codec = pCodec != null ? pCodec : this.createDefaultCodec(pDecoder);
    }

    public PacketRegisterInfo(@NotNull ResourceLocation pId, @NotNull Function<RegistryFriendlyByteBuf, T> pDecoder, @NotNull PacketHandler<T> pHandler) {
        this.id = pId;
        this.decoder = pDecoder;
        this.handler = pHandler;
        this.payloadId = new CustomPacketPayload.Type(pId);
        this.codec = this.createDefaultCodec(pDecoder);
    }

    @NotNull
    private StreamCodec<RegistryFriendlyByteBuf, T> createDefaultCodec(@NotNull Function<RegistryFriendlyByteBuf, T> pDecoder) {
        return StreamCodec.of((buf, packet) -> packet.encode(buf), pDecoder::apply);
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public Function<RegistryFriendlyByteBuf, T> getDecoder() {
        return this.decoder;
    }

    @NotNull
    public PacketHandler<T> getHandler() {
        return this.handler;
    }

    @NotNull
    public CustomPacketPayload.Type<T> getPayloadId() {
        return this.payloadId;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, T> getCodec() {
        return this.codec;
    }
}

