/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.platform;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.Environment;
import software.bluelib.api.ModAPI;
import software.bluelib.api.event.mod.ModMeta;
import software.bluelib.platform.IPlatformHelper;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    @NotNull
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(@NotNull String pModId) {
        return ModList.get().isLoaded(pModId);
    }

    @Override
    @NotNull
    public Set<String> getLoadedMods() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public List<ModMeta> getLoadedModMetadata() {
        ArrayList<ModMeta> mods = new ArrayList<ModMeta>();
        for (IModInfo modInfo : ModList.get().getMods()) {
            String modId = modInfo.getModId();
            String displayName = modInfo.getDisplayName();
            String version = modInfo.getVersion().toString();
            String description = modInfo.getDescription();
            Optional logoFile = modInfo.getLogoFile();
            mods.add(new ModMeta(modId, displayName, version, description, logoFile));
        }
        return mods;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    @NotNull
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public boolean isPhysicalClient() {
        return FMLEnvironment.dist.isClient();
    }

    @Override
    @NotNull
    public Environment getEnvironment() {
        return FMLEnvironment.dist.isClient() ? Environment.CLIENT : Environment.SERVER;
    }

    @Override
    @NotNull
    public ModAPI getAPI() {
        return ModAPI.NEOFORGE;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }
}

