/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.platform;

import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.NetworkManager;
import software.bluelib.internal.registry.BlueEntityRegistry;
import software.bluelib.net.NeoForgeNetworkManager;
import software.bluelib.platform.IRegistryHelper;

public class NeoForgeRegistryHelper
implements IRegistryHelper {
    @NotNull
    public static final DeferredRegister.DataComponents DATA_COMPONENT_TYPE = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"bluelib");
    @NotNull
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"bluelib");
    @NotNull
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"bluelib");
    @NotNull
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"bluelib");

    @Override
    @NotNull
    public NetworkManager getNetwork() {
        return new NeoForgeNetworkManager();
    }

    @Override
    @NotNull
    public <T extends RecipeType<?>> Supplier<T> registerRecipeType(@NotNull String pId, @NotNull Supplier<T> pRecipeType) {
        return RECIPE_TYPES.register(pId, pRecipeType);
    }

    @Override
    @NotNull
    public <T extends Entity> Supplier<EntityType<T>> registerEntity(@NotNull String pId, @NotNull Supplier<EntityType<T>> pEntity) {
        return ENTITIES.register(pId, pEntity);
    }

    @Override
    @NotNull
    public <T extends DataComponentType<?>> Supplier<T> registerDataComponent(@NotNull String pId, @NotNull Supplier<T> pDataComponentType) {
        return DATA_COMPONENT_TYPE.register(pId, pDataComponentType);
    }

    @Override
    @NotNull
    public <T extends RecipeSerializer<?>> Supplier<T> registerRecipeSerializer(@NotNull String pId, @NotNull Supplier<T> pRecipeSerializer) {
        return RECIPE_SERIALIZERS.register(pId, pRecipeSerializer);
    }

    public static void register(@NotNull IEventBus pModEventBus) {
        RECIPE_TYPES.register(pModEventBus);
        RECIPE_SERIALIZERS.register(pModEventBus);
        DATA_COMPONENT_TYPE.register(pModEventBus);
        ENTITIES.register(pModEventBus);
        pModEventBus.addListener(event -> BlueEntityRegistry.registerEntityAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1)));
    }
}

