/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.logging;

import java.util.function.Supplier;
import java.util.logging.Level;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.DefaultLogColorProvider;
import software.bluelib.api.utils.logging.LoggerConfig;

public class BaseLogger {
    private BaseLogger() {
    }

    public static void log(@NotNull Boolean pIsBlueLib, @NotNull Level pLogLevel, @NotNull Supplier<String> pMessageSupplier, Throwable ... pThrowable) {
        if (BaseLogger.shouldLogBlueLib(pLogLevel, pIsBlueLib).booleanValue()) {
            BaseLogger.logBoth(pLogLevel, (class_2561)class_2561.method_43470((String)pMessageSupplier.get()), pThrowable);
        }
    }

    public static void log(@NotNull Boolean pIsBlueLib, @NotNull Level pLogLevel, @NotNull Supplier<String> pMessageSupplier) {
        if (BaseLogger.shouldLogBlueLib(pLogLevel, pIsBlueLib).booleanValue()) {
            BaseLogger.logBoth(pLogLevel, (class_2561)class_2561.method_43470((String)pMessageSupplier.get()));
        }
    }

    public static void log(@NotNull Level pLogLevel, @NotNull Supplier<String> pMessageSupplier, Throwable ... pThrowable) {
        if (BaseLogger.shouldLog(pLogLevel).booleanValue()) {
            BaseLogger.logBoth(pLogLevel, (class_2561)class_2561.method_43470((String)pMessageSupplier.get()), pThrowable);
        }
    }

    public static void log(@NotNull Level pLogLevel, @NotNull Supplier<String> pMessageSupplier) {
        if (BaseLogger.shouldLog(pLogLevel).booleanValue()) {
            BaseLogger.logBoth(pLogLevel, (class_2561)class_2561.method_43470((String)pMessageSupplier.get()));
        }
    }

    public static void log(@NotNull Boolean pIsBlueLib, @NotNull Level pLogLevel, @NotNull class_2561 pMessage, Throwable ... pThrowable) {
        if (BaseLogger.shouldLogBlueLib(pLogLevel, pIsBlueLib).booleanValue()) {
            BaseLogger.logBoth(pLogLevel, pMessage, pThrowable);
        }
    }

    public static void log(@NotNull Boolean pIsBlueLib, @NotNull Level pLogLevel, @NotNull class_2561 pMessage) {
        if (BaseLogger.shouldLogBlueLib(pLogLevel, pIsBlueLib).booleanValue()) {
            BaseLogger.logBoth(pLogLevel, pMessage);
        }
    }

    public static void log(@NotNull Level pLogLevel, @NotNull class_2561 pMessage, Throwable ... pThrowable) {
        if (BaseLogger.shouldLog(pLogLevel).booleanValue()) {
            BaseLogger.logBoth(pLogLevel, pMessage, pThrowable);
        }
    }

    public static void log(@NotNull Level pLogLevel, @NotNull class_2561 pMessage) {
        if (BaseLogger.shouldLog(pLogLevel).booleanValue()) {
            BaseLogger.logBoth(pLogLevel, pMessage);
        }
    }

    public static void log(@NotNull Boolean pIsBlueLib, @NotNull Level pLogLevel, @NotNull String pMessage, Throwable ... pThrowable) {
        BaseLogger.log(pIsBlueLib, pLogLevel, (class_2561)class_2561.method_43470((String)pMessage), pThrowable);
    }

    public static void log(@NotNull Boolean pIsBlueLib, @NotNull Level pLogLevel, @NotNull String pMessage) {
        BaseLogger.log(pIsBlueLib, pLogLevel, (class_2561)class_2561.method_43470((String)pMessage));
    }

    public static void log(@NotNull Level pLogLevel, @NotNull String pMessage, Throwable ... pThrowable) {
        BaseLogger.log(pLogLevel, (class_2561)class_2561.method_43470((String)pMessage), pThrowable);
    }

    public static void log(@NotNull Level pLogLevel, @NotNull String pMessage) {
        BaseLogger.log(pLogLevel, (class_2561)class_2561.method_43470((String)pMessage));
    }

    public static void logBlueLib(@NotNull class_2561 pMessage) {
        String translatedMessage = pMessage.getString();
        BlueLibConstants.LOGGER.log(BaseLogLevel.BLUELIB, translatedMessage);
    }

    @NotNull
    private static Boolean shouldLogBlueLib(@NotNull Level pLogLevel, @NotNull Boolean pIsBlueLib) {
        return pLogLevel == BaseLogLevel.ERROR || pLogLevel == BaseLogLevel.WARNING || pLogLevel == BaseLogLevel.BLUELIB || pIsBlueLib != false && software.bluelib.config.LoggerConfig.isBlueLibLoggingEnabled;
    }

    @NotNull
    private static Boolean shouldLog(@NotNull Level pLogLevel) {
        return pLogLevel == BaseLogLevel.ERROR || pLogLevel == BaseLogLevel.WARNING || pLogLevel == BaseLogLevel.BLUELIB || software.bluelib.config.LoggerConfig.isLoggingEnabled;
    }

    private static void logBoth(@NotNull Level pLogLevel, @NotNull class_2561 pMessage) {
        String translatedMessage = pMessage.getString();
        BlueLibConstants.LOGGER.log(pLogLevel, translatedMessage);
    }

    private static void logBoth(Level pLogLevel, class_2561 pMessage, Throwable ... pThrowable) {
        String translatedMessage = pMessage.getString();
        BlueLibConstants.LOGGER.log(pLogLevel, translatedMessage, pThrowable);
    }

    static {
        LoggerConfig.configureLogger(BlueLibConstants.LOGGER, new DefaultLogColorProvider());
    }
}

