/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.internal.registry.molang;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.molang.MoLangRuntimeBuilder;
import software.bluelib.api.molang.context.AnimatableMoLang;
import software.bluelib.api.molang.context.BaseMoLangContext;
import software.bluelib.api.molang.context.GeneralMoLang;
import software.bluelib.api.molang.context.MultiMoLangContext;
import software.bluelib.api.molang.context.OperatorMoLang;
import software.bluelib.api.molang.context.entity.EntityMoLang;
import software.bluelib.api.molang.context.math.AdvancedMathMoLang;
import software.bluelib.api.molang.context.math.BasicMathMoLang;
import software.bluelib.api.molang.context.math.RandomMoLang;
import software.bluelib.api.molang.context.math.TrigMoLang;
import software.bluelib.internal.registry.molang.BlueMoLangEntityRegistry;
import software.bluelib.loader.animation.AnimationState;

@ApiStatus.Internal
public class BlueMoLangContextRegistry {
    @NotNull
    protected static final List<Function<MoLangRuntimeBuilder.Input, BaseMoLangContext>> CONTEXT_SUPPLIERS = new ArrayList<Function<MoLangRuntimeBuilder.Input, BaseMoLangContext>>();
    @NotNull
    protected static final List<Function<class_1297, ? extends BaseMoLangContext>> ENTITY_CONTEXT_FACTORIES = new ArrayList<Function<class_1297, ? extends BaseMoLangContext>>();

    public static void init() {
        BlueMoLangContextRegistry.register(input -> new GeneralMoLang());
        BlueMoLangContextRegistry.register(input -> new BasicMathMoLang());
        BlueMoLangContextRegistry.register(input -> new AdvancedMathMoLang());
        BlueMoLangContextRegistry.register(input -> new RandomMoLang());
        BlueMoLangContextRegistry.register(input -> new TrigMoLang());
        BlueMoLangContextRegistry.register(input -> new OperatorMoLang());
        BlueMoLangContextRegistry.register(input -> {
            Object value;
            Supplier supplier = input.get("bluelib_state", Supplier.class);
            if (supplier != null && (value = supplier.get()) instanceof AnimationState) {
                AnimationState animationState = (AnimationState)value;
                return new AnimatableMoLang(animationState);
            }
            return null;
        });
        BlueMoLangEntityRegistry.init();
        BlueMoLangContextRegistry.register(input -> {
            Object obj;
            Supplier supplier = input.get("bluelib_entity", Supplier.class);
            if (supplier != null && (obj = supplier.get()) instanceof class_1297) {
                class_1297 entity = (class_1297)obj;
                ArrayList<BaseMoLangContext> contexts = new ArrayList<BaseMoLangContext>();
                for (Function<class_1297, ? extends BaseMoLangContext> factory : ENTITY_CONTEXT_FACTORIES) {
                    BaseMoLangContext ctx = factory.apply(entity);
                    if (ctx == null) continue;
                    contexts.add(ctx);
                }
                if (contexts.isEmpty()) {
                    contexts.add(new EntityMoLang(() -> entity));
                }
                return new MultiMoLangContext(contexts);
            }
            return null;
        });
    }

    public static void registerEntityContext(@NotNull Function<class_1297, ? extends BaseMoLangContext> pFactory) {
        ENTITY_CONTEXT_FACTORIES.add(pFactory);
    }

    public static void register(@NotNull Function<MoLangRuntimeBuilder.Input, @Nullable BaseMoLangContext> pFactory) {
        CONTEXT_SUPPLIERS.add(pFactory);
    }

    @NotNull
    public static List<BaseMoLangContext> createContexts(@NotNull MoLangRuntimeBuilder.Input pInput) {
        ArrayList<BaseMoLangContext> result = new ArrayList<BaseMoLangContext>();
        for (Function<MoLangRuntimeBuilder.Input, BaseMoLangContext> fn : CONTEXT_SUPPLIERS) {
            BaseMoLangContext ctx = fn.apply(pInput);
            if (ctx == null) continue;
            if (ctx instanceof List) {
                List ctxList = (List)((Object)ctx);
                for (Object o : ctxList) {
                    if (!(o instanceof BaseMoLangContext)) continue;
                    BaseMoLangContext c = (BaseMoLangContext)o;
                    result.add(c);
                }
                continue;
            }
            result.add(ctx);
        }
        return result;
    }
}

