/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.entity;

import net.minecraft.class_1297;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.net.registry.LoaderNetwork;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;

public interface BlueEntity
extends BlueAnimatable {
    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(@NotNull SerializableDataTicket<D> pDataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(((class_1297)this).method_5628()).getData(pDataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(@NotNull SerializableDataTicket<D> pDataTicket, @NotNull D pData) {
        class_1297 entity = (class_1297)this;
        if (entity.method_37908().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.method_5628()).setData(pDataTicket, pData);
        } else {
            LoaderNetwork.syncEntityAnimData(entity, false, pDataTicket, pData);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(@Nullable String pControllerName, @NotNull String pAnimName) {
        class_1297 entity = (class_1297)this;
        if (entity.method_37908().method_8608()) {
            if (pControllerName != null) {
                this.getAnimatableInstanceCache().getManagerForId(entity.method_5628()).tryTriggerAnimation(pControllerName, pAnimName);
            } else {
                this.getAnimatableInstanceCache().getManagerForId(entity.method_5628()).tryTriggerAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.triggerEntityAnim(entity, false, pControllerName, pAnimName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(@Nullable String pControllerName, @Nullable String pAnimName) {
        class_1297 entity = (class_1297)this;
        if (entity.method_37908().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(entity.method_5628());
            if (pControllerName != null) {
                animatableManager.stopTriggeredAnimation(pControllerName, pAnimName);
            } else {
                animatableManager.stopTriggeredAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.stopTriggeredEntityAnim(entity, false, pControllerName, pAnimName);
        }
    }

    @Override
    @NotNull
    default public Double getTick(@NotNull Object pEntity) {
        return ((class_1297)pEntity).field_6012;
    }
}

