/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.entity;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.net.registry.LoaderNetwork;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.SingletonBlueAnimatable;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;
import software.bluelib.loader.renderer.client.BlueRenderProvider;

public interface BlueReplacedEntity
extends SingletonBlueAnimatable {
    @NotNull
    public class_1299<?> getReplacingEntityType();

    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(@NotNull class_1297 pEntity, @NotNull SerializableDataTicket<D> pDataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(pEntity.method_5628()).getData(pDataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(@NotNull class_1297 pRelatedEntity, @NotNull SerializableDataTicket<D> pDataTicket, @NotNull D pData) {
        if (pRelatedEntity.method_37908().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(pRelatedEntity.method_5628()).setData(pDataTicket, pData);
        } else {
            LoaderNetwork.syncEntityAnimData(pRelatedEntity, true, pDataTicket, pData);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(@NotNull class_1297 pRelatedEntity, @Nullable String pControllerName, @NotNull String pAnimName) {
        if (pRelatedEntity.method_37908().method_8608()) {
            if (pControllerName != null) {
                this.getAnimatableInstanceCache().getManagerForId(pRelatedEntity.method_5628()).tryTriggerAnimation(pControllerName, pAnimName);
            } else {
                this.getAnimatableInstanceCache().getManagerForId(pRelatedEntity.method_5628()).tryTriggerAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.triggerEntityAnim(pRelatedEntity, true, pControllerName, pAnimName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(@NotNull class_1297 pRelatedEntity, @Nullable String pControllerName, @Nullable String pAnimName) {
        if (pRelatedEntity.method_37908().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(pRelatedEntity.method_5628());
            if (pControllerName != null) {
                animatableManager.stopTriggeredAnimation(pControllerName, pAnimName);
            } else {
                animatableManager.stopTriggeredAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.stopTriggeredEntityAnim(pRelatedEntity, true, pControllerName, pAnimName);
        }
    }

    @Override
    @NotNull
    default public Double getTick(@NotNull Object pEntity) {
        return ((class_1297)pEntity).field_6012;
    }

    @Override
    @ApiStatus.NonExtendable
    default public void createBlueRenderer(@NotNull Consumer<BlueRenderProvider> pConsumer) {
    }

    @Override
    @ApiStatus.NonExtendable
    @Nullable
    default public Object getRenderProvider() {
        return null;
    }
}

