/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animation.math;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.animation.keyframe.AnimationPoint;
import software.bluelib.loader.geckolib.math.MathValue;

@FunctionalInterface
public interface Easing {
    @NotNull
    public static final Map<String, Easing> EASING_TYPES = new ConcurrentHashMap<String, Easing>(64);
    @NotNull
    public static final Easing LINEAR = Easing.register("linear", Easing.register("none", value -> Easing.easeIn(Easing::linear)));
    @NotNull
    public static final Easing STEP = Easing.register("step", value -> Easing.easeIn(Easing.step(value)));
    @NotNull
    public static final Easing EASE_IN_SINE = Easing.register("easeinsine", value -> Easing.easeIn(Easing::sine));
    @NotNull
    public static final Easing EASE_OUT_SINE = Easing.register("easeoutsine", value -> Easing.easeOut(Easing::sine));
    @NotNull
    public static final Easing EASE_IN_OUT_SINE = Easing.register("easeinoutsine", value -> Easing.easeInOut(Easing::sine));
    @NotNull
    public static final Easing EASE_IN_QUAD = Easing.register("easeinquad", value -> Easing.easeIn(Easing::quadratic));
    @NotNull
    public static final Easing EASE_OUT_QUAD = Easing.register("easeoutquad", value -> Easing.easeOut(Easing::quadratic));
    @NotNull
    public static final Easing EASE_IN_OUT_QUAD = Easing.register("easeinoutquad", value -> Easing.easeInOut(Easing::quadratic));
    @NotNull
    public static final Easing EASE_IN_CUBIC = Easing.register("easeincubic", value -> Easing.easeIn(Easing::cubic));
    @NotNull
    public static final Easing EASE_OUT_CUBIC = Easing.register("easeoutcubic", value -> Easing.easeOut(Easing::cubic));
    @NotNull
    public static final Easing EASE_IN_OUT_CUBIC = Easing.register("easeinoutcubic", value -> Easing.easeInOut(Easing::cubic));
    @NotNull
    public static final Easing EASE_IN_QUART = Easing.register("easeinquart", value -> Easing.easeIn(Easing.pow(4.0)));
    @NotNull
    public static final Easing EASE_OUT_QUART = Easing.register("easeoutquart", value -> Easing.easeOut(Easing.pow(4.0)));
    @NotNull
    public static final Easing EASE_IN_OUT_QUART = Easing.register("easeinoutquart", value -> Easing.easeInOut(Easing.pow(4.0)));
    @NotNull
    public static final Easing EASE_IN_QUINT = Easing.register("easeinquint", value -> Easing.easeIn(Easing.pow(4.0)));
    @NotNull
    public static final Easing EASE_OUT_QUINT = Easing.register("easeoutquint", value -> Easing.easeOut(Easing.pow(5.0)));
    @NotNull
    public static final Easing EASE_IN_OUT_QUINT = Easing.register("easeinoutquint", value -> Easing.easeInOut(Easing.pow(5.0)));
    @NotNull
    public static final Easing EASE_IN_EXPO = Easing.register("easeinexpo", value -> Easing.easeIn(Easing::exp));
    @NotNull
    public static final Easing EASE_OUT_EXPO = Easing.register("easeoutexpo", value -> Easing.easeOut(Easing::exp));
    @NotNull
    public static final Easing EASE_IN_OUT_EXPO = Easing.register("easeinoutexpo", value -> Easing.easeInOut(Easing::exp));
    @NotNull
    public static final Easing EASE_IN_CIRC = Easing.register("easeincirc", value -> Easing.easeIn(Easing::circle));
    @NotNull
    public static final Easing EASE_OUT_CIRC = Easing.register("easeoutcirc", value -> Easing.easeOut(Easing::circle));
    @NotNull
    public static final Easing EASE_IN_OUT_CIRC = Easing.register("easeinoutcirc", value -> Easing.easeInOut(Easing::circle));
    @NotNull
    public static final Easing EASE_IN_BACK = Easing.register("easeinback", value -> Easing.easeIn(Easing.back(value)));
    @NotNull
    public static final Easing EASE_OUT_BACK = Easing.register("easeoutback", value -> Easing.easeOut(Easing.back(value)));
    @NotNull
    public static final Easing EASE_IN_OUT_BACK = Easing.register("easeinoutback", value -> Easing.easeInOut(Easing.back(value)));
    @NotNull
    public static final Easing EASE_IN_ELASTIC = Easing.register("easeinelastic", value -> Easing.easeIn(Easing.elastic(value)));
    @NotNull
    public static final Easing EASE_OUT_ELASTIC = Easing.register("easeoutelastic", value -> Easing.easeOut(Easing.elastic(value)));
    @NotNull
    public static final Easing EASE_IN_OUT_ELASTIC = Easing.register("easeinoutelastic", value -> Easing.easeInOut(Easing.elastic(value)));
    @NotNull
    public static final Easing EASE_IN_BOUNCE = Easing.register("easeinbounce", value -> Easing.easeIn(Easing.bounce(value)));
    @NotNull
    public static final Easing EASE_OUT_BOUNCE = Easing.register("easeoutbounce", value -> Easing.easeOut(Easing.bounce(value)));
    @NotNull
    public static final Easing EASE_IN_OUT_BOUNCE = Easing.register("easeinoutbounce", value -> Easing.easeInOut(Easing.bounce(value)));
    @NotNull
    public static final Easing CATMULLROM = Easing.register("catmullrom", new CatmullRomEasing());

    @NotNull
    public Double2DoubleFunction buildTransformer(@Nullable Double var1);

    public static double lerpWithOverride(@NotNull AnimationPoint pAnimationPoint, @Nullable Easing pOverride) {
        Easing easing = pOverride;
        if (pOverride == null) {
            easing = pAnimationPoint.keyFrame() == null ? LINEAR : pAnimationPoint.keyFrame().easing();
        }
        return easing.apply(pAnimationPoint);
    }

    default public double apply(@NotNull AnimationPoint pAnimationPoint) {
        Double easingVariable = null;
        if (pAnimationPoint.keyFrame() != null && !pAnimationPoint.keyFrame().easingArgs().isEmpty()) {
            easingVariable = ((MathValue)pAnimationPoint.keyFrame().easingArgs().getFirst()).get();
        }
        return this.apply(pAnimationPoint, easingVariable, pAnimationPoint.currentTick() / pAnimationPoint.transitionLength());
    }

    default public double apply(@NotNull AnimationPoint pAnimationPoint, @Nullable Double pEasingValue, Double pLerpValue) {
        if (pAnimationPoint.currentTick() >= pAnimationPoint.transitionLength()) {
            return (float)pAnimationPoint.animationEndValue();
        }
        return class_3532.method_16436((double)((Double)this.buildTransformer(pEasingValue).apply((Object)pLerpValue)), (double)pAnimationPoint.animationStartValue(), (double)pAnimationPoint.animationEndValue());
    }

    @NotNull
    public static Easing register(@NotNull String pName, @NotNull Easing pEasing) {
        EASING_TYPES.putIfAbsent(pName, pEasing);
        return pEasing;
    }

    @NotNull
    public static Easing fromJson(@NotNull JsonElement pJson) {
        JsonPrimitive primitive;
        if (!(pJson instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)pJson).isString()) {
            return LINEAR;
        }
        return Easing.fromString(primitive.getAsString().toLowerCase(Locale.ROOT));
    }

    @NotNull
    public static Easing fromString(@NotNull String pName) {
        return EASING_TYPES.getOrDefault(pName, LINEAR);
    }

    @NotNull
    public static Double2DoubleFunction linear(@NotNull Double2DoubleFunction pFunction) {
        return pFunction;
    }

    public static double catmullRom(double pNumber) {
        return 0.5 * (2.0 * (pNumber + 1.0) + 2.0 + (2.0 * pNumber - 5.0 * (pNumber + 1.0) + 4.0 * (pNumber + 2.0) - (pNumber + 3.0)) + (3.0 * (pNumber + 1.0) - pNumber - 3.0 * (pNumber + 2.0) + (pNumber + 3.0)));
    }

    @NotNull
    public static Double2DoubleFunction easeIn(@NotNull Double2DoubleFunction pFunction) {
        return pFunction;
    }

    @NotNull
    public static Double2DoubleFunction easeOut(@NotNull Double2DoubleFunction pFunction) {
        return time -> 1.0 - (Double)pFunction.apply((Object)(1.0 - time));
    }

    @NotNull
    public static Double2DoubleFunction easeInOut(@NotNull Double2DoubleFunction pFunction) {
        return time -> {
            if (time < 0.5) {
                return (Double)pFunction.apply((Object)(time * 2.0)) / 2.0;
            }
            return 1.0 - (Double)pFunction.apply((Object)((1.0 - time) * 2.0)) / 2.0;
        };
    }

    @NotNull
    public static Double2DoubleFunction stepPositive(@NotNull Double2DoubleFunction pFunction) {
        return n -> n > 0.0 ? 1.0 : 0.0;
    }

    @NotNull
    public static Double2DoubleFunction stepNonNegative(@NotNull Double2DoubleFunction pFunction) {
        return n -> n >= 0.0 ? 1.0 : 0.0;
    }

    public static double linear(double pNumber) {
        return pNumber;
    }

    public static double quadratic(double pNumber) {
        return pNumber * pNumber;
    }

    public static double cubic(double pNumber) {
        return pNumber * pNumber * pNumber;
    }

    public static double sine(double pNumber) {
        return 1.0 - Math.cos(pNumber * Math.PI / 2.0);
    }

    public static double circle(double pNumber) {
        return 1.0 - Math.sqrt(1.0 - pNumber * pNumber);
    }

    public static double exp(double pNumber) {
        return Math.pow(2.0, 10.0 * (pNumber - 1.0));
    }

    @NotNull
    public static Double2DoubleFunction elastic(@Nullable Double pNumber) {
        double n2 = pNumber == null ? 1.0 : pNumber;
        return t -> 1.0 - Math.pow(Math.cos(t * Math.PI / 2.0), 3.0) * Math.cos(t * n2 * Math.PI);
    }

    @NotNull
    public static Double2DoubleFunction bounce(@Nullable Double pNumber) {
        double n2 = pNumber == null ? 0.5 : pNumber;
        Double2DoubleFunction one = x -> 7.5625 * x * x;
        Double2DoubleFunction two = x -> 30.25 * n2 * Math.pow(x - 0.5454545617103577, 2.0) + 1.0 - n2;
        Double2DoubleFunction three = x -> 121.0 * n2 * n2 * Math.pow(x - 0.8181818127632141, 2.0) + 1.0 - n2 * n2;
        Double2DoubleFunction four = x -> 484.0 * n2 * n2 * n2 * Math.pow(x - 0.9545454382896423, 2.0) + 1.0 - n2 * n2 * n2;
        return t -> Math.min(Math.min((Double)one.apply((Object)t), (Double)two.apply((Object)t)), Math.min((Double)three.apply((Object)t), (Double)four.apply((Object)t)));
    }

    @NotNull
    public static Double2DoubleFunction back(@Nullable Double pNumber) {
        double n2 = pNumber == null ? 1.70158 : pNumber * 1.70158;
        return t -> t * t * ((n2 + 1.0) * t - n2);
    }

    @NotNull
    public static Double2DoubleFunction pow(@NotNull Double pNumber) {
        return t -> Math.pow(t, pNumber);
    }

    @NotNull
    public static Double2DoubleFunction step(@Nullable Double pNumber) {
        double n2;
        double d = n2 = pNumber == null ? 2.0 : pNumber;
        if (n2 < 2.0) {
            throw new IllegalArgumentException("Steps must be >= 2, got: " + n2);
        }
        int steps = (int)n2;
        return t -> {
            double d;
            double result = 0.0;
            if (t < 0.0) {
                return result;
            }
            double stepLength = 1.0 / (double)steps;
            result = (double)(steps - 1) * stepLength;
            if (t > d) {
                return result;
            }
            int leftBorderIndex = 0;
            int rightBorderIndex = steps - 1;
            while (rightBorderIndex - leftBorderIndex != 1) {
                int testIndex = leftBorderIndex + (rightBorderIndex - leftBorderIndex) / 2;
                if (t >= (double)testIndex * stepLength) {
                    leftBorderIndex = testIndex;
                    continue;
                }
                rightBorderIndex = testIndex;
            }
            return (double)leftBorderIndex * stepLength;
        };
    }

    public static class CatmullRomEasing
    implements Easing {
        public static double getPointOnSpline(double pDelta, double pP0, double pP1, double pP2, double pP3) {
            return 0.5 * (2.0 * pP1 + (pP2 - pP0) * pDelta + (2.0 * pP0 - 5.0 * pP1 + 4.0 * pP2 - pP3) * pDelta * pDelta + (3.0 * pP1 - pP0 - 3.0 * pP2 + pP3) * pDelta * pDelta * pDelta);
        }

        @Override
        @NotNull
        public Double2DoubleFunction buildTransformer(@Nullable Double pValue) {
            return Easing.easeInOut(Easing::catmullRom);
        }

        @Override
        public double apply(@NotNull AnimationPoint pAnimationPoint, @Nullable Double pEasingValue, @NotNull Double pLerpValue) {
            if (pAnimationPoint.currentTick() >= pAnimationPoint.transitionLength()) {
                return pAnimationPoint.animationEndValue();
            }
            List<?> easingArgs = pAnimationPoint.keyFrame().easingArgs();
            if (easingArgs.size() < 2) {
                return class_3532.method_16436((double)((Double)this.buildTransformer(pEasingValue).apply((Object)pLerpValue)), (double)pAnimationPoint.animationStartValue(), (double)pAnimationPoint.animationEndValue());
            }
            return CatmullRomEasing.getPointOnSpline(pLerpValue, ((MathValue)easingArgs.get(0)).get(), pAnimationPoint.animationStartValue(), pAnimationPoint.animationEndValue(), ((MathValue)easingArgs.get(1)).get());
        }
    }
}

