/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.controller;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.api.utils.minecraft.CompoundTagUtils;
import software.bluelib.loader.cache.controller.StateCache;

public record BehaviourCache(@NotNull List<String> conditions, @Nullable Integer priority, @NotNull Map<String, StateCache> states) {
    @NotNull
    public static final Codec<BehaviourCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        class_2487 tag = (class_2487)dynamic.convert((DynamicOps)class_2509.field_11560).getValue();
        return DataResult.success((Object)BehaviourCache.readFromNBT(tag));
    }, behaviorCache -> {
        class_2487 tag = new class_2487();
        behaviorCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag);
    });
    @NotNull
    public static final class_9331<BehaviourCache> BEHAVIOUR_CACHE_DATA = class_9331.method_57873().method_57881(CODEC).method_57880();

    public void writeToNBT(@NotNull class_2487 pTag) {
        CompoundTagUtils.writeList(pTag, "conditions", this.conditions, (tag, data) -> tag.method_10582("condition", data));
        if (this.priority != null) {
            pTag.method_10569("priority", this.priority.intValue());
        }
        CompoundTagUtils.writeMap(pTag, "states", this.states, (tag, key) -> tag.method_10582("name", key), (tag, value) -> value.writeToNBT((class_2487)tag), "name", "state");
    }

    @NotNull
    public static BehaviourCache readFromNBT(@NotNull class_2487 pTag) {
        List<String> conditions = CompoundTagUtils.readList(pTag, "conditions", tag -> tag.method_10558("condition"));
        Integer priority = pTag.method_10545("priority") ? Integer.valueOf(pTag.method_10550("priority")) : null;
        Map<String, StateCache> states = CompoundTagUtils.readMap(pTag, "states", tag -> tag.method_10558("name"), StateCache::readFromNBT, "name", "state");
        return new BehaviourCache(conditions, priority, states);
    }

    @Nullable
    public StateCache getState(@NotNull String pName) {
        StateCache state = this.states.get(pName);
        if (state == null) {
            BaseLogger.log(BaseLogLevel.WARNING, "State not found: " + pName);
        }
        return state;
    }

    @NotNull
    public StateCache getMainState() {
        return this.states.values().iterator().next();
    }
}

