/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1084;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import net.minecraft.class_4668;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.client.utils.TextureUtils;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.cache.texture.BlueAbstractTexture;
import software.bluelib.loader.cache.texture.GlowingTextureMeta;

public class AutoGlowingTexture
extends BlueAbstractTexture {
    @NotNull
    private static final class_4668.class_5942 SHADER_STATE = new class_4668.class_5942(class_757::method_42595);
    @NotNull
    private static final class_4668.class_4685 TRANSPARENCY_STATE = new class_4668.class_4685("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    @NotNull
    private static final class_4668.class_4686 WRITE_MASK = new class_4668.class_4686(true, true);
    @NotNull
    private static final BiFunction<class_2960, Boolean, class_1921> GLOWING_RENDER_TYPE = class_156.method_34865((texture, isGlowing) -> {
        class_4668.class_4683 textureState = new class_4668.class_4683(texture, false, false);
        return class_1921.method_24049((String)"glowing_layer", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(SHADER_STATE).method_34577((class_4668.class_5939)textureState).method_23615(TRANSPARENCY_STATE).method_23611(new class_4668.class_4679(true)).method_23616(WRITE_MASK).method_23617(isGlowing.booleanValue()));
    });
    @NotNull
    private static final String APPENDIX = "_glowmask";
    public static boolean PRINT_DEBUG_IMAGES = false;
    @NotNull
    protected final class_2960 textureBase;
    @NotNull
    protected final class_2960 glowLayer;

    public AutoGlowingTexture(@NotNull class_2960 pOriginalLocation, @NotNull class_2960 pLocation) {
        this.textureBase = pOriginalLocation;
        this.glowLayer = pLocation;
    }

    @NotNull
    public static class_2960 getEmissiveResource(@NotNull class_2960 pBaseResource) {
        class_2960 path = AutoGlowingTexture.appendToPath(pBaseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.method_4616(path, (class_1044)new AutoGlowingTexture(pBaseResource, path)));
        return path;
    }

    @Override
    @Nullable
    protected class_4573 loadTexture(@NotNull class_3300 pResourceManager) throws IOException {
        AnimatableTexture animatableTexture;
        boolean animated;
        class_1011 class_10112;
        class_1044 originalTexture;
        try {
            originalTexture = (class_1044)class_310.method_1551().method_5385(() -> TextureUtils.getTexture(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + String.valueOf(this.textureBase), e);
        }
        class_3298 textureBaseResource = (class_3298)pResourceManager.method_14486(this.textureBase).get();
        if (originalTexture instanceof class_1043) {
            class_1043 dynamicTexture = (class_1043)originalTexture;
            class_10112 = dynamicTexture.method_4525();
        } else {
            class_10112 = class_1011.method_4309((InputStream)textureBaseResource.method_14482());
        }
        class_1011 baseImage = class_10112;
        class_1011 glowImage = null;
        Optional textureBaseMeta = textureBaseResource.method_14481().method_43041((class_3270)class_1084.field_5344);
        boolean blur = textureBaseMeta.isPresent() && ((class_1084)textureBaseMeta.get()).method_4696();
        boolean clamp = textureBaseMeta.isPresent() && ((class_1084)textureBaseMeta.get()).method_4697();
        try {
            Optional glowLayerResource = pResourceManager.method_14486(this.glowLayer);
            GlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource.isPresent()) {
                glowImage = class_1011.method_4309((InputStream)((class_3298)glowLayerResource.get()).method_14482());
                glowLayerMeta = GlowingTextureMeta.fromExistingImage(glowImage);
            } else {
                Optional meta = textureBaseResource.method_14481().method_43041(GlowingTextureMeta.DESERIALIZER);
                if (meta.isPresent()) {
                    glowLayerMeta = (GlowingTextureMeta)meta.get();
                    glowImage = new class_1011(baseImage.method_4307(), baseImage.method_4323(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (PRINT_DEBUG_IMAGES && BlueLibConstants.PlatformHelper.PLATFORM.isDevelopmentEnvironment()) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            BaseLogger.log(BaseLogLevel.WARNING, "Resource failed to open for glowlayer meta: " + String.valueOf(this.glowLayer), e);
        }
        class_1011 mask = glowImage;
        if (mask == null) {
            return null;
        }
        boolean bl = animated = originalTexture instanceof AnimatableTexture && (animatableTexture = (AnimatableTexture)originalTexture).isAnimated();
        if (animated) {
            ((AnimatableTexture)originalTexture).animationContents.animatedTexture.setGlowMaskTexture(this, baseImage, mask);
        }
        return () -> {
            if (!animated) {
                AutoGlowingTexture.uploadSimple(this.method_4624(), mask, blur, clamp);
            }
            if (originalTexture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)originalTexture;
                dynamicTexture.method_4524();
            } else {
                AutoGlowingTexture.uploadSimple(originalTexture.method_4624(), baseImage, blur, clamp);
            }
        };
    }

    @NotNull
    public static class_1921 getRenderType(@NotNull class_2960 pTexture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(pTexture), false);
    }

    @NotNull
    public static class_1921 getOutlineRenderType(@NotNull class_2960 pTexture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(pTexture), true);
    }
}

