/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.BlueLibConstants;
import software.bluelib.client.utils.TextureUtils;

public abstract class BlueAbstractTexture
extends class_1044 {
    protected static void generateTexture(@NotNull class_2960 pTexturePath, @NotNull Consumer<class_1060> pTextureManagerConsumer) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            throw new IllegalThreadStateException("Texture loading called outside of the render thread! This should DEFINITELY not be happening.");
        }
        class_1060 textureManager = TextureUtils.getTextureManager();
        if (!(textureManager.method_34590(pTexturePath, (class_1044)class_1047.method_4540()) instanceof BlueAbstractTexture)) {
            pTextureManagerConsumer.accept(textureManager);
        }
    }

    public final void method_4625(@NotNull class_3300 pResourceManager) throws IOException {
        class_4573 renderCall = this.loadTexture(pResourceManager);
        if (renderCall == null) {
            return;
        }
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall((class_4573)renderCall);
        } else {
            renderCall.execute();
        }
    }

    protected void printDebugImageToDisk(@NotNull class_2960 pId, @NotNull class_1011 pNewImage) {
        try {
            File file = new File(BlueLibConstants.PlatformHelper.PLATFORM.getGameDir().toFile(), "BlueTexture Debug Printouts");
            if (!file.exists()) {
                file.mkdirs();
            } else if (!file.isDirectory()) {
                file.delete();
                file.mkdirs();
            }
            file = new File(file, pId.method_12832().replace('/', '.'));
            if (!file.exists()) {
                file.createNewFile();
            }
            pNewImage.method_4325(file);
        }
        catch (IOException pIoException) {
            pIoException.printStackTrace();
        }
    }

    @Nullable
    protected abstract class_4573 loadTexture(@NotNull class_3300 var1) throws IOException;

    public static void uploadSimple(@NotNull Integer pTexture, @NotNull class_1011 pImage, boolean pBlur, boolean pClamp) {
        TextureUtil.prepareImage((int)pTexture, (int)0, (int)pImage.method_4307(), (int)pImage.method_4323());
        pImage.method_22619(0, 0, 0, 0, 0, pImage.method_4307(), pImage.method_4323(), pBlur, pClamp, false, true);
    }

    public static class_2960 appendToPath(@NotNull class_2960 pLocation, @NotNull String pSuffix) {
        String path = pLocation.method_12832();
        int i = path.lastIndexOf(46);
        return class_2960.method_60655((String)pLocation.method_12836(), (String)(path.substring(0, i) + pSuffix + path.substring(i)));
    }
}

