/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.molang.MoLang;
import software.bluelib.api.molang.MoLangUtils;
import software.bluelib.api.utils.loader.LoaderUtils;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.Animation;
import software.bluelib.loader.animation.AnimationController;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.animation.state.PlayState;
import software.bluelib.loader.cache.ResourceCache;
import software.bluelib.loader.cache.controller.AnimationCache;
import software.bluelib.loader.cache.controller.BehaviourCache;
import software.bluelib.loader.cache.controller.ControllerCache;
import software.bluelib.loader.cache.controller.GroupCache;
import software.bluelib.loader.cache.controller.StateCache;

public class ControllerManager<T extends BlueAnimatable> {
    public void registerControllers(@NotNull BlueAnimatable pAnimatable, @NotNull ControllerCache pCache, @NotNull AnimatableManager.ControllerRegistrar<T> pControllers) {
        List<GroupCache> groups = pCache.groups();
        for (GroupCache group : groups) {
            Map<String, BehaviourCache> behaviours = group.behaviours();
            if (behaviours.isEmpty()) continue;
            pControllers.add(new AnimationController<BlueAnimatable>(pAnimatable, "main", 5, k -> {
                ArrayList validBehaviours = new ArrayList();
                int maxPriority = Integer.MIN_VALUE;
                for (Map.Entry entry : behaviours.entrySet()) {
                    BehaviourCache behaviour = (BehaviourCache)entry.getValue();
                    boolean hasNonOverlayState = behaviour.states().values().stream().anyMatch(state -> !state.isOverlay());
                    if (!hasNonOverlayState) continue;
                    int priority = ControllerManager.getEffectiveBehaviourPriority(behaviour, pAnimatable);
                    if (priority > maxPriority) {
                        validBehaviours.clear();
                        maxPriority = priority;
                    }
                    if (priority != maxPriority || priority == Integer.MIN_VALUE) continue;
                    validBehaviours.add(entry);
                }
                Iterator iterator = validBehaviours.iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry;
                    entry = iterator.next();
                    return ControllerManager.animationController(k, (BehaviourCache)entry.getValue(), pAnimatable, false);
                }
                return PlayState.PLAY;
            }));
            for (Map.Entry<String, BehaviourCache> entry : behaviours.entrySet()) {
                BehaviourCache behaviour = entry.getValue();
                for (Map.Entry<String, StateCache> stateEntry : behaviour.states().entrySet()) {
                    StateCache state = stateEntry.getValue();
                    if (!state.isOverlay()) continue;
                    pControllers.add(new AnimationController<BlueAnimatable>(pAnimatable, "overlay_" + entry.getKey() + "_" + stateEntry.getKey(), 5, k -> {
                        int priority = ControllerManager.getEffectiveBehaviourPriority(behaviour, pAnimatable);
                        if (priority == Integer.MIN_VALUE) {
                            return PlayState.PLAY;
                        }
                        return ControllerManager.animationController(k, behaviour, pAnimatable, true);
                    }));
                }
            }
        }
    }

    @NotNull
    protected static <E extends BlueAnimatable> PlayState animationController(@NotNull AnimationState<E> pEvent, @NotNull BehaviourCache pBehaviour, @NotNull BlueAnimatable pAnimatable, boolean pOverlayOnly) {
        for (Map.Entry<String, StateCache> entry : pBehaviour.states().entrySet()) {
            List<AnimationCache> animations;
            StateCache state = entry.getValue();
            if (pOverlayOnly && !state.isOverlay() || !pOverlayOnly && state.isOverlay() || (animations = state.animations()).isEmpty()) continue;
            ArrayList<AnimationCache> sortedAnimations = new ArrayList<AnimationCache>(animations);
            sortedAnimations.sort((pA, pB) -> {
                int a = ControllerManager.getEffectivePriority(pA, pAnimatable);
                int b = ControllerManager.getEffectivePriority(pB, pAnimatable);
                return Integer.compare(b, a);
            });
            AnimationCache selected = (AnimationCache)sortedAnimations.getFirst();
            int selectedPriority = ControllerManager.getEffectivePriority(selected, pAnimatable);
            if (selectedPriority == Integer.MIN_VALUE) {
                return PlayState.STOP;
            }
            return pEvent.setAndContinue(Animation.begin().thenLoop(selected.animation()));
        }
        return PlayState.PLAY;
    }

    private static int getEffectivePriority(@Nullable Integer pPriority, @NotNull List<String> pConditions, @NotNull BlueAnimatable pAnimatable) {
        int effectivePriority;
        int n = effectivePriority = pPriority == null ? Integer.MIN_VALUE : pPriority;
        if (pAnimatable instanceof class_1297) {
            class_1297 entity = (class_1297)pAnimatable;
            for (String condition : pConditions) {
                Object loadedResult = MoLang.evaluate(condition);
                Object entityResult = MoLangUtils.entity(condition, entity);
                if ((!(loadedResult instanceof Boolean) || !((Boolean)loadedResult).booleanValue()) && (!(entityResult instanceof Boolean) || !((Boolean)entityResult).booleanValue())) continue;
                return effectivePriority;
            }
            return Integer.MIN_VALUE;
        }
        return effectivePriority;
    }

    private static int getEffectivePriority(@NotNull AnimationCache pState, @NotNull BlueAnimatable pAnimatable) {
        return ControllerManager.getEffectivePriority(pState.priority(), pState.conditions(), pAnimatable);
    }

    private static int getEffectiveBehaviourPriority(@NotNull BehaviourCache pBehaviour, @NotNull BlueAnimatable pAnimatable) {
        return ControllerManager.getEffectivePriority(pBehaviour.priority(), pBehaviour.conditions(), pAnimatable);
    }

    @NotNull
    public static ControllerCache getBakedController(@NotNull class_2960 pLocation) {
        class_2960[] attempts;
        for (class_2960 loc : attempts = new class_2960[]{pLocation, LoaderUtils.stripSuffix(".json", pLocation), LoaderUtils.stripSuffix(".controller.json", pLocation)}) {
            ControllerCache controller = ResourceCache.Server.getControllers().get(loc);
            if (controller == null) continue;
            return controller;
        }
        if (!pLocation.method_12832().contains("controller/")) {
            throw new RuntimeException("Invalid controller resource path provided - BlueLib controllers must be placed in data/<modid>/controllers/");
        }
        throw new RuntimeException("Unable to find controller file: " + String.valueOf(pLocation));
    }
}

