/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.geckolib.constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.loader.geckolib.constant.dataticket.DataTicket;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;
import software.bluelib.loader.geckolib.data.EntityModelData;

public final class DataTickets {
    private static final Map<String, SerializableDataTicket<?>> SERIALIZABLE_TICKETS = new ConcurrentHashMap();
    public static final DataTicket<class_2586> BLOCK_ENTITY = new DataTicket<class_2586>("block_entity", class_2586.class);
    public static final DataTicket<class_1799> ITEMSTACK = new DataTicket<class_1799>("itemstack", class_1799.class);
    public static final DataTicket<class_1297> ENTITY = new DataTicket<class_1297>("entity", class_1297.class);
    public static final DataTicket<class_1304> EQUIPMENT_SLOT = new DataTicket<class_1304>("equipment_slot", class_1304.class);
    public static final DataTicket<EntityModelData> ENTITY_MODEL_DATA = new DataTicket<EntityModelData>("entity_model_data", EntityModelData.class);
    public static final DataTicket<Double> TICK = new DataTicket<Double>("tick", Double.class);
    public static final DataTicket<class_811> ITEM_RENDER_PERSPECTIVE = new DataTicket<class_811>("item_render_perspective", class_811.class);

    @Nullable
    public static SerializableDataTicket<?> byName(String pId) {
        return SERIALIZABLE_TICKETS.getOrDefault(pId, null);
    }

    public static <D> SerializableDataTicket<D> registerSerializable(SerializableDataTicket<D> pTicket) {
        SerializableDataTicket<D> existingTicket = SERIALIZABLE_TICKETS.putIfAbsent(pTicket.id(), pTicket);
        if (existingTicket != null) {
            BaseLogger.log(BaseLogLevel.ERROR, "Duplicate SerializableDataTicket registered! This will cause issues. Existing: " + existingTicket.id() + ", New: " + pTicket.id());
        }
        return pTicket;
    }
}

