/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.geckolib.math;

import com.google.common.collect.Streams;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1407;
import net.minecraft.class_1409;
import net.minecraft.class_1410;
import net.minecraft.class_1412;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4582;
import net.minecraft.class_5146;
import net.minecraft.class_5354;
import net.minecraft.class_5498;
import net.minecraft.class_5766;
import net.minecraft.class_6025;
import net.minecraft.class_9817;
import software.bluelib.client.utils.PlayerUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.geckolib.math.value.Variable;

public final class MoLangQueries {
    public static final String ACTOR_COUNT = "q.actor_count";
    public static final String ANIM_TIME = "q.anim_time";
    public static final String BLOCKING = "q.blocking";
    public static final String BLOCK_STATE = "q.block_state";
    public static final String BODY_X_ROTATION = "q.body_x_rotation";
    public static final String BODY_Y_ROTATION = "q.body_y_rotation";
    public static final String CAN_CLIMB = "q.can_climb";
    public static final String CAN_FLY = "q.can_fly";
    public static final String CAN_SWIM = "q.can_swim";
    public static final String CAN_WALK = "q.can_walk";
    public static final String CARDINAL_FACING = "q.cardinal_facing";
    public static final String CARDINAL_FACING_2D = "q.cardinal_facing_2d";
    public static final String CARDINAL_PLAYER_FACING = "q.cardinal_player_facing";
    public static final String CONTROLLER_SPEED = "q.controller_speed";
    public static final String DAY = "q.day";
    public static final String DEATH_TICKS = "q.death_ticks";
    public static final String DISTANCE_FROM_CAMERA = "q.distance_from_camera";
    public static final String EQUIPMENT_COUNT = "q.equipment_count";
    public static final String FRAME_ALPHA = "q.frame_alpha";
    public static final String GET_ACTOR_INFO_ID = "q.get_actor_info_id";
    public static final String GROUND_SPEED = "q.ground_speed";
    public static final String HAS_CAPE = "q.has_cape";
    public static final String HAS_COLLISION = "q.has_collision";
    public static final String HAS_GRAVITY = "q.has_gravity";
    public static final String HAS_HEAD_GEAR = "q.has_head_gear";
    public static final String HAS_OWNER = "q.has_owner";
    public static final String HAS_PLAYER_RIDER = "q.has_player_rider";
    public static final String HAS_RIDER = "q.has_rider";
    public static final String HEAD_X_ROTATION = "q.head_x_rotation";
    public static final String HEAD_Y_ROTATION = "q.head_y_rotation";
    public static final String HEALTH = "q.health";
    public static final String HURT_TIME = "q.hurt_time";
    public static final String INVULNERABLE_TICKS = "q.invulnerable_ticks";
    public static final String IS_ALIVE = "q.is_alive";
    public static final String IS_ANGRY = "q.is_angry";
    public static final String IS_BABY = "q.is_baby";
    public static final String IS_BREATHING = "q.is_breathing";
    public static final String IS_ENCHANTED = "q.is_enchanted";
    public static final String IS_FIRE_IMMUNE = "q.is_fire_immune";
    public static final String IS_FIRST_PERSON = "q.is_first_person";
    public static final String IS_INVISIBLE = "q.is_invisible";
    public static final String IS_IN_CONTACT_WITH_WATER = "q.is_in_contact_with_water";
    public static final String IS_IN_LAVA = "q.is_in_lava";
    public static final String IS_IN_WATER = "q.is_in_water";
    public static final String IS_IN_WATER_OR_RAIN = "q.is_in_water_or_rain";
    public static final String IS_LEASHED = "q.is_leashed";
    public static final String IS_MOVING = "q.is_moving";
    public static final String IS_ON_FIRE = "q.is_on_fire";
    public static final String IS_ON_GROUND = "q.is_on_ground";
    public static final String IS_POWERED = "q.is_powered";
    public static final String IS_RIDING = "q.is_riding";
    public static final String IS_SADDLED = "q.is_saddled";
    public static final String IS_SILENT = "q.is_silent";
    public static final String IS_SLEEPING = "q.is_sleeping";
    public static final String IS_SNEAKING = "q.is_sneaking";
    public static final String IS_SPRINTING = "q.is_sprinting";
    public static final String IS_STACKABLE = "q.is_stackable";
    public static final String IS_SWIMMING = "q.is_swimming";
    public static final String IS_USING_ITEM = "q.is_using_item";
    public static final String IS_WALL_CLIMBING = "q.is_wall_climbing";
    public static final String ITEM_MAX_USE_DURATION = "q.item_max_use_duration";
    public static final String LIFE_TIME = "q.life_time";
    public static final String MAIN_HAND_ITEM_MAX_DURATION = "q.main_hand_item_max_duration";
    public static final String MAIN_HAND_ITEM_USE_DURATION = "q.main_hand_item_use_duration";
    public static final String MAX_DURABILITY = "q.max_durability";
    public static final String MAX_HEALTH = "q.max_health";
    public static final String MOON_BRIGHTNESS = "q.moon_brightness";
    public static final String MOON_PHASE = "q.moon_phase";
    public static final String MOVEMENT_DIRECTION = "q.movement_direction";
    public static final String PLAYER_LEVEL = "q.player_level";
    public static final String REMAINING_DURABILITY = "q.remaining_durability";
    public static final String RIDER_BODY_X_ROTATION = "q.rider_body_x_rotation";
    public static final String RIDER_BODY_Y_ROTATION = "q.rider_body_y_rotation";
    public static final String RIDER_HEAD_X_ROTATION = "q.rider_head_x_rotation";
    public static final String RIDER_HEAD_Y_ROTATION = "q.rider_head_y_rotation";
    public static final String SCALE = "q.scale";
    public static final String SLEEP_ROTATION = "q.sleep_rotation";
    public static final String TIME_OF_DAY = "q.time_of_day";
    public static final String TIME_STAMP = "q.time_stamp";
    public static final String VERTICAL_SPEED = "q.vertical_speed";
    public static final String YAW_SPEED = "q.yaw_speed";
    private static final Map<String, Variable> VARIABLES = new ConcurrentHashMap<String, Variable>();
    private static Actor<?> ACTOR = null;

    public static boolean isExistingVariable(String pName) {
        return VARIABLES.containsKey(pName);
    }

    static void registerVariable(Variable pVariable) {
        VARIABLES.put(pVariable.name(), pVariable);
    }

    static Variable getVariableFor(String pName) {
        return VARIABLES.computeIfAbsent(MoLangQueries.applyPrefixAliases(pName, "q.", "q."), key -> new Variable((String)key, 0.0));
    }

    private static String applyPrefixAliases(String pText, String pProperName, String ... pAliases) {
        for (String alias : pAliases) {
            if (!pText.startsWith(alias)) continue;
            return pProperName + pText.substring(alias.length());
        }
        return pText;
    }

    public static void updateActor(AnimationState<? extends BlueAnimatable> pAnimationState, double pAnimTime) {
        ACTOR = new Actor<BlueAnimatable>(pAnimationState, pAnimationState.getAnimatable(), pAnimTime, class_310.method_1551(), (class_1937)class_310.method_1551().field_1687);
    }

    public static void clearActor() {
        ACTOR = null;
    }

    public static <T> void setActorVariable(String pName, ToDoubleFunction<Actor<T>> pValue) {
        MoLangQueries.getVariableFor(pName).set(() -> pValue.applyAsDouble(MoLangQueries.getActor()));
    }

    private static Actor<?> getActor() {
        return ACTOR;
    }

    private static void setDefaultQueryValues() {
        MoLangQueries.getVariableFor("PI").set(Math.PI);
        MoLangQueries.getVariableFor("E").set(Math.E);
        MoLangQueries.setActorVariable(CONTROLLER_SPEED, actor -> actor.animationState.getController().getAnimationSpeed());
        MoLangQueries.setActorVariable(CARDINAL_PLAYER_FACING, actor -> actor.mc.field_1724.method_5735().ordinal());
        MoLangQueries.setActorVariable(DAY, actor -> (double)actor.level.method_8510() / 24000.0);
        MoLangQueries.setActorVariable(FRAME_ALPHA, actor -> actor.animationState().getPartialTick());
        MoLangQueries.setActorVariable(HAS_CAPE, actor -> actor.mc.field_1724.method_52814().comp_1627() != null ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_FIRST_PERSON, actor -> actor.mc.field_1690.method_31044() == class_5498.field_26664 ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(LIFE_TIME, actor -> actor.animTime / 20.0);
        MoLangQueries.setActorVariable(MOON_BRIGHTNESS, actor -> actor.level.method_30272());
        MoLangQueries.setActorVariable(MOON_PHASE, actor -> actor.level.method_30273());
        MoLangQueries.setActorVariable(PLAYER_LEVEL, actor -> actor.mc.field_1724.field_7520);
        MoLangQueries.setActorVariable(TIME_OF_DAY, actor -> (float)actor.level.method_8532() / 24000.0f);
        MoLangQueries.setActorVariable(TIME_STAMP, actor -> actor.mc.field_1687.method_8510());
        MoLangQueries.setDefaultBlockEntityQueryValues();
        MoLangQueries.setDefaultEntityQueryValues();
        MoLangQueries.setDefaultLivingEntityQueryValues();
        MoLangQueries.setDefaultMobQueryValues();
        MoLangQueries.setDefaultItemQueryValues();
    }

    private static void setDefaultBlockEntityQueryValues() {
        MoLangQueries.setActorVariable(BLOCK_STATE, actor -> ((class_2586)actor.animatable).method_11010().method_26204().method_9595().method_11662().indexOf((Object)((class_2586)actor.animatable).method_11010()));
    }

    private static void setDefaultEntityQueryValues() {
        MoLangQueries.setActorVariable(BODY_X_ROTATION, actor -> actor.animatable instanceof class_1309 ? 0.0 : (double)((class_1297)actor.animatable).method_5695(actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(BODY_Y_ROTATION, actor -> {
            float f;
            Object patt0$temp = actor.animatable;
            if (patt0$temp instanceof class_1309) {
                class_1309 living = (class_1309)patt0$temp;
                f = class_3532.method_16439((float)actor.animationState.getPartialTick(), (float)living.field_6220, (float)living.field_6283);
            } else {
                f = ((class_1297)actor.animatable).method_5705(actor.animationState.getPartialTick());
            }
            return f;
        });
        MoLangQueries.setActorVariable(CARDINAL_FACING, actor -> ((class_1297)actor.animatable).method_5735().method_10146());
        MoLangQueries.setActorVariable(CARDINAL_FACING_2D, actor -> {
            int directionId = ((class_1297)actor.animatable).method_5735().method_10146();
            return directionId < 2 ? 6.0 : (double)directionId;
        });
        MoLangQueries.setActorVariable(DISTANCE_FROM_CAMERA, actor -> actor.mc.field_1773.method_19418().method_19326().method_1022(((class_1297)actor.animatable).method_19538()));
        MoLangQueries.setActorVariable(GET_ACTOR_INFO_ID, actor -> ((class_1297)actor.animatable).method_5628());
        MoLangQueries.setActorVariable(HAS_COLLISION, actor -> !((class_1297)actor.animatable).field_5960 ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(HAS_GRAVITY, actor -> !((class_1297)actor.animatable).method_5740() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(HAS_OWNER, actor -> {
            class_6025 ownable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof class_6025 && (ownable = (class_6025)patt0$temp).method_6139() != null ? 1 : 0;
        });
        MoLangQueries.setActorVariable(HAS_PLAYER_RIDER, actor -> ((class_1297)actor.animatable).method_5703(class_1657.class::isInstance) ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(HAS_RIDER, actor -> ((class_1297)actor.animatable).method_5782() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_ALIVE, actor -> ((class_1297)actor.animatable).method_5805() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_ANGRY, actor -> {
            class_5354 neutralMob;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof class_5354 && (neutralMob = (class_5354)patt0$temp).method_29511() ? 1 : 0;
        });
        MoLangQueries.setActorVariable(IS_BREATHING, actor -> ((class_1297)actor.animatable).method_5669() >= ((class_1297)actor.animatable).method_5748() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_FIRE_IMMUNE, actor -> ((class_1297)actor.animatable).method_5864().method_19946() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_INVISIBLE, actor -> ((class_1297)actor.animatable).method_5767() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_IN_CONTACT_WITH_WATER, actor -> ((class_1297)actor.animatable).method_5637() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_IN_LAVA, actor -> ((class_1297)actor.animatable).method_5771() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_IN_WATER, actor -> ((class_1297)actor.animatable).method_5799() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_IN_WATER_OR_RAIN, actor -> ((class_1297)actor.animatable).method_5721() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_LEASHED, actor -> {
            class_9817 leashable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof class_9817 && (leashable = (class_9817)patt0$temp).method_60953() ? 1 : 0;
        });
        MoLangQueries.setActorVariable(IS_MOVING, actor -> actor.animationState.isMoving() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_ON_FIRE, actor -> ((class_1297)actor.animatable).method_5809() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_ON_GROUND, actor -> ((class_1297)actor.animatable).method_24828() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_POWERED, actor -> {
            class_4582 powerable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof class_4582 && (powerable = (class_4582)patt0$temp).method_6872() ? 1 : 0;
        });
        MoLangQueries.setActorVariable(IS_RIDING, actor -> ((class_1297)actor.animatable).method_5765() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SADDLED, actor -> {
            class_5146 saddleable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof class_5146 && (saddleable = (class_5146)patt0$temp).method_6725() ? 1 : 0;
        });
        MoLangQueries.setActorVariable(IS_SILENT, actor -> ((class_1297)actor.animatable).method_5701() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SNEAKING, actor -> ((class_1297)actor.animatable).method_18276() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SPRINTING, actor -> ((class_1297)actor.animatable).method_5624() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SWIMMING, actor -> ((class_1297)actor.animatable).method_5681() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(MOVEMENT_DIRECTION, actor -> actor.animationState.isMoving() ? (double)class_2350.method_58251((class_243)((class_1297)actor.animatable).method_18798()).method_10146() : 6.0);
        MoLangQueries.setActorVariable(RIDER_BODY_X_ROTATION, actor -> ((class_1297)actor.animatable).method_5782() ? (((class_1297)actor.animatable).method_31483() instanceof class_1309 ? 0.0 : (double)((class_1297)actor.animatable).method_31483().method_5695(actor.animationState.getPartialTick())) : 0.0);
        MoLangQueries.setActorVariable(RIDER_BODY_Y_ROTATION, actor -> {
            float f;
            if (((class_1297)actor.animatable).method_5782()) {
                class_1297 patt0$temp = ((class_1297)actor.animatable).method_31483();
                if (patt0$temp instanceof class_1309) {
                    class_1309 living = (class_1309)patt0$temp;
                    f = class_3532.method_16439((float)actor.animationState.getPartialTick(), (float)living.field_6220, (float)living.field_6283);
                } else {
                    f = ((class_1297)actor.animatable).method_31483().method_5705(actor.animationState.getPartialTick());
                }
            } else {
                f = 0.0f;
            }
            return f;
        });
        MoLangQueries.setActorVariable(RIDER_HEAD_X_ROTATION, actor -> {
            double d;
            class_1297 patt0$temp = ((class_1297)actor.animatable).method_31483();
            if (patt0$temp instanceof class_1309) {
                class_1309 living = (class_1309)patt0$temp;
                d = living.method_5695(actor.animationState.getPartialTick());
            } else {
                d = 0.0;
            }
            return d;
        });
        MoLangQueries.setActorVariable(RIDER_HEAD_Y_ROTATION, actor -> {
            double d;
            class_1297 patt0$temp = ((class_1297)actor.animatable).method_31483();
            if (patt0$temp instanceof class_1309) {
                class_1309 living = (class_1309)patt0$temp;
                d = living.method_5705(actor.animationState.getPartialTick());
            } else {
                d = 0.0;
            }
            return d;
        });
        MoLangQueries.setActorVariable(VERTICAL_SPEED, actor -> ((class_1297)actor.animatable).method_18798().field_1351);
        MoLangQueries.setActorVariable(YAW_SPEED, actor -> ((class_1297)actor.animatable).method_36454() - ((class_1297)actor.animatable).field_5982);
    }

    private static void setDefaultLivingEntityQueryValues() {
        MoLangQueries.setActorVariable(BLOCKING, actor -> ((class_1309)actor.animatable).method_6039() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(DEATH_TICKS, actor -> ((class_1309)actor.animatable).field_6213 == 0 ? 0.0 : (double)((float)((class_1309)actor.animatable).field_6213 + actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(EQUIPMENT_COUNT, actor -> Streams.stream((Iterable)((class_1309)actor.animatable).method_5661()).filter(stack -> !stack.method_7960()).count());
        MoLangQueries.setActorVariable(GROUND_SPEED, actor -> ((class_1309)actor.animatable).method_18798().method_37267());
        MoLangQueries.setActorVariable(HAS_HEAD_GEAR, actor -> !((class_1309)actor.animatable).method_6118(class_1304.field_6169).method_7960() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(HEAD_X_ROTATION, actor -> ((class_1309)actor.animatable).method_5695(actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(HEAD_Y_ROTATION, actor -> ((class_1309)actor.animatable).method_5705(actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(HEALTH, actor -> ((class_1309)actor.animatable).method_6032());
        MoLangQueries.setActorVariable(HURT_TIME, actor -> ((class_1309)actor.animatable).field_6235 == 0 ? 0.0 : (double)((float)((class_1309)actor.animatable).field_6235 - actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(INVULNERABLE_TICKS, actor -> ((class_1309)actor.animatable).field_6008 == 0 ? 0.0 : (double)((float)((class_1309)actor.animatable).field_6008 - actor.animationState.getPartialTick()));
        MoLangQueries.setActorVariable(IS_BABY, actor -> ((class_1309)actor.animatable).method_6109() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_SLEEPING, actor -> ((class_1309)actor.animatable).method_6113() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_USING_ITEM, actor -> ((class_1309)actor.animatable).method_6115() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_WALL_CLIMBING, actor -> ((class_1309)actor.animatable).method_6101() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(MAIN_HAND_ITEM_MAX_DURATION, actor -> ((class_1309)actor.animatable).method_6047().method_7935((class_1309)actor.animatable));
        MoLangQueries.setActorVariable(MAIN_HAND_ITEM_USE_DURATION, actor -> ((class_1309)actor.animatable).method_6058() == class_1268.field_5808 ? (double)((class_1309)actor.animatable).method_6048() / 20.0 + (double)actor.animationState.getPartialTick() : 0.0);
        MoLangQueries.setActorVariable(MAX_HEALTH, actor -> ((class_1309)actor.animatable).method_6063());
        MoLangQueries.setActorVariable(SCALE, actor -> ((class_1309)actor.animatable).method_55693());
        MoLangQueries.setActorVariable(SLEEP_ROTATION, actor -> Optional.ofNullable(((class_1309)actor.animatable).method_18401()).map(class_2350::method_10144).orElse(Float.valueOf(0.0f)).floatValue());
    }

    private static void setDefaultMobQueryValues() {
        MoLangQueries.setActorVariable(CAN_CLIMB, actor -> !((class_1308)actor.animatable).method_5987() && ((class_1308)actor.animatable).method_5942() instanceof class_1410 ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(CAN_FLY, actor -> !((class_1308)actor.animatable).method_5987() && ((class_1308)actor.animatable).method_5942() instanceof class_1407 ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(CAN_SWIM, actor -> !((class_1308)actor.animatable).method_5987() && ((class_1308)actor.animatable).method_5942() instanceof class_1412 || ((class_1308)actor.animatable).method_5942() instanceof class_5766 ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(CAN_WALK, actor -> !((class_1308)actor.animatable).method_5987() && ((class_1308)actor.animatable).method_5942() instanceof class_1409 || ((class_1308)actor.animatable).method_5942() instanceof class_5766 ? 1.0 : 0.0);
    }

    private static void setDefaultItemQueryValues() {
        MoLangQueries.setActorVariable(IS_ENCHANTED, actor -> actor.animationState.getData(DataTickets.ITEMSTACK).method_7942() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(IS_STACKABLE, actor -> actor.animationState.getData(DataTickets.ITEMSTACK).method_7946() ? 1.0 : 0.0);
        MoLangQueries.setActorVariable(ITEM_MAX_USE_DURATION, actor -> actor.animationState.getData(DataTickets.ITEMSTACK).method_7935((class_1309)PlayerUtils.getClientPlayer()));
        MoLangQueries.setActorVariable(MAX_DURABILITY, actor -> actor.animationState.getData(DataTickets.ITEMSTACK).method_7936());
        MoLangQueries.setActorVariable(REMAINING_DURABILITY, actor -> {
            class_1799 stack = actor.animationState.getData(DataTickets.ITEMSTACK);
            return stack.method_7963() ? (double)(stack.method_7936() - stack.method_7919()) : 1.0;
        });
    }

    static {
        MoLangQueries.setDefaultQueryValues();
    }

    public record Actor<T>(AnimationState<? extends BlueAnimatable> animationState, T animatable, double animTime, class_310 mc, class_1937 level) {
    }
}

