/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.loader.JsonUtils;
import software.bluelib.loader.json.deserialize.model.Cube;
import software.bluelib.loader.json.deserialize.model.LocatorValue;
import software.bluelib.loader.json.deserialize.model.PolyMesh;
import software.bluelib.loader.json.deserialize.model.TextureMesh;

public record Bone(@NotNull List<Float> bindPoseRotation, @NotNull List<Cube> cubes, @Nullable Boolean debug, @Nullable Float inflate, @Nullable Map<String, LocatorValue> locators, @Nullable Boolean mirror, @Nullable String name, @Nullable Boolean neverRender, @Nullable String parent, @NotNull List<Float> pivot, @Nullable PolyMesh polyMesh, @Nullable Long renderGroupId, @Nullable Boolean reset, @NotNull List<Float> rotation, @Nullable List<TextureMesh> textureMeshes) {
    @NotNull
    public static JsonDeserializer<Bone> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            List<Float> bindPoseRotation = JsonUtils.jsonArrayToFloatList(JsonUtils.getOptionalJsonArray(obj, "bind_pose_rotation"));
            List<Cube> cubes = JsonUtils.jsonArrayToObjectList(class_3518.method_15292((JsonObject)obj, (String)"cubes", (JsonArray)new JsonArray(0)), context, Cube.class);
            Boolean debug = JsonUtils.getOptionalBoolean(obj, "debug");
            Float inflate = JsonUtils.getOptionalFloat(obj, "inflate");
            Map<String, LocatorValue> locators = obj.has("locators") ? JsonUtils.jsonObjToMap(class_3518.method_15296((JsonObject)obj, (String)"locators"), context, LocatorValue.class) : null;
            Boolean mirror = JsonUtils.getOptionalBoolean(obj, "mirror");
            String name = JsonUtils.getOptionalString(obj, "name");
            Boolean neverRender = JsonUtils.getOptionalBoolean(obj, "neverRender");
            String parent = JsonUtils.getOptionalString(obj, "parent");
            List<Float> pivot = JsonUtils.jsonArrayToFloatList(class_3518.method_15292((JsonObject)obj, (String)"pivot", (JsonArray)new JsonArray(0)));
            PolyMesh polyMesh = JsonUtils.getOptionalObject(obj, "poly_mesh", context, PolyMesh.class);
            Long renderGroupId = JsonUtils.getOptionalLong(obj, "render_group_id");
            Boolean reset = JsonUtils.getOptionalBoolean(obj, "reset");
            List<Float> rotation = JsonUtils.jsonArrayToFloatList(JsonUtils.getOptionalJsonArray(obj, "rotation"));
            List<TextureMesh> textureMeshes = JsonUtils.jsonArrayToObjectList(class_3518.method_15292((JsonObject)obj, (String)"texture_meshes", (JsonArray)new JsonArray(0)), context, TextureMesh.class);
            return new Bone(bindPoseRotation, cubes, debug, inflate, locators, mirror, name, neverRender, parent, pivot, polyMesh, renderGroupId, reset, rotation, textureMeshes);
        };
    }
}

