/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.model.object;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.json.deserialize.model.Bone;
import software.bluelib.loader.json.deserialize.model.Model;
import software.bluelib.loader.json.deserialize.model.ModelDescription;
import software.bluelib.loader.json.deserialize.model.ModelGeometry;
import software.bluelib.loader.json.model.object.BoneStructure;

public record BoneTree(@NotNull Map<String, BoneStructure> topLevelBones, @Nullable ModelDescription description) {
    @NotNull
    public static BoneTree fromModel(@NotNull Model pModel) {
        Object2ObjectOpenHashMap topLevelBones = new Object2ObjectOpenHashMap();
        ModelGeometry geometry = pModel.ModelGeometry().getFirst();
        List<Bone> bones = geometry.bones();
        Object2ObjectOpenHashMap lookup = new Object2ObjectOpenHashMap(bones.size());
        for (Bone bone : bones) {
            BoneStructure boneStructure = new BoneStructure(bone);
            lookup.put(bone.name(), boneStructure);
            if (bone.parent() != null) continue;
            topLevelBones.put(bone.name(), boneStructure);
        }
        for (Bone bone : bones) {
            String parentName = bone.parent();
            if (parentName == null) continue;
            String boneName = bone.name();
            if (parentName.equals(boneName)) {
                throw new IllegalArgumentException("Invalid model definition. Bone has defined itself as its own parent: " + boneName);
            }
            BoneStructure parentStructure = (BoneStructure)lookup.get(parentName);
            if (parentStructure == null) {
                throw new IllegalArgumentException("Invalid model definition. Found bone with undefined parent (child -> parent): " + boneName + " -> " + parentName);
            }
            parentStructure.children().put(boneName, (BoneStructure)lookup.get(boneName));
        }
        return new BoneTree((Map<String, BoneStructure>)topLevelBones, geometry.modelDescription());
    }
}

