/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.dataticket.DataTicket;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class BlueObjectRenderer<T extends BlueAnimatable>
implements BlueRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @Nullable
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    @NotNull
    protected Matrix4f objectRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public BlueObjectRenderer(@NotNull BlueModel<T> pModel) {
        this.model = pModel;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @Nullable
    public T getOptionalAnimatable() {
        return this.animatable;
    }

    @Override
    @NotNull
    public class_2960 getTextureLocation(@NotNull T pAnimatable) {
        return BlueRenderer.super.getTextureLocation(pAnimatable);
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueObjectRenderer<T> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueObjectRenderer<T> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueObjectRenderer<T> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @ApiStatus.Internal
    public void render(@NotNull IRenderContext<T> pContext) {
        this.animatable = pContext.animatable();
        this.defaultRender(pContext);
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.objectRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
        pContext.poseStack().method_46416(0.5f, 0.51f, 0.5f);
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            class_4587 pPoseStack = full.poseStack();
            Object pAnimatable = full.animatable();
            class_4588 pBuffer = full.optionalBuffer();
            boolean pIsReRender = full.isReRender();
            float pPartialTick = full.partialTick();
            pPoseStack.method_22903();
            if (!pIsReRender) {
                AnimationState animationState = new AnimationState(pAnimatable, 0.0f, 0.0f, pPartialTick, false);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<BlueAnimatable> currentModel = this.getBlueModel();
                currentModel.addAdditionalStateData((BlueAnimatable)pAnimatable, instanceId, (BiConsumer<DataTicket<BlueAnimatable>, BlueAnimatable>)((BiConsumer<DataTicket, BlueAnimatable>)animationState::setData));
                currentModel.handleAnimations((BlueAnimatable)pAnimatable, instanceId, animationState, pPartialTick);
            }
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)pPoseStack.method_23760().method_23761());
            if (pBuffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
            pPoseStack.method_22909();
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.animatable = null;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.objectRenderTranslations));
        }
        BlueRenderer.super.renderRecursively(pBone, pContext);
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation(pContext.animatable()));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileObjectRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireObjectPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireObjectPostRender(this, pContext);
    }
}

