/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.armor;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_918;
import net.minecraft.class_9282;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.exception.nulls.EntityNullException;
import software.bluelib.api.exception.nulls.EquipmentSlotNullException;
import software.bluelib.api.exception.nulls.ItemStackNullException;
import software.bluelib.api.exception.nulls.ModelNullException;
import software.bluelib.api.utils.Color;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.item.BlueItem;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class BlueArmorRenderer<T extends class_1792, L extends class_1309>
extends class_572<L>
implements BlueRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @Nullable
    protected T animatable;
    @Nullable
    protected class_572<?> baseModel;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    @NotNull
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();
    @Nullable
    protected ModelCache lastModel = null;
    @Nullable
    protected BoneCache head = null;
    @Nullable
    protected BoneCache body = null;
    @Nullable
    protected BoneCache rightArm = null;
    @Nullable
    protected BoneCache leftArm = null;
    @Nullable
    protected BoneCache rightLeg = null;
    @Nullable
    protected BoneCache leftLeg = null;
    @Nullable
    protected BoneCache rightBoot = null;
    @Nullable
    protected BoneCache leftBoot = null;
    @Nullable
    protected class_1297 currentEntity = null;
    @Nullable
    protected class_1799 currentStack = null;
    @Nullable
    protected class_1304 currentSlot = null;
    @Nullable
    protected class_4597 bufferSource = null;
    protected float partialTick;
    protected float limbSwing;
    protected float limbSwingAmount;
    protected float netHeadYaw;
    protected float headPitch;

    public BlueArmorRenderer(@NotNull BlueModel<T> pModel) {
        super(class_310.method_1551().method_31974().method_32072(class_5602.field_27579));
        this.model = pModel;
        this.field_3448 = false;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @Nullable
    public T getOptionalAnimatable() {
        return this.animatable;
    }

    @Nullable
    public class_572<?> getOptionalBaseModel() {
        return this.baseModel;
    }

    @NotNull
    public class_572<?> getBaseModel() {
        class_572<?> baseModel = this.getOptionalBaseModel();
        if (baseModel == null) {
            throw new ModelNullException("baseModel cannot be null when rendering!");
        }
        return baseModel;
    }

    @Nullable
    public class_1297 getOptionalCurrentEntity() {
        return this.currentEntity;
    }

    @NotNull
    public class_1297 getCurrentEntity() {
        class_1297 currentEntity = this.getOptionalCurrentEntity();
        if (currentEntity == null) {
            throw new EntityNullException("currentEntity cannot be null when rendering!");
        }
        return currentEntity;
    }

    @Nullable
    public class_1799 getOptionalCurrentStack() {
        return this.currentStack;
    }

    @NotNull
    public class_1799 getCurrentStack() {
        class_1799 currentStack = this.getOptionalCurrentStack();
        if (currentStack == null) {
            throw new ItemStackNullException("currentStack cannot be null when rendering!");
        }
        return currentStack;
    }

    @Nullable
    public class_1304 getOptionalCurrentSlot() {
        return this.currentSlot;
    }

    @NotNull
    public class_1304 getCurrentSlot() {
        class_1304 currentSlot = this.getOptionalCurrentSlot();
        if (currentSlot == null) {
            throw new EquipmentSlotNullException("currentSlot cannot be null when rendering!");
        }
        return currentSlot;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        if (this.currentStack == null) {
            return (long)Math.pow(this.getCurrentEntity().method_5628(), 7.0) * (long)(-(this.getCurrentSlot().ordinal() + 1));
        }
        long stackId = BlueItem.getId(this.currentStack);
        if (stackId == Long.MAX_VALUE) {
            return (long)Math.pow(this.getCurrentEntity().method_5628(), 7.0) * (long)(-(this.getCurrentSlot().ordinal() + 1));
        }
        return -stackId;
    }

    @Override
    @NotNull
    public class_1921 getRenderType(@NotNull class_2960 pTexture, @NotNull IRenderContext<T> pContext) {
        return class_1921.method_25448((class_2960)pTexture);
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueArmorRenderer<T, L> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueArmorRenderer<T, L> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueArmorRenderer<T, L> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Nullable
    public BoneCache getBoneByName(@NotNull BlueModel<T> pModel, @NotNull String pBoneName) {
        return pModel.getBone(pBoneName).orElse(null);
    }

    @Nullable
    public BoneCache getHeadBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorHead");
    }

    @Nullable
    public BoneCache getBodyBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorBody");
    }

    @Nullable
    public BoneCache getRightArmBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorRightArm");
    }

    @Nullable
    public BoneCache getLeftArmBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorLeftArm");
    }

    @Nullable
    public BoneCache getRightLegBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorRightLeg");
    }

    @Nullable
    public BoneCache getLeftLegBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorLeftLeg");
    }

    @Nullable
    public BoneCache getRightBootBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorRightBoot");
    }

    @Nullable
    public BoneCache getLeftBootBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorLeftBoot");
    }

    @Override
    @NotNull
    public Color getRenderColor(@NotNull T pAnimatable, float pPartialTick, int pPackedLight) {
        return this.getCurrentStack().method_31573(class_3489.field_48803) ? Color.ofOpaque(class_9282.method_57470((class_1799)this.getCurrentStack(), (int)-6265536)) : Color.WHITE;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
        this.applyBaseModel(this.getBaseModel());
        this.grabRelevantBones(pContext.model());
        this.applyBaseTransformations(this.getBaseModel());
        this.scaleModelForBaby(pContext);
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
        if (!(this.getCurrentEntity() instanceof BlueAnimatable)) {
            this.applyBoneVisibilityBySlot(this.getCurrentSlot());
        }
    }

    @ApiStatus.Internal
    public void method_2828(@NotNull class_4587 pPoseStack, @Nullable class_4588 pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        class_310 mc = class_310.method_1551();
        class_4597.class_4598 pBufferSource = mc.field_1769.field_20951.method_23000();
        if (mc.field_1769.method_3270() && mc.method_27022(this.getCurrentEntity())) {
            pBufferSource = mc.field_1769.field_20951.method_23003();
        }
        float pPartialTick = mc.method_60646().method_60637(true);
        class_1921 pRenderType = this.getRenderType(this.getTextureLocation((BlueAnimatable)((class_1792)this.getAnimatable())), new BaseRenderContext<class_1792>(pPoseStack, (class_1792)this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource((class_1792)this.getAnimatable(), this)), (class_4597)pBufferSource, false, pPartialTick, pPackedLight, pPackedOverlay, pColor));
        pBuffer = class_918.method_27952((class_4597)pBufferSource, (class_1921)pRenderType, (boolean)this.getCurrentStack().method_7958());
        this.defaultRender(new FullRenderContext<class_1792>(pPoseStack, (class_1792)this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource((class_1792)this.getAnimatable(), this)), pRenderType, (class_4597)pBufferSource, pBuffer, false, pPartialTick, pPackedLight, this.getPackedOverlay((BlueAnimatable)((class_1792)this.getAnimatable()), 0.0f, pPartialTick), this.getRenderColor((class_1792)this.getAnimatable(), pPartialTick, pPackedLight).argbInt()));
        this.animatable = null;
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            class_4587 pPoseStack = full.poseStack();
            class_1792 pAnimatable = (class_1792)full.animatable();
            class_4588 pBuffer = full.optionalBuffer();
            boolean pIsReRender = full.isReRender();
            float pPartialTick = full.partialTick();
            pPoseStack.method_22903();
            pPoseStack.method_46416(0.0f, 1.5f, 0.0f);
            pPoseStack.method_22905(-1.0f, -1.0f, 1.0f);
            if (!pIsReRender) {
                AnimationState<class_1792> animationState = new AnimationState<class_1792>(pAnimatable, 0.0f, 0.0f, pPartialTick, false);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<class_1792> currentModel = this.getBlueModel();
                animationState.setData(DataTickets.TICK, ((BlueItem)pAnimatable).getTick(this.getCurrentEntity()));
                animationState.setData(DataTickets.ITEMSTACK, this.currentStack);
                animationState.setData(DataTickets.ENTITY, this.getCurrentEntity());
                animationState.setData(DataTickets.EQUIPMENT_SLOT, this.currentSlot);
                currentModel.addAdditionalStateData(pAnimatable, instanceId, (x$0, x$1) -> animationState.setData(x$0, x$1));
                currentModel.handleAnimations(pAnimatable, instanceId, animationState, pPartialTick);
            }
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)pPoseStack.method_23760().method_23761());
            if (pBuffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
            pPoseStack.method_22909();
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.baseModel = null;
        this.currentEntity = null;
        this.currentStack = null;
        this.animatable = null;
        this.currentSlot = null;
        this.bufferSource = null;
        this.partialTick = 0.0f;
        this.limbSwing = 0.0f;
        this.limbSwingAmount = 0.0f;
        this.netHeadYaw = 0.0f;
        this.headPitch = 0.0f;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations));
        }
        BlueRenderer.super.renderRecursively(pBone, pContext);
    }

    protected void grabRelevantBones(@NotNull ModelCache pBakedModel) {
        if (this.lastModel == pBakedModel) {
            return;
        }
        BlueModel<T> pModel = this.getBlueModel();
        this.lastModel = pBakedModel;
        this.head = this.getHeadBone(pModel);
        this.body = this.getBodyBone(pModel);
        this.rightArm = this.getRightArmBone(pModel);
        this.leftArm = this.getLeftArmBone(pModel);
        this.rightLeg = this.getRightLegBone(pModel);
        this.leftLeg = this.getLeftLegBone(pModel);
        this.rightBoot = this.getRightBootBone(pModel);
        this.leftBoot = this.getLeftBootBone(pModel);
    }

    protected void applyBaseModel(@NotNull class_572<?> pBaseModel) {
        BlueArmorRenderer self = this;
        self.field_3448 = pBaseModel.field_3448;
        self.field_3400 = pBaseModel.field_3400;
        self.field_3449 = pBaseModel.field_3449;
        self.field_3395 = pBaseModel.field_3395;
        self.field_3399 = pBaseModel.field_3399;
        this.copyVisibility(self, pBaseModel);
    }

    protected void copyVisibility(@NotNull class_572<?> pTarget, @NotNull class_572<?> pSource) {
        pTarget.field_3398.field_3665 = pSource.field_3398.field_3665;
        pTarget.field_3394.field_3665 = pSource.field_3394.field_3665;
        pTarget.field_3391.field_3665 = pSource.field_3391.field_3665;
        pTarget.field_3401.field_3665 = pSource.field_3401.field_3665;
        pTarget.field_27433.field_3665 = pSource.field_27433.field_3665;
        pTarget.field_3392.field_3665 = pSource.field_3392.field_3665;
        pTarget.field_3397.field_3665 = pSource.field_3397.field_3665;
    }

    protected void applyBoneVisibilityBySlot(@NotNull class_1304 pCurrentSlot) {
        record BoneVisibility(@Nullable BoneCache bone, boolean visible) {
        }
        BoneVisibility[] visibilities;
        BoneVisibility[] boneVisibilityArray;
        this.setAllBonesVisible(false);
        BlueArmorRenderer pModel = this;
        switch (pCurrentSlot) {
            case field_6169: {
                BoneVisibility[] boneVisibilityArray2 = new BoneVisibility[1];
                boneVisibilityArray = boneVisibilityArray2;
                boneVisibilityArray2[0] = new BoneVisibility(this.head, pModel.field_3398.field_3665);
                break;
            }
            case field_6174: {
                BoneVisibility[] boneVisibilityArray3 = new BoneVisibility[3];
                boneVisibilityArray3[0] = new BoneVisibility(this.body, pModel.field_3391.field_3665);
                boneVisibilityArray3[1] = new BoneVisibility(this.rightArm, pModel.field_3401.field_3665);
                boneVisibilityArray = boneVisibilityArray3;
                boneVisibilityArray3[2] = new BoneVisibility(this.leftArm, pModel.field_27433.field_3665);
                break;
            }
            case field_6172: {
                BoneVisibility[] boneVisibilityArray4 = new BoneVisibility[2];
                boneVisibilityArray4[0] = new BoneVisibility(this.rightLeg, pModel.field_3392.field_3665);
                boneVisibilityArray = boneVisibilityArray4;
                boneVisibilityArray4[1] = new BoneVisibility(this.leftLeg, pModel.field_3397.field_3665);
                break;
            }
            case field_6166: {
                BoneVisibility[] boneVisibilityArray5 = new BoneVisibility[2];
                boneVisibilityArray5[0] = new BoneVisibility(this.rightBoot, pModel.field_3392.field_3665);
                boneVisibilityArray = boneVisibilityArray5;
                boneVisibilityArray5[1] = new BoneVisibility(this.leftBoot, pModel.field_3397.field_3665);
                break;
            }
            default: {
                boneVisibilityArray = new BoneVisibility[]{};
            }
        }
        for (BoneVisibility visibility : visibilities = boneVisibilityArray) {
            this.setBoneVisible(visibility.bone(), visibility.visible());
        }
    }

    public void applyBoneVisibilityByPart(@NotNull class_1304 pCurrentSlot, @NotNull class_630 pCurrentPart, @NotNull class_572<?> pModel) {
        this.method_2805(false);
        pCurrentPart.field_3665 = true;
        BoneCache bone = null;
        if (pCurrentPart == pModel.field_3394 || pCurrentPart == pModel.field_3398) {
            bone = this.head;
        } else if (pCurrentPart == pModel.field_3391) {
            bone = this.body;
        } else if (pCurrentPart == pModel.field_27433) {
            bone = this.leftArm;
        } else if (pCurrentPart == pModel.field_3401) {
            bone = this.rightArm;
        } else if (pCurrentPart == pModel.field_3397) {
            bone = pCurrentSlot == class_1304.field_6166 ? this.leftBoot : this.leftLeg;
        } else if (pCurrentPart == pModel.field_3392) {
            BoneCache boneCache = bone = pCurrentSlot == class_1304.field_6166 ? this.rightBoot : this.rightLeg;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    protected void applyBaseTransformations(@NotNull class_572<?> pBaseModel) {
        record TransformData(@Nullable BoneCache bone, class_630 part, float xOffset, float yOffset, float zOffset) {
        }
        TransformData[] transforms;
        for (TransformData t : transforms = new TransformData[]{new TransformData(this.head, pBaseModel.field_3398, 0.0f, 0.0f, 0.0f), new TransformData(this.body, pBaseModel.field_3391, 0.0f, 0.0f, 0.0f), new TransformData(this.rightArm, pBaseModel.field_3401, 5.0f, 2.0f, 0.0f), new TransformData(this.leftArm, pBaseModel.field_27433, -5.0f, 2.0f, 0.0f), new TransformData(this.rightLeg, pBaseModel.field_3392, 2.0f, 12.0f, 0.0f), new TransformData(this.leftLeg, pBaseModel.field_3397, -2.0f, 12.0f, 0.0f)}) {
            if (t.bone() == null) continue;
            RenderUtils.matchModelPartRot(t.part(), t.bone());
            t.bone().updatePosition(t.part().field_3657 + t.xOffset, t.yOffset - t.part().field_3656, t.part().field_3655 + t.zOffset);
        }
        if (this.rightBoot != null && this.rightLeg != null) {
            class_630 rightLegPart = pBaseModel.field_3392;
            RenderUtils.matchModelPartRot(rightLegPart, this.rightBoot);
            this.rightBoot.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655);
        }
        if (this.leftBoot != null && this.leftLeg != null) {
            class_630 leftLegPart = pBaseModel.field_3397;
            RenderUtils.matchModelPartRot(leftLegPart, this.leftBoot);
            this.leftBoot.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655);
        }
    }

    public void method_2805(boolean pVisible) {
        super.method_2805(pVisible);
        this.setAllBonesVisible(pVisible);
    }

    protected void setAllBonesVisible(boolean pVisible) {
        this.setBoneVisible(this.head, pVisible);
        this.setBoneVisible(this.body, pVisible);
        this.setBoneVisible(this.rightArm, pVisible);
        this.setBoneVisible(this.leftArm, pVisible);
        this.setBoneVisible(this.rightLeg, pVisible);
        this.setBoneVisible(this.leftLeg, pVisible);
        this.setBoneVisible(this.rightBoot, pVisible);
        this.setBoneVisible(this.leftBoot, pVisible);
    }

    public void scaleModelForBaby(@NotNull IRenderContext<T> pContext) {
        if (!this.field_3448 || pContext.isReRender()) {
            return;
        }
        if (this.currentSlot == class_1304.field_6169) {
            if (this.getBaseModel().field_20915) {
                float headScale = 1.5f / this.getBaseModel().field_20918;
                pContext.poseStack().method_22905(headScale, headScale, headScale);
            }
            pContext.poseStack().method_46416(0.0f, this.getBaseModel().field_20916 / 16.0f, this.getBaseModel().field_20917 / 16.0f);
        } else {
            float bodyScale = 1.0f / this.getBaseModel().field_20919;
            pContext.poseStack().method_22905(bodyScale, bodyScale, bodyScale);
            pContext.poseStack().method_46416(0.0f, this.getBaseModel().field_20920 / 16.0f, 0.0f);
        }
    }

    protected void setBoneVisible(@Nullable BoneCache pBone, boolean pVisible) {
        if (pBone == null) {
            return;
        }
        pBone.setHidden(!pVisible);
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        if (this.getOptionalCurrentEntity() != null) {
            AnimatableTexture.setAndUpdate(this.getTextureLocation((BlueAnimatable)((class_1792)pContext.animatable())));
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileArmorRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireArmorPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireArmorPostRender(this, pContext);
    }
}

