/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.armor;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_5253;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.Color;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.armor.BlueArmorRenderer;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public abstract class DyeableBlueArmorRenderer<T extends class_1792, L extends class_1309>
extends BlueArmorRenderer<T, L> {
    @NotNull
    protected final Set<BoneCache> dyeableBones = new ObjectArraySet();
    @Nullable
    protected ModelCache lastModel = null;

    public DyeableBlueArmorRenderer(@NotNull BlueModel<T> pModel) {
        super(pModel);
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        super.preRender(pContext);
        if (!pContext.isReRender()) {
            this.checkBoneDyeCache(pContext);
        }
    }

    @Override
    public void renderCubesOfBone(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (this.dyeableBones.contains(pBone)) {
            Color color = this.getColorForBone(pBone);
            pContext.setColor(class_5253.class_5254.method_27763((int)pContext.color(), (int)color.argbInt()));
        }
        super.renderCubesOfBone(pBone, pContext);
    }

    protected abstract boolean isBoneDyeable(@NotNull BoneCache var1);

    @NotNull
    protected abstract Color getColorForBone(@NotNull BoneCache var1);

    protected void checkBoneDyeCache(@NotNull IRenderContext<T> pContext) {
        if (pContext.model() != this.lastModel) {
            this.dyeableBones.clear();
            this.lastModel = pContext.model();
            this.collectDyeableBones(pContext.model().topLevelBones());
        }
    }

    protected void collectDyeableBones(@NotNull Collection<BoneCache> pBones) {
        for (BoneCache bone : pBones) {
            if (this.isBoneDyeable(bone)) {
                this.dyeableBones.add(bone);
            }
            this.collectDyeableBones(bone.getChildBones());
        }
    }
}

