/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.block;

import java.util.List;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class BlueBlockRenderer<T extends class_2586>
implements BlueRenderer<T>,
class_827<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @Nullable
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    @NotNull
    protected Matrix4f blockRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public BlueBlockRenderer(@NotNull BlueModel<T> pModel) {
        this.model = pModel;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @Nullable
    public T getOptionalAnimatable() {
        return this.animatable;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        return ((class_2586)pContext.animatable()).method_11016().hashCode();
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueBlockRenderer<T> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueBlockRenderer<T> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueBlockRenderer<T> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.blockRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
        if (!pContext.isReRender()) {
            pContext.poseStack().method_22904(0.5, 0.0, 0.5);
        }
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
    }

    @ApiStatus.Internal
    public void method_3569(@NotNull T pAnimatable, float pPartialTick, @NotNull class_4587 pPoseStack, @NotNull class_4597 pBufferSource, int pPackedLight, int pPackedOverlay) {
        this.animatable = pAnimatable;
        this.defaultRender(new BaseRenderContext<class_2586>(pPoseStack, (class_2586)this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource(pAnimatable, this)), pBufferSource, false, pPartialTick, pPackedLight, this.getPackedOverlay((class_2586)this.getAnimatable(), 0.0f, pPartialTick), this.getRenderColor((class_2586)this.getAnimatable(), pPartialTick, pPackedLight).argbInt()));
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            class_4587 pPoseStack = full.poseStack();
            class_2586 animatable = (class_2586)full.animatable();
            class_4588 buffer = full.optionalBuffer();
            boolean pIsReRender = full.isReRender();
            float pPartialTick = full.partialTick();
            if (!pIsReRender) {
                AnimationState<class_2586> animationState = new AnimationState<class_2586>(animatable, 0.0f, 0.0f, pPartialTick, false);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<class_2586> currentModel = this.getBlueModel();
                animationState.setData(DataTickets.TICK, ((BlueAnimatable)animatable).getTick(animatable));
                animationState.setData(DataTickets.BLOCK_ENTITY, animatable);
                currentModel.addAdditionalStateData(animatable, instanceId, (x$0, x$1) -> animationState.setData(x$0, x$1));
                this.rotateBlock(this.getFacing(animatable), pPoseStack);
                currentModel.handleAnimations(animatable, instanceId, animationState, pPartialTick);
            }
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)pPoseStack.method_23760().method_23761());
            if (buffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.animatable = null;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.blockRenderTranslations);
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            class_2338 pos = ((class_2586)this.getAnimatable()).method_11016();
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(localMatrix);
            pBone.setWorldSpaceMatrix(worldState.translate((Vector3fc)new Vector3f((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260())));
        }
        BlueRenderer.super.renderRecursively(pBone, pContext);
    }

    protected void rotateBlock(@NotNull class_2350 pFacing, @NotNull class_4587 pPoseStack) {
        switch (pFacing) {
            case field_11035: {
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11043: {
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(0.0f));
                break;
            }
            case field_11034: {
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                break;
            }
            case field_11036: {
                pPoseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11033: {
                pPoseStack.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
            }
        }
    }

    @NotNull
    protected class_2350 getFacing(@NotNull T pBlock) {
        class_2680 blockState = pBlock.method_11010();
        if (blockState.method_28498((class_2769)class_2383.field_11177)) {
            return (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        }
        if (blockState.method_28498((class_2769)class_2318.field_10927)) {
            return (class_2350)blockState.method_11654((class_2769)class_2318.field_10927);
        }
        return class_2350.field_11043;
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((class_2586)pContext.animatable()));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileBlockRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireBlockPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireBlockPostRender(this, pContext);
    }
}

