/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.block;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bluelib.api.utils.loader.BufferUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.json.object.QuadData;
import software.bluelib.loader.json.object.VertexData;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.block.BlueBlockRenderer;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public abstract class DynamicBlueBlockRenderer<T extends class_2586>
extends BlueBlockRenderer<T> {
    @NotNull
    protected static Map<class_2960, IntIntPair> TEXTURE_DIMENSIONS_CACHE = new Object2ObjectOpenHashMap();
    @Nullable
    protected class_2960 textureOverride = null;

    public DynamicBlueBlockRenderer(@NotNull BlueModel<T> pModel) {
        super(pModel);
    }

    @Nullable
    protected class_2960 getTextureOverrideForBone(@NotNull BoneCache pBone, @NotNull IRenderContext<T> pContext) {
        return null;
    }

    @Nullable
    protected class_1921 getRenderTypeOverrideForBone(@NotNull BoneCache pBone, @NotNull class_2960 pTexturePath, @NotNull IRenderContext<T> pContext) {
        return null;
    }

    protected boolean boneRenderOverride(@NotNull BoneCache pBone, @NotNull IRenderContext<T> pContext) {
        return false;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        pContext.poseStack().method_22903();
        RenderUtils.translateMatrixToBone(pContext.poseStack(), pBone);
        RenderUtils.translateToPivotPoint(pContext.poseStack(), pBone);
        RenderUtils.rotateMatrixAroundBone(pContext.poseStack(), pBone);
        RenderUtils.scaleMatrixForBone(pContext.poseStack(), pBone);
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.blockRenderTranslations);
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            class_2338 pos = ((class_2586)this.getAnimatable()).method_11016();
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(localMatrix);
            pBone.setWorldSpaceMatrix(worldState.translate((Vector3fc)new Vector3f((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260())));
        }
        RenderUtils.translateAwayFromPivotPoint(pContext.poseStack(), pBone);
        this.textureOverride = this.getTextureOverrideForBone(pBone, pContext);
        class_2960 texture = this.textureOverride == null ? this.getTextureLocation((class_2586)this.getAnimatable()) : this.textureOverride;
        class_1921 renderTypeOverride = this.getRenderTypeOverrideForBone(pBone, texture, pContext);
        if (renderTypeOverride == null) {
            renderTypeOverride = this.getRenderType(texture, pContext);
        }
        if (renderTypeOverride != null) {
            pContext.setBuffer(pContext.bufferSource().getBuffer(renderTypeOverride));
        }
        if (!this.boneRenderOverride(pBone, pContext)) {
            super.renderCubesOfBone(pBone, pContext);
        }
        if (renderTypeOverride != null) {
            pContext.setBuffer(pContext.bufferSource().getBuffer(pContext.renderType()));
        }
        if (!pContext.isReRender()) {
            this.applyRenderLayersForBone(pBone, pContext);
        }
        pContext.setBuffer(BufferUtils.checkAndRefreshBuffer(pContext.isReRender(), pContext.buffer(), pContext.bufferSource(), pContext.renderType()));
        super.renderChildBones(pBone, pContext);
        pContext.poseStack().method_22909();
    }

    @Override
    public void postRender(@NotNull IRenderContext<T> pContext) {
        this.textureOverride = null;
        super.postRender(pContext);
    }

    @Override
    public void createVerticesOfQuad(@NotNull QuadData pQuad, @NotNull Matrix4f pPoseState, @NotNull Vector3f pNormal, @NotNull FullRenderContext<T> pContext) {
        if (this.textureOverride == null) {
            super.createVerticesOfQuad(pQuad, pPoseState, pNormal, pContext);
            return;
        }
        IntIntPair boneTextureSize = this.computeTextureSize(this.textureOverride);
        IntIntPair blockTextureSize = this.computeTextureSize(this.getTextureLocation((class_2586)this.getAnimatable()));
        if (boneTextureSize == null || blockTextureSize == null) {
            super.createVerticesOfQuad(pQuad, pPoseState, pNormal, pContext);
            return;
        }
        for (VertexData vertex : pQuad.vertices()) {
            Vector4f vector4f = pPoseState.transform(new Vector4f(vertex.position().x(), vertex.position().y(), vertex.position().z(), 1.0f));
            float texU = vertex.texU().floatValue() * (float)blockTextureSize.firstInt() / (float)boneTextureSize.firstInt();
            float texV = vertex.texV().floatValue() * (float)blockTextureSize.secondInt() / (float)boneTextureSize.secondInt();
            pContext.buffer().method_23919(vector4f.x(), vector4f.y(), vector4f.z(), pContext.color(), texU, texV, pContext.packedOverlay(), pContext.packedLight(), pNormal.x(), pNormal.y(), pNormal.z());
        }
    }

    @Nullable
    protected IntIntPair computeTextureSize(@NotNull class_2960 pTexture) {
        return TEXTURE_DIMENSIONS_CACHE.computeIfAbsent(pTexture, RenderUtils::getTextureDimensions);
    }
}

