/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.entity;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.utils.Color;
import software.bluelib.api.utils.loader.BufferUtils;
import software.bluelib.client.utils.PlayerUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.geckolib.data.EntityModelData;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;
import software.bluelib.loader.renderer.entity.EntityRenderUtils;

public class BlueEntityRenderer<T extends class_1297>
extends class_897<T>
implements BlueRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @Nullable
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    @NotNull
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public BlueEntityRenderer(@NotNull class_5617.class_5618 pRenderManager, @NotNull BlueModel<T> pModel) {
        super(pRenderManager);
        this.model = pModel;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @Nullable
    public T getOptionalAnimatable() {
        return this.animatable;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        return ((class_1297)pContext.animatable()).method_5628();
    }

    @NotNull
    public class_2960 method_3931(@NotNull T pAnimatable) {
        return BlueRenderer.super.getTextureLocation(pAnimatable);
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueEntityRenderer<T> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueEntityRenderer<T> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueEntityRenderer<T> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Override
    @NotNull
    public Color getRenderColor(@NotNull T pAnimatable, float pPartialTick, int pPackedLight) {
        Color color = BlueRenderer.super.getRenderColor(pAnimatable, pPartialTick, pPackedLight);
        if (pAnimatable.method_5767() && !pAnimatable.method_5756(PlayerUtils.getClientPlayer())) {
            color = Color.ofARGB(class_3532.method_15386((float)((float)(color.getAlpha() * 38) / 255.0f)), color.getRed(), color.getGreen(), color.getBlue());
        }
        return color;
    }

    @Override
    @Nullable
    public class_1921 getRenderType(@NotNull class_2960 pTexture, @NotNull IRenderContext<T> pContext) {
        boolean invisible = ((class_1297)pContext.animatable()).method_5767();
        if (invisible && !((class_1297)pContext.animatable()).method_5756(PlayerUtils.getClientPlayer())) {
            return class_1921.method_29379((class_2960)pTexture);
        }
        if (!invisible) {
            return BlueRenderer.super.getRenderType(pTexture, pContext);
        }
        return class_310.method_1551().method_27022((class_1297)pContext.animatable()) ? class_1921.method_23287((class_2960)pTexture) : null;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
    }

    @ApiStatus.Internal
    public void method_3936(@NotNull T pEntity, float pEntityYaw, float pPartialTick, @NotNull class_4587 pPoseStack, @NotNull class_4597 pBufferSource, int pPackedLight) {
        this.animatable = pEntity;
        this.defaultRender(new BaseRenderContext<T>(pPoseStack, pEntity, this.model.getBakedModel(this.getBlueModel().getModelResource(this.animatable, this)), pBufferSource, false, pPartialTick, pPackedLight, this.getPackedOverlay(pEntity, 0.0f, pPartialTick), this.getRenderColor(pEntity, pPartialTick, pPackedLight).argbInt()));
        this.animatable = null;
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            float[] fArray;
            class_1309 e;
            FullRenderContext full = (FullRenderContext)pContext;
            class_4587 poseStack = full.poseStack();
            class_1297 animatable = (class_1297)full.animatable();
            class_4588 buffer = full.optionalBuffer();
            boolean isReRender = full.isReRender();
            float partialTick = full.partialTick();
            poseStack.method_22903();
            class_1309 livingEntity = animatable instanceof class_1309 ? (e = (class_1309)animatable) : null;
            boolean shouldSit = animatable.method_5765() && animatable.method_5854() != null;
            float lerpBodyRot = EntityRenderUtils.getLerpBodyRot(livingEntity, partialTick);
            float lerpHeadRot = EntityRenderUtils.getLerpHeadRot(livingEntity, partialTick);
            float[] adjusted = EntityRenderUtils.adjustSittingRotations(shouldSit, animatable, lerpHeadRot, lerpBodyRot, partialTick);
            lerpBodyRot = adjusted[0];
            float netHeadYaw = adjusted[1];
            if (livingEntity != null) {
                EntityRenderUtils.applySleepingTranslation(poseStack, livingEntity);
            }
            float nativeScale = livingEntity != null ? livingEntity.method_55693() : 1.0f;
            float ageInTicks = (float)animatable.field_6012 + partialTick;
            poseStack.method_22905(nativeScale, nativeScale, nativeScale);
            this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
            if (livingEntity != null) {
                fArray = EntityRenderUtils.computeLimbSwing(livingEntity, shouldSit, partialTick);
            } else {
                float[] fArray2 = new float[2];
                fArray2[0] = 0.0f;
                fArray = fArray2;
                fArray2[1] = 0.0f;
            }
            float[] limbSwingData = fArray;
            float limbSwing = limbSwingData[0];
            float limbSwingAmount = limbSwingData[1];
            if (!isReRender) {
                float headPitch = class_3532.method_16439((float)partialTick, (float)animatable.field_6004, (float)animatable.method_36455());
                float motionThreshold = this.getMotionAnimThreshold(pContext);
                boolean moving = livingEntity != null ? EntityRenderUtils.isEntityMoving(livingEntity, motionThreshold, limbSwingAmount) : Math.abs(limbSwingAmount) >= motionThreshold;
                AnimationState<class_1297> state = new AnimationState<class_1297>(animatable, limbSwing, limbSwingAmount, partialTick, moving);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<class_1297> model = this.getBlueModel();
                state.setData(DataTickets.TICK, ((BlueAnimatable)animatable).getTick(animatable));
                state.setData(DataTickets.ENTITY, animatable);
                state.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.method_6109(), -netHeadYaw, -headPitch));
                model.addAdditionalStateData(animatable, instanceId, (x$0, x$1) -> state.setData(x$0, x$1));
                model.handleAnimations(animatable, instanceId, state, partialTick);
            }
            poseStack.method_46416(0.0f, 0.01f, 0.0f);
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            if (buffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
            poseStack.method_22909();
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void applyRenderLayers(@NotNull IRenderContext<T> pContext) {
        if (!((class_1297)pContext.animatable()).method_7325()) {
            BlueRenderer.super.applyRenderLayers(pContext);
        }
    }

    @Override
    public void renderFinal(@NotNull IRenderContext<T> pContext) {
        class_1308 mob;
        class_1297 leashHolder;
        super.method_3936((class_1297)pContext.animatable(), 0.0f, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), pContext.packedLight());
        T t = this.animatable;
        if (t instanceof class_1308 && (leashHolder = (mob = (class_1308)t).method_60952()) != null) {
            this.renderLeash(mob, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), leashHolder);
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.animatable = null;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        pContext.poseStack().method_22903();
        RenderUtils.translateMatrixToBone(pContext.poseStack(), pBone);
        RenderUtils.translateToPivotPoint(pContext.poseStack(), pBone);
        RenderUtils.rotateMatrixAroundBone(pContext.poseStack(), pBone);
        RenderUtils.scaleMatrixForBone(pContext.poseStack(), pBone);
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.method_23169((class_1297)this.getAnimatable(), 1.0f).method_46409()));
            pBone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), ((class_1297)this.getAnimatable()).method_19538().method_46409()));
        }
        RenderUtils.translateAwayFromPivotPoint(pContext.poseStack(), pBone);
        pContext.setBuffer(BufferUtils.checkAndRefreshBuffer(pContext.isReRender(), pContext.buffer(), pContext.bufferSource(), pContext.renderType()));
        this.renderCubesOfBone(pBone, pContext);
        if (!pContext.isReRender()) {
            this.applyRenderLayersForBone(pBone, pContext);
        }
        this.renderChildBones(pBone, pContext);
        pContext.poseStack().method_22909();
    }

    protected void applyRotations(@NotNull T pAnimatable, @NotNull class_4587 pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTick, float pNativeScale) {
        if (this.isShaking(pAnimatable)) {
            pRotationYaw += (float)(Math.cos((double)((class_1297)pAnimatable).field_6012 * 3.25) * Math.PI * 0.4);
        }
        if (!pAnimatable.method_41328(class_4050.field_18078)) {
            pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - pRotationYaw));
        }
        if (pAnimatable instanceof class_1309) {
            class_1309 livingEntity = (class_1309)pAnimatable;
            if (livingEntity.field_6213 > 0) {
                float deathRotation = ((float)livingEntity.field_6213 + pPartialTick - 1.0f) / 20.0f * 1.6f;
                pPoseStack.method_22907(class_7833.field_40718.rotationDegrees(Math.min(class_3532.method_15355((float)deathRotation), 1.0f) * this.getDeathMaxRotation(pAnimatable)));
            } else if (livingEntity.method_6123()) {
                pPoseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f - livingEntity.method_36455()));
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(((float)livingEntity.field_6012 + pPartialTick) * -75.0f));
            } else if (pAnimatable.method_41328(class_4050.field_18078)) {
                class_2350 bedOrientation = livingEntity.method_18401();
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation).floatValue() : pRotationYaw));
                pPoseStack.method_22907(class_7833.field_40718.rotationDegrees(this.getDeathMaxRotation(pAnimatable)));
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
            } else if (class_922.method_38563((class_1309)livingEntity)) {
                pPoseStack.method_46416(0.0f, (pAnimatable.method_17682() + 0.1f) / pNativeScale, 0.0f);
                pPoseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(@NotNull T pAnimatable) {
        return 90.0f;
    }

    public double getNameRenderCutoffDistance(@NotNull T pAnimatable) {
        return pAnimatable.method_21751() ? 32.0 : 64.0;
    }

    public boolean method_3921(@NotNull T pAnimatable) {
        if (!(pAnimatable instanceof class_1309)) {
            return super.method_3921(pAnimatable);
        }
        double nameRenderCutoff = this.getNameRenderCutoffDistance(pAnimatable);
        if (this.field_4676.method_23168(pAnimatable) >= nameRenderCutoff * nameRenderCutoff) {
            return false;
        }
        if (!(!(pAnimatable instanceof class_1308) || pAnimatable.method_5733() || pAnimatable.method_16914() && pAnimatable == this.field_4676.field_4678)) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        boolean visibleToClient = !pAnimatable.method_5756(PlayerUtils.getClientPlayer());
        class_268 entityTeam = pAnimatable.method_5781();
        if (entityTeam == null) {
            return class_310.method_1498() && pAnimatable != minecraft.method_1560() && visibleToClient && !pAnimatable.method_5782();
        }
        class_268 playerTeam = PlayerUtils.getClientPlayer().method_5781();
        return switch (entityTeam.method_1201()) {
            default -> throw new MatchException(null, null);
            case class_270.class_272.field_1442 -> visibleToClient;
            case class_270.class_272.field_1443 -> false;
            case class_270.class_272.field_1444 -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.method_1206((class_270)playerTeam) && (entityTeam.method_1199() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case class_270.class_272.field_1446 -> playerTeam == null ? visibleToClient : !entityTeam.method_1206((class_270)playerTeam) && visibleToClient;
        };
    }

    @Override
    public int getPackedOverlay(@NotNull T pAnimatable, float pU, float pPartialTick) {
        if (!(pAnimatable instanceof class_1309)) {
            return class_4608.field_21444;
        }
        class_1309 entity = (class_1309)pAnimatable;
        return class_4608.method_23625((int)class_4608.method_23210((float)pU), (int)class_4608.method_23212((entity.field_6235 > 0 || entity.field_6213 > 0 ? 1 : 0) != 0));
    }

    public boolean isShaking(@NotNull T animatable) {
        return animatable.method_32314();
    }

    public <E extends class_1297, M extends class_1308> void renderLeash(@NotNull M pMob, float pPartialTick, @NotNull class_4587 pPoseStack, @NotNull class_4597 pBufferSource, @NotNull E pLeashHolder) {
        float t;
        int i;
        float bodyAngle = class_3532.method_16439((float)pPartialTick, (float)pMob.field_6220, (float)pMob.field_6283) * ((float)Math.PI / 180) + 1.5707964f;
        class_243 leashOffset = pMob.method_45321(pPartialTick);
        float cos = (float)Math.cos(bodyAngle);
        float sin = (float)Math.sin(bodyAngle);
        double xAngleOffset = (double)cos * leashOffset.field_1350 + (double)sin * leashOffset.field_1352;
        double zAngleOffset = (double)sin * leashOffset.field_1350 - (double)cos * leashOffset.field_1352;
        double lerpOriginX = class_3532.method_16436((double)pPartialTick, (double)pMob.field_6014, (double)pMob.method_23317()) + xAngleOffset;
        double lerpOriginY = class_3532.method_16436((double)pPartialTick, (double)pMob.field_6036, (double)pMob.method_23318()) + leashOffset.field_1351;
        double lerpOriginZ = class_3532.method_16436((double)pPartialTick, (double)pMob.field_5969, (double)pMob.method_23321()) + zAngleOffset;
        class_243 ropePos = pLeashHolder.method_30951(pPartialTick);
        float xDif = (float)(ropePos.field_1352 - lerpOriginX);
        float yDif = (float)(ropePos.field_1351 - lerpOriginY);
        float zDif = (float)(ropePos.field_1350 - lerpOriginZ);
        float offsetMod = class_3532.method_48119((float)(xDif * xDif + zDif * zDif)) * 0.0125f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        class_4588 vc = pBufferSource.getBuffer(class_1921.method_23587());
        class_2338 mobEye = class_2338.method_49638((class_2374)pMob.method_5836(pPartialTick));
        class_2338 holderEye = class_2338.method_49638((class_2374)pLeashHolder.method_5836(pPartialTick));
        int mobBlockLight = this.method_24087((class_1297)pMob, mobEye);
        int holderBlockLight = pLeashHolder.method_5809() ? 15 : pLeashHolder.method_37908().method_8314(class_1944.field_9282, holderEye);
        int mobSkyLight = pMob.method_37908().method_8314(class_1944.field_9284, mobEye);
        int holderSkyLight = pMob.method_37908().method_8314(class_1944.field_9284, holderEye);
        pPoseStack.method_22903();
        pPoseStack.method_22904(xAngleOffset, leashOffset.field_1351, zAngleOffset);
        Matrix4f matrix = pPoseStack.method_23760().method_23761();
        for (i = 0; i <= 24; ++i) {
            t = (float)i / 24.0f;
            BlueEntityRenderer.addLeashVertices(vc, matrix, xDif, yDif, zDif, mobBlockLight, holderBlockLight, mobSkyLight, holderSkyLight, xOffset, zOffset, t, false);
        }
        for (i = 24; i >= 0; --i) {
            t = (float)i / 24.0f;
            BlueEntityRenderer.addLeashVertices(vc, matrix, xDif, yDif, zDif, mobBlockLight, holderBlockLight, mobSkyLight, holderSkyLight, xOffset, zOffset, t, true);
        }
        pPoseStack.method_22909();
    }

    private static void addLeashVertices(@NotNull class_4588 pBuffer, @NotNull Matrix4f pMatrix4f, float pXDif, float pYDif, float pZDif, int pMobBlockLight, int pHolderBlockLight, int pMobSkyLight, int pHolderSkyLight, float pXOffset, float pZOffset, float pSegment, boolean pIsKnot) {
        int packedLight = class_765.method_23687((int)((int)class_3532.method_16439((float)pSegment, (float)pMobBlockLight, (float)pHolderBlockLight)), (int)((int)class_3532.method_16439((float)pSegment, (float)pMobSkyLight, (float)pHolderSkyLight)));
        float colourMod = Math.round(pSegment * 24.0f) % 2 == (pIsKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * colourMod;
        float green = 0.4f * colourMod;
        float blue = 0.3f * colourMod;
        float x = pXDif * pSegment;
        float y = pYDif > 0.0f ? pYDif * pSegment * pSegment : pYDif - pYDif * (1.0f - pSegment) * (1.0f - pSegment);
        float z = pZDif * pSegment;
        float width = pIsKnot ? 0.0f : 0.025f;
        pBuffer.method_22918(pMatrix4f, x - pXOffset, y + width, z + pZOffset).method_22915(red, green, blue, 1.0f).method_60803(packedLight);
        pBuffer.method_22918(pMatrix4f, x + pXOffset, y + 0.025f - width, z - pZOffset).method_22915(red, green, blue, 1.0f).method_60803(packedLight);
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        AnimatableTexture.setAndUpdate(this.method_3931((class_1297)pContext.animatable()));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileEntityRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireEntityPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireEntityPostRender(this, pContext);
    }
}

