/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.entity;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.exception.nulls.EntityNullException;
import software.bluelib.api.utils.loader.BufferUtils;
import software.bluelib.client.utils.PlayerUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.geckolib.constant.dataticket.DataTicket;
import software.bluelib.loader.geckolib.data.EntityModelData;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;
import software.bluelib.loader.renderer.entity.EntityRenderUtils;

public class BlueReplacedEntityRenderer<E extends class_1297, T extends BlueAnimatable>
extends class_897<E>
implements BlueRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @NotNull
    protected final T animatable;
    @Nullable
    protected E currentEntity;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    @NotNull
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public BlueReplacedEntityRenderer(@NotNull class_5617.class_5618 pRenderManager, @NotNull BlueModel<T> pModel, @NotNull T pAnimatable) {
        super(pRenderManager);
        this.model = pModel;
        this.animatable = pAnimatable;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @NotNull
    public T getOptionalAnimatable() {
        return this.getAnimatable();
    }

    @Override
    @NotNull
    public T getAnimatable() {
        return this.animatable;
    }

    @Nullable
    public E getOptionalCurrentEntity() {
        return this.currentEntity;
    }

    @NotNull
    public E getCurrentEntity() {
        E currentEntity = this.getOptionalCurrentEntity();
        if (currentEntity == null) {
            throw new EntityNullException("currentEntity cannot be null when rendering!");
        }
        return currentEntity;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        return this.getCurrentEntity().method_5628();
    }

    @NotNull
    public class_2960 method_3931(@NotNull E pEntity) {
        return BlueRenderer.super.getTextureLocation(this.getAnimatable());
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueReplacedEntityRenderer<E, T> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueReplacedEntityRenderer<E, T> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueReplacedEntityRenderer<E, T> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Override
    @Nullable
    public class_1921 getRenderType(@NotNull class_2960 pTexture, @NotNull IRenderContext<T> pContext) {
        boolean invisible;
        boolean bl = invisible = this.currentEntity != null && this.currentEntity.method_5767();
        if (invisible && !this.currentEntity.method_5756(PlayerUtils.getClientPlayer())) {
            return class_1921.method_29379((class_2960)pTexture);
        }
        if (!invisible) {
            return BlueRenderer.super.getRenderType(pTexture, pContext);
        }
        return this.currentEntity != null && class_310.method_1551().method_27022(this.currentEntity) ? class_1921.method_23287((class_2960)pTexture) : null;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
    }

    @ApiStatus.Internal
    public void method_3936(@NotNull E pEntity, float pEntityYaw, float pPartialTick, @NotNull class_4587 pPoseStack, @NotNull class_4597 pBufferSource, int pPackedLight) {
        this.currentEntity = pEntity;
        this.defaultRender(new BaseRenderContext<T>(pPoseStack, this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource(this.animatable, this)), pBufferSource, false, pPartialTick, pPackedLight, this.getPackedOverlay(this.getAnimatable(), 0.0f, pPartialTick), this.getRenderColor((BlueAnimatable)this.getAnimatable(), pPartialTick, pPackedLight).argbInt()));
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            float[] fArray;
            class_1309 e;
            FullRenderContext full = (FullRenderContext)pContext;
            class_4587 poseStack = full.poseStack();
            Object animatable = full.animatable();
            class_4588 buffer = full.optionalBuffer();
            boolean isReRender = full.isReRender();
            float partialTick = full.partialTick();
            poseStack.method_22903();
            E e2 = this.currentEntity;
            class_1309 livingEntity = e2 instanceof class_1309 ? (e = (class_1309)e2) : null;
            e2 = this.currentEntity;
            if (e2 instanceof class_1308) {
                class_1297 leashHolder;
                class_1308 mob = (class_1308)e2;
                if (!isReRender && (leashHolder = mob.method_60952()) != null) {
                    this.renderLeash(mob, partialTick, poseStack, full.bufferSource(), leashHolder);
                }
            }
            boolean shouldSit = this.getCurrentEntity().method_5765() && this.getCurrentEntity().method_5854() != null;
            float lerpBodyRot = EntityRenderUtils.getLerpBodyRot(livingEntity, partialTick);
            float lerpHeadRot = EntityRenderUtils.getLerpHeadRot(livingEntity, partialTick);
            float[] adjusted = EntityRenderUtils.adjustSittingRotations(shouldSit, this.getCurrentEntity(), lerpHeadRot, lerpBodyRot, partialTick);
            lerpBodyRot = adjusted[0];
            float netHeadYaw = adjusted[1];
            if (livingEntity != null) {
                EntityRenderUtils.applySleepingTranslation(poseStack, livingEntity);
            }
            float nativeScale = livingEntity != null ? livingEntity.method_55693() : 1.0f;
            float ageInTicks = (float)((class_1297)this.getCurrentEntity()).field_6012 + partialTick;
            poseStack.method_22905(nativeScale, nativeScale, nativeScale);
            this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
            if (livingEntity != null) {
                fArray = EntityRenderUtils.computeLimbSwing(livingEntity, shouldSit, partialTick);
            } else {
                float[] fArray2 = new float[2];
                fArray2[0] = 0.0f;
                fArray = fArray2;
                fArray2[1] = 0.0f;
            }
            float[] limbSwingData = fArray;
            float limbSwing = limbSwingData[0];
            float limbSwingAmount = limbSwingData[1];
            float headPitch = class_3532.method_16439((float)partialTick, (float)((class_1297)this.getCurrentEntity()).field_6004, (float)this.getCurrentEntity().method_36455());
            if (!isReRender) {
                float motionThreshold = this.getMotionAnimThreshold(pContext);
                boolean moving = livingEntity != null ? EntityRenderUtils.isEntityMoving(livingEntity, motionThreshold, limbSwingAmount) : Math.abs(limbSwingAmount) >= motionThreshold;
                AnimationState state = new AnimationState(animatable, limbSwing, limbSwingAmount, partialTick, moving);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<BlueAnimatable> model = this.getBlueModel();
                state.setData(DataTickets.TICK, animatable.getTick(this.getCurrentEntity()));
                state.setData(DataTickets.ENTITY, this.getCurrentEntity());
                state.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.method_6109(), -netHeadYaw, -headPitch));
                model.addAdditionalStateData((BlueAnimatable)animatable, instanceId, (BiConsumer<DataTicket<BlueAnimatable>, BlueAnimatable>)((BiConsumer<DataTicket, BlueAnimatable>)state::setData));
                model.handleAnimations((BlueAnimatable)animatable, instanceId, state, partialTick);
            }
            poseStack.method_46416(0.0f, 0.01f, 0.0f);
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            if (buffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
            poseStack.method_22909();
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void applyRenderLayers(@NotNull IRenderContext<T> pContext) {
        if (!this.getCurrentEntity().method_7325()) {
            BlueRenderer.super.applyRenderLayers(pContext);
        }
    }

    @Override
    public void renderFinal(@NotNull IRenderContext<T> pContext) {
        class_1308 mob;
        class_1297 leashHolder;
        super.method_3936(this.getCurrentEntity(), 0.0f, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), pContext.packedLight());
        E e = this.currentEntity;
        if (e instanceof class_1308 && (leashHolder = (mob = (class_1308)e).method_60952()) != null) {
            this.renderLeash(mob, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), leashHolder);
        }
    }

    @Override
    public void postRender(@NotNull IRenderContext<T> pContext) {
        if (!pContext.isReRender()) {
            super.method_3936(this.getCurrentEntity(), 0.0f, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), pContext.packedLight());
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.currentEntity = null;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        pContext.poseStack().method_22903();
        RenderUtils.translateMatrixToBone(pContext.poseStack(), pBone);
        RenderUtils.translateToPivotPoint(pContext.poseStack(), pBone);
        RenderUtils.rotateMatrixAroundBone(pContext.poseStack(), pBone);
        RenderUtils.scaleMatrixForBone(pContext.poseStack(), pBone);
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.method_23169((class_1297)this.getCurrentEntity(), 1.0f).method_46409()));
            pBone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), this.getCurrentEntity().method_19538().method_46409()));
        }
        RenderUtils.translateAwayFromPivotPoint(pContext.poseStack(), pBone);
        pContext.setBuffer(BufferUtils.checkAndRefreshBuffer(pContext.isReRender(), pContext.buffer(), pContext.bufferSource(), pContext.renderType()));
        this.renderCubesOfBone(pBone, pContext);
        if (!pContext.isReRender()) {
            this.applyRenderLayersForBone(pBone, pContext);
        }
        this.renderChildBones(pBone, pContext);
        pContext.poseStack().method_22909();
    }

    protected void applyRotations(@NotNull T pAnimatable, @NotNull class_4587 pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTick, float pNativeScale) {
        E e;
        if (this.isShaking(pAnimatable)) {
            pRotationYaw += (float)(Math.cos((double)((class_1297)this.getCurrentEntity()).field_6012 * 3.25) * Math.PI * 0.4);
        }
        if (!this.getCurrentEntity().method_41328(class_4050.field_18078)) {
            pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - pRotationYaw));
        }
        if ((e = this.getCurrentEntity()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)e;
            if (livingEntity.field_6213 > 0) {
                float deathRotation = ((float)livingEntity.field_6213 + pPartialTick - 1.0f) / 20.0f * 1.6f;
                pPoseStack.method_22907(class_7833.field_40718.rotationDegrees(Math.min(class_3532.method_15355((float)deathRotation), 1.0f) * this.getDeathMaxRotation(pAnimatable)));
            } else if (livingEntity.method_6123()) {
                pPoseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f - livingEntity.method_36455()));
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(((float)livingEntity.field_6012 + pPartialTick) * -75.0f));
            } else if (livingEntity.method_41328(class_4050.field_18078)) {
                class_2350 bedOrientation = livingEntity.method_18401();
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation).floatValue() : pRotationYaw));
                pPoseStack.method_22907(class_7833.field_40718.rotationDegrees(this.getDeathMaxRotation(pAnimatable)));
                pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
            } else if (class_922.method_38563((class_1309)livingEntity)) {
                pPoseStack.method_46416(0.0f, (livingEntity.method_17682() + 0.1f) / pNativeScale, 0.0f);
                pPoseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(@NotNull T pAnimatable) {
        return 90.0f;
    }

    public double getNameRenderCutoffDistance(@NotNull E pEntity, @NotNull T pAnimatable) {
        return pEntity.method_21751() ? 32.0 : 64.0;
    }

    public boolean method_3921(@NotNull E pEntity) {
        if (!(pEntity instanceof class_1309)) {
            return super.method_3921(pEntity);
        }
        double nameRenderCutoff = this.getNameRenderCutoffDistance(pEntity, this.getAnimatable());
        if (this.field_4676.method_23168(pEntity) >= nameRenderCutoff * nameRenderCutoff) {
            return false;
        }
        if (!(!(pEntity instanceof class_1308) || pEntity.method_5733() || pEntity.method_16914() && pEntity == this.field_4676.field_4678)) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        boolean visibleToClient = !pEntity.method_5756(PlayerUtils.getClientPlayer());
        class_268 entityTeam = pEntity.method_5781();
        if (entityTeam == null) {
            return class_310.method_1498() && pEntity != minecraft.method_1560() && visibleToClient && !pEntity.method_5782();
        }
        class_268 playerTeam = PlayerUtils.getClientPlayer().method_5781();
        return switch (entityTeam.method_1201()) {
            default -> throw new MatchException(null, null);
            case class_270.class_272.field_1442 -> visibleToClient;
            case class_270.class_272.field_1443 -> false;
            case class_270.class_272.field_1444 -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.method_1206((class_270)playerTeam) && (entityTeam.method_1199() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case class_270.class_272.field_1446 -> playerTeam == null ? visibleToClient : !entityTeam.method_1206((class_270)playerTeam) && visibleToClient;
        };
    }

    @Override
    public int getPackedOverlay(@NotNull T pAnimatable, float pU, float pPartialTick) {
        E e = this.currentEntity;
        if (!(e instanceof class_1309)) {
            return class_4608.field_21444;
        }
        class_1309 entity = (class_1309)e;
        return class_4608.method_23625((int)class_4608.method_23210((float)pU), (int)class_4608.method_23212((entity.field_6235 > 0 || entity.field_6213 > 0 ? 1 : 0) != 0));
    }

    public boolean isShaking(@NotNull T pAnimatable) {
        return this.getCurrentEntity().method_32314();
    }

    public <H extends class_1297, M extends class_1308> void renderLeash(@NotNull M pMob, float pPartialTick, @NotNull class_4587 pPoseStack, @NotNull class_4597 pBufferSource, @NotNull H pLeashHolder) {
        int segment;
        double lerpBodyAngle = class_3532.method_16439((float)pPartialTick, (float)pMob.field_6220, (float)pMob.field_6283) * ((float)Math.PI / 180) + 1.5707964f;
        class_243 leashOffset = pMob.method_45321(pPartialTick);
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.field_1350 + Math.sin(lerpBodyAngle) * leashOffset.field_1352;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.field_1350 - Math.cos(lerpBodyAngle) * leashOffset.field_1352;
        double lerpOriginX = class_3532.method_16436((double)pPartialTick, (double)pMob.field_6014, (double)pMob.method_23317()) + xAngleOffset;
        double lerpOriginY = class_3532.method_16436((double)pPartialTick, (double)pMob.field_6036, (double)pMob.method_23318()) + leashOffset.field_1351;
        double lerpOriginZ = class_3532.method_16436((double)pPartialTick, (double)pMob.field_5969, (double)pMob.method_23321()) + zAngleOffset;
        class_243 ropeGripPosition = pLeashHolder.method_30951(pPartialTick);
        float xDif = (float)(ropeGripPosition.field_1352 - lerpOriginX);
        float yDif = (float)(ropeGripPosition.field_1351 - lerpOriginY);
        float zDif = (float)(ropeGripPosition.field_1350 - lerpOriginZ);
        float offsetMod = class_3532.method_48119((float)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        class_4588 vertexConsumer = pBufferSource.getBuffer(class_1921.method_23587());
        class_2338 entityEyePos = class_2338.method_49638((class_2374)pMob.method_5836(pPartialTick));
        class_2338 holderEyePos = class_2338.method_49638((class_2374)pLeashHolder.method_5836(pPartialTick));
        int entityBlockLight = this.method_24087((class_1297)pMob, entityEyePos);
        int holderBlockLight = pLeashHolder.method_5809() ? 15 : pLeashHolder.method_37908().method_8314(class_1944.field_9282, holderEyePos);
        int entitySkyLight = pMob.method_37908().method_8314(class_1944.field_9284, entityEyePos);
        int holderSkyLight = pMob.method_37908().method_8314(class_1944.field_9284, holderEyePos);
        pPoseStack.method_22903();
        pPoseStack.method_22904(xAngleOffset, leashOffset.field_1351, zAngleOffset);
        Matrix4f posMatrix = new Matrix4f((Matrix4fc)pPoseStack.method_23760().method_23761());
        for (segment = 0; segment <= 24; ++segment) {
            BlueReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            BlueReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        pPoseStack.method_22909();
    }

    private static void renderLeashPiece(@NotNull class_4588 pBuffer, @NotNull Matrix4f pPositionMatrix, float pXDif, float pYDif, float pZDif, int pEntityBlockLight, int pHolderBlockLight, int pEntitySkyLight, int pHolderSkyLight, float pWidth, float pYOffset, float pXOffset, float pZOffset, int pSegment, boolean pIsLeashKnot) {
        float piecePosPercent = (float)pSegment / 24.0f;
        int lerpBlockLight = (int)class_3532.method_16439((float)piecePosPercent, (float)pEntityBlockLight, (float)pHolderBlockLight);
        int lerpSkyLight = (int)class_3532.method_16439((float)piecePosPercent, (float)pEntitySkyLight, (float)pHolderSkyLight);
        int pPackedLight = class_765.method_23687((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = pSegment % 2 == (pIsLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = pXDif * piecePosPercent;
        float y = pYDif > 0.0f ? pYDif * piecePosPercent * piecePosPercent : pYDif - pYDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = pZDif * piecePosPercent;
        pBuffer.method_22918(pPositionMatrix, x - pXOffset, y + pYOffset, z + pZOffset).method_22915(red, green, blue, 1.0f).method_60803(pPackedLight);
        pBuffer.method_22918(pPositionMatrix, x + pXOffset, y + pWidth - pYOffset, z - pZOffset).method_22915(red, green, blue, 1.0f).method_60803(pPackedLight);
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((BlueAnimatable)pContext.animatable()));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileReplacedEntityRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireReplacedEntityPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireReplacedEntityPostRender(this, pContext);
    }
}

