/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.item;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_918;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.exception.nulls.ItemDisplayContextNullException;
import software.bluelib.api.exception.nulls.ItemStackNullException;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.item.BlueItem;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class BlueItemRenderer<T extends class_1792>
extends class_756
implements BlueRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @Nullable
    protected class_1799 currentItemStack;
    @Nullable
    protected class_811 renderPerspective;
    @Nullable
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected boolean useEntityGuiLighting = false;
    @NotNull
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public BlueItemRenderer(@NotNull BlueModel<T> pModel) {
        this(class_310.method_1551().method_31975(), class_310.method_1551().method_31974(), pModel);
    }

    public BlueItemRenderer(@NotNull class_824 pDispatcher, @NotNull class_5599 pModelSet, @NotNull BlueModel<T> pModel) {
        super(pDispatcher, pModelSet);
        this.model = pModel;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @Nullable
    public T getOptionalAnimatable() {
        return this.animatable;
    }

    @Nullable
    public class_1799 getOptionalCurrentItemStack() {
        return this.currentItemStack;
    }

    @NotNull
    public class_1799 getCurrentItemStack() {
        class_1799 currentItemStack = this.getOptionalCurrentItemStack();
        if (currentItemStack == null) {
            throw new ItemStackNullException("CurrentItemStack cannot be null when rendering!");
        }
        return currentItemStack;
    }

    @Nullable
    public class_811 getOptionalRenderPerspective() {
        return this.renderPerspective;
    }

    @NotNull
    public class_811 getRenderPerspective() {
        class_811 renderPerspective = this.getOptionalRenderPerspective();
        if (renderPerspective == null) {
            throw new ItemDisplayContextNullException("RenderPerspective cannot be null when rendering!");
        }
        return renderPerspective;
    }

    @NotNull
    public BlueItemRenderer<T> useAlternateGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        return BlueItem.getId(this.getCurrentItemStack());
    }

    @Override
    @NotNull
    public class_2960 getTextureLocation(@NotNull T pAnimatable) {
        return BlueRenderer.super.getTextureLocation(pAnimatable);
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueItemRenderer<T> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueItemRenderer<T> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueItemRenderer<T> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.itemRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
        if (!pContext.isReRender()) {
            pContext.poseStack().method_46416(0.5f, 0.51f, 0.5f);
        }
    }

    @ApiStatus.Internal
    public void method_3166(@NotNull class_1799 pStack, @NotNull class_811 pTransformType, @NotNull class_4587 pPoseStack, @NotNull class_4597 pBufferSource, int pPackedLight, int pPackedOverlay) {
        this.animatable = pStack.method_7909();
        this.currentItemStack = pStack;
        this.renderPerspective = pTransformType;
        float partialTick = class_310.method_1551().method_60646().method_60637(true);
        if (pTransformType == class_811.field_4317) {
            this.renderInGui(pTransformType, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, partialTick);
        } else {
            int color = this.getRenderColor((BlueAnimatable)((class_1792)this.getAnimatable()), partialTick, pPackedLight).argbInt();
            ModelCache modelCache = this.model.getBakedModel(this.getBlueModel().getModelResource(this.animatable, this));
            class_1921 renderType = this.getRenderType(this.getTextureLocation((class_1792)this.getAnimatable()), new BaseRenderContext<class_1792>(pPoseStack, (class_1792)this.getAnimatable(), modelCache, pBufferSource, false, partialTick, pPackedLight, pPackedOverlay, color));
            if (renderType == null) {
                renderType = class_1921.method_23583();
            }
            class_4588 buffer = class_918.method_29711((class_4597)pBufferSource, (class_1921)renderType, (boolean)false, (this.currentItemStack != null && this.currentItemStack.method_7958() ? 1 : 0) != 0);
            this.defaultRender(new FullRenderContext<class_1792>(pPoseStack, (class_1792)this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource(this.animatable, this)), renderType, pBufferSource, buffer, false, partialTick, pPackedLight, this.getPackedOverlay((BlueAnimatable)((class_1792)this.getAnimatable()), 0.0f, partialTick), color));
        }
        this.animatable = null;
    }

    protected void renderInGui(@NotNull class_811 pTransformType, @NotNull class_4587 pPoseStack, @NotNull class_4597 pBufferSource, int pPackedLight, int pPackedOverlay, float pPartialTick) {
        class_4597.class_4598 bufferSource2;
        this.setupLightingForGuiRender();
        class_4597.class_4598 defaultBufferSource = pBufferSource instanceof class_4597.class_4598 ? (bufferSource2 = (class_4597.class_4598)pBufferSource) : class_310.method_1551().field_1769.field_20951.method_23000();
        int color = this.getRenderColor((BlueAnimatable)((class_1792)this.getAnimatable()), pPartialTick, pPackedLight).argbInt();
        ModelCache modelCache = this.model.getBakedModel(this.getBlueModel().getModelResource((class_1792)this.getAnimatable(), this));
        class_1921 renderType = this.getRenderType(this.getTextureLocation((class_1792)this.getAnimatable()), new BaseRenderContext<class_1792>(pPoseStack, (class_1792)this.getAnimatable(), modelCache, (class_4597)defaultBufferSource, false, pPartialTick, pPackedLight, pPackedOverlay, color));
        if (renderType == null) {
            renderType = class_1921.method_23583();
        }
        class_4588 buffer = class_918.method_29711((class_4597)pBufferSource, (class_1921)renderType, (boolean)true, (this.currentItemStack != null && this.currentItemStack.method_7958() ? 1 : 0) != 0);
        pPoseStack.method_22903();
        this.defaultRender(new FullRenderContext<class_1792>(pPoseStack, (class_1792)this.getAnimatable(), modelCache, renderType, pBufferSource, buffer, false, pPartialTick, pPackedLight, pPackedOverlay, color));
        defaultBufferSource.method_22993();
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        pPoseStack.method_22909();
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            class_4587 pPoseStack = full.poseStack();
            class_1792 pAnimatable = (class_1792)full.animatable();
            class_4588 pBuffer = full.optionalBuffer();
            boolean pIsReRender = full.isReRender();
            float pPartialTick = full.partialTick();
            if (!pIsReRender) {
                AnimationState<class_1792> animationState = new AnimationState<class_1792>(pAnimatable, 0.0f, 0.0f, pPartialTick, false);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<class_1792> currentModel = this.getBlueModel();
                animationState.setData(DataTickets.TICK, ((BlueAnimatable)pAnimatable).getTick(this.getCurrentItemStack()));
                animationState.setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
                animationState.setData(DataTickets.ITEMSTACK, this.currentItemStack);
                ((BlueAnimatable)pAnimatable).getAnimatableInstanceCache().getManagerForId(instanceId).setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.getRenderPerspective());
                currentModel.addAdditionalStateData(pAnimatable, instanceId, (x$0, x$1) -> animationState.setData(x$0, x$1));
                currentModel.handleAnimations(pAnimatable, instanceId, animationState, pPartialTick);
            }
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)pPoseStack.method_23760().method_23761());
            if (pBuffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.animatable = null;
        this.currentItemStack = null;
        this.renderPerspective = null;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().method_23760().method_23761());
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRenderTranslations));
        }
        BlueRenderer.super.renderRecursively(pBone, pContext);
    }

    public void setupLightingForGuiRender() {
        if (this.useEntityGuiLighting) {
            class_308.method_34742();
        } else {
            class_308.method_24210();
        }
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((class_1792)pContext.animatable()));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileItemRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireItemPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireItemPostRender(this, pContext);
    }
}

