/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.layer;

import java.util.function.BiFunction;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.IRenderContext;

public class BlockAndItemBlueLayer<T extends BlueAnimatable>
extends BlueRenderLayer<T> {
    @NotNull
    protected final BiFunction<BoneCache, T, class_1799> stackForBone;
    @NotNull
    protected final BiFunction<BoneCache, T, class_2680> blockForBone;

    public BlockAndItemBlueLayer(@NotNull BlueRenderer<T> pRenderer) {
        this(pRenderer, (bone, animatable) -> null, (bone, animatable) -> null);
    }

    public BlockAndItemBlueLayer(@NotNull BlueRenderer<T> pRenderer, @NotNull BiFunction<BoneCache, T, class_1799> pStackForBone, @NotNull BiFunction<BoneCache, T, class_2680> pBlockForBone) {
        super(pRenderer);
        this.stackForBone = pStackForBone;
        this.blockForBone = pBlockForBone;
    }

    @Nullable
    protected class_1799 getStackForBone(@NotNull BoneCache pBone, @NotNull T pAnimatable) {
        return this.stackForBone.apply(pBone, (BoneCache)pAnimatable);
    }

    @Nullable
    protected class_2680 getBlockForBone(@NotNull BoneCache pBone, @NotNull T pAnimatable) {
        return this.blockForBone.apply(pBone, (BoneCache)pAnimatable);
    }

    @NotNull
    protected class_811 getTransformTypeForStack(@NotNull BoneCache pBone, @NotNull class_1799 pStack, @NotNull IRenderContext<T> pContext) {
        return class_811.field_4315;
    }

    @Override
    public void renderForBone(@NotNull BoneCache pBone, @NotNull IRenderContext<T> pContext) {
        class_1799 stack = this.getStackForBone(pBone, pContext.animatable());
        class_2680 blockState = this.getBlockForBone(pBone, pContext.animatable());
        if (stack == null && blockState == null) {
            return;
        }
        pContext.poseStack().method_22903();
        RenderUtils.translateAndRotateMatrixForBone(pContext.poseStack(), pBone);
        if (stack != null) {
            this.renderStackForBone(pBone, stack, pContext);
        }
        if (blockState != null) {
            this.renderBlockForBone(pBone, blockState, pContext);
        }
        pContext.poseStack().method_22909();
    }

    protected void renderStackForBone(@NotNull BoneCache pBone, @NotNull class_1799 pStack, @NotNull IRenderContext<T> pContext) {
        T t = pContext.animatable();
        if (t instanceof class_1309) {
            class_1309 livingEntity = (class_1309)t;
            class_310.method_1551().method_1480().method_23177(livingEntity, pStack, this.getTransformTypeForStack(pBone, pStack, pContext), false, pContext.poseStack(), pContext.bufferSource(), livingEntity.method_37908(), pContext.packedLight(), pContext.packedOverlay(), livingEntity.method_5628());
        } else {
            class_310.method_1551().method_1480().method_23178(pStack, this.getTransformTypeForStack(pBone, pStack, pContext), pContext.packedLight(), pContext.packedOverlay(), pContext.poseStack(), pContext.bufferSource(), (class_1937)class_310.method_1551().field_1687, (int)this.renderer.getInstanceId(pContext));
        }
    }

    protected void renderBlockForBone(@NotNull BoneCache pBone, @NotNull class_2680 pState, @NotNull IRenderContext<T> pContext) {
        pContext.poseStack().method_22903();
        pContext.poseStack().method_46416(-0.25f, -0.25f, -0.25f);
        pContext.poseStack().method_22905(0.5f, 0.5f, 0.5f);
        class_310.method_1551().method_1541().method_3353(pState, pContext.poseStack(), pContext.bufferSource(), pContext.packedLight(), class_4608.field_21444);
        pContext.poseStack().method_22909();
    }
}

