/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.markdown.syntax;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.IsValidUtils;
import software.bluelib.api.utils.conversion.ColorConverterUtils;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.config.MarkdownConfig;
import software.bluelib.internal.BlueTranslation;
import software.bluelib.markdown.MarkdownFeature;

public class Color
extends MarkdownFeature {
    @Override
    @NotNull
    public class_5250 apply(@NotNull class_5250 pComponent) {
        if (!MarkdownConfig.isColorEnabled) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("markdown.color.disabled"));
            return pComponent;
        }
        Pattern pattern = Pattern.compile(Pattern.quote(MarkdownConfig.colorPrefix) + "#([0-9A-Fa-f]{6}(?:,#([0-9A-Fa-f]{6}))*)" + Pattern.quote(MarkdownConfig.colorSuffix) + "\\((.*?)\\)");
        class_5250 result = class_2561.method_43473();
        if (pComponent.method_10855().isEmpty()) {
            this.processComponentTextWithColors(pComponent.getString(), pComponent.method_10866(), result, pattern);
        } else {
            result = this.processSiblingsWithColors(pComponent, pattern);
        }
        return result;
    }

    protected void processComponentTextWithColors(@NotNull String pText, @NotNull class_2583 pOriginalStyle, @NotNull class_5250 pResult, @NotNull Pattern pPattern) {
        this.processComponentText(pText, pOriginalStyle, pResult, pPattern, (matcher, res) -> {
            Object colors = this.extractColorsFromMatcher((Matcher)matcher);
            String gradientText = matcher.group(matcher.groupCount());
            this.appendColor(gradientText, colors, pOriginalStyle, (class_5250)res);
        });
    }

    @NotNull
    private Object extractColorsFromMatcher(@NotNull Matcher matcher) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        String colorGroup = matcher.group(1);
        if (colorGroup != null) {
            String[] colorArray;
            for (String color : colorArray = colorGroup.split(",")) {
                if (!IsValidUtils.isValidColor(color).booleanValue()) {
                    BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("markdown.color.invalid", color));
                    return colorGroup;
                }
                colors.add(ColorConverterUtils.parseColorToHexString(color));
            }
        }
        return colors;
    }

    private void appendColor(@NotNull String pColorText, @NotNull Object pColors, @NotNull class_2583 pOriginalStyle, @NotNull class_5250 pResult) {
        List colorsList;
        if (pColors instanceof String) {
            pResult.method_10852((class_2561)class_2561.method_43470((String)(MarkdownConfig.colorPrefix + String.valueOf(pColors) + MarkdownConfig.colorSuffix + "(" + pColorText + ")")).method_10862(pOriginalStyle));
            return;
        }
        if (pColors instanceof List && !(colorsList = (List)pColors).isEmpty() && colorsList.getFirst() instanceof Integer) {
            List colors = colorsList;
            if (colors.size() == 1) {
                int color = (Integer)colors.getFirst();
                pResult.method_10852((class_2561)class_2561.method_43470((String)pColorText).method_10862(pOriginalStyle.method_27703(class_5251.method_27717((int)color))));
                return;
            }
            char[] characters = pColorText.toCharArray();
            int textLength = characters.length;
            int colorCount = colors.size();
            int segmentLength = textLength / (colorCount - 1);
            int remainder = textLength % (colorCount - 1);
            int charIndex = 0;
            for (int colorIndex = 0; colorIndex < colorCount - 1; ++colorIndex) {
                int startColor = (Integer)colors.get(colorIndex);
                int endColor = (Integer)colors.get(colorIndex + 1);
                int currentSegmentLength = segmentLength + (colorIndex < remainder ? 1 : 0);
                for (int i = 0; i < currentSegmentLength && charIndex < textLength; ++i, ++charIndex) {
                    float positionRatio = (float)i / (float)(currentSegmentLength - 1);
                    int interpolatedColor = this.interpolateColor(startColor, endColor, Float.valueOf(positionRatio));
                    pResult.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(characters[charIndex])).method_10862(pOriginalStyle.method_27703(class_5251.method_27717((int)interpolatedColor))));
                }
            }
        } else {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("markdown.color.list.invalid", pColors));
            pResult.method_10852((class_2561)class_2561.method_43470((String)(MarkdownConfig.colorPrefix + String.valueOf(pColors) + MarkdownConfig.colorSuffix + "(" + pColorText + ")")).method_10862(pOriginalStyle));
        }
    }

    @NotNull
    private Integer interpolateColor(@NotNull Integer startColor, @NotNull Integer endColor, @NotNull Float ratio) {
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        int r = (int)((float)startR + (float)(endR - startR) * ratio.floatValue());
        int g = (int)((float)startG + (float)(endG - startG) * ratio.floatValue());
        int b = (int)((float)startB + (float)(endB - startB) * ratio.floatValue());
        return r << 16 | g << 8 | b;
    }

    @NotNull
    public class_5250 processSiblingsWithColors(@NotNull class_5250 pComponent, @NotNull Pattern pPattern) {
        return this.processSiblings(pComponent, pPattern, this::processComponentTextWithColors);
    }

    @Override
    @NotNull
    protected Boolean isFeatureEnabled() {
        return MarkdownConfig.isColorEnabled;
    }

    @Override
    @NotNull
    protected String getFeatureName() {
        return "Color";
    }
}

