/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.net;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.NetworkManager;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.api.net.NetworkRegistry;
import software.bluelib.net.FabricPacketInfo;

public class FabricNetworkManager
implements NetworkManager {
    public static void registerMessages() {
        NetworkRegistry.getS2CPayloads().forEach(info -> FabricPacketInfo.registerPacket(info, true));
        NetworkRegistry.getC2SPayloads().forEach(info -> FabricPacketInfo.registerPacket(info, false));
    }

    public static void registerClientHandlers() {
        NetworkRegistry.getS2CPayloads().stream().map(FabricPacketInfo::new).forEach(FabricPacketInfo::registerClientHandler);
    }

    public static void registerServerHandlers() {
        NetworkRegistry.getC2SPayloads().stream().map(FabricPacketInfo::new).forEach(FabricPacketInfo::registerServerHandler);
    }

    @Override
    public void sendPacketToPlayer(@NotNull class_3222 pPlayer, @NotNull NetworkPacket<?> pPacket) {
        ServerPlayNetworking.send((class_3222)pPlayer, pPacket);
    }

    @Override
    public void sendToServer(@NotNull NetworkPacket<?> pPacket) {
        ClientPlayNetworking.send(pPacket);
    }

    @Override
    public void sendToAllPlayersTrackingEntity(@NotNull class_1297 pTrackingEntity, @NotNull NetworkPacket<?> pPacket) {
        if (pTrackingEntity instanceof class_3222) {
            class_3222 pl = (class_3222)pTrackingEntity;
            this.sendPacketToPlayer(pl, pPacket);
        }
        for (class_3222 player : PlayerLookup.tracking((class_1297)pTrackingEntity)) {
            this.sendPacketToPlayer(player, pPacket);
        }
    }

    @Override
    public void sendToAllPlayersTrackingBlock(@NotNull class_3218 pLevel, @NotNull class_2338 pBlockPos, @NotNull NetworkPacket<?> pPacket) {
        for (class_3222 player : PlayerLookup.tracking((class_3218)pLevel, (class_2338)pBlockPos)) {
            this.sendPacketToPlayer(player, pPacket);
        }
    }
}

