/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.platform;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.Environment;
import software.bluelib.api.ModAPI;
import software.bluelib.api.event.mod.ModMeta;
import software.bluelib.platform.IPlatformHelper;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    @NotNull
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(@NotNull String pModId) {
        return FabricLoader.getInstance().isModLoaded(pModId);
    }

    @Override
    @NotNull
    public Set<String> getLoadedMods() {
        return FabricLoader.getInstance().getAllMods().stream().map(modContainer -> modContainer.getMetadata().getId()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public List<ModMeta> getLoadedModMetadata() {
        ArrayList<ModMeta> mods = new ArrayList<ModMeta>();
        for (ModContainer modInfo : FabricLoader.getInstance().getAllMods()) {
            String modId = modInfo.getMetadata().getId();
            String displayName = modInfo.getMetadata().getName();
            String version = modInfo.getMetadata().getVersion().toString();
            String description = modInfo.getMetadata().getDescription();
            Optional logoFile = modInfo.getMetadata().getIconPath(128);
            mods.add(new ModMeta(modId, displayName, version, description, logoFile));
        }
        return mods;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    @NotNull
    public Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public boolean isPhysicalClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    @NotNull
    public Environment getEnvironment() {
        return switch (FabricLoader.getInstance().getEnvironmentType()) {
            default -> throw new MatchException(null, null);
            case EnvType.CLIENT -> Environment.CLIENT;
            case EnvType.SERVER -> Environment.SERVER;
        };
    }

    @Override
    @NotNull
    public ModAPI getAPI() {
        return ModAPI.FABRIC;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return this.getEnvironment() == Environment.CLIENT ? class_310.method_1551().method_1576() : BlueLibConstants.server;
    }
}

