/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.recipe.brewing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import software.bluelib.internal.registry.BlueRecipeSerializerRegistry;
import software.bluelib.internal.registry.BlueRecipeTypeRegistry;
import software.bluelib.recipe.brewing.BrewingInput;

public record BrewingRecipe(@NotNull String groupName, @NotNull class_1856 input, @NotNull class_1856 bottle, @NotNull class_1799 result) implements class_1860<BrewingInput>
{
    public boolean matches(@NotNull BrewingInput pInputData, @NotNull class_1937 pLevel) {
        boolean ingredientMatches = this.input.method_8093(pInputData.ingredient());
        List<class_1799> bottles = pInputData.bottles();
        boolean validBottles = bottles.stream().filter(stack -> !stack.method_7960()).allMatch((Predicate<class_1799>)this.bottle);
        return ingredientMatches && validBottles;
    }

    @NotNull
    public class_1799 assemble(@NotNull BrewingInput pInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 pRegistries) {
        return this.result.method_7972();
    }

    public boolean method_8113(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public class_1799 method_8110(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 pRegistries) {
        return this.result.method_7972();
    }

    @NotNull
    public class_1865<?> method_8119() {
        return BlueRecipeSerializerRegistry.BREWING.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return BlueRecipeTypeRegistry.BREWING.get();
    }

    @NotNull
    public class_1856 getInputIngredient() {
        return this.input;
    }

    @NotNull
    public class_1856 getBottleIngredient() {
        return this.bottle;
    }

    public static boolean isBottle(@NotNull class_1799 pItemStack, @NotNull class_1863 pRecipeManager) {
        return pRecipeManager.method_30027(BlueRecipeTypeRegistry.BREWING.get()).stream().anyMatch(recipe -> ((BrewingRecipe)recipe.comp_1933()).getBottleIngredient().method_8093(pItemStack));
    }

    public static boolean isInput(@NotNull class_1799 pItemStack, @NotNull class_1863 pRecipeManager) {
        return pRecipeManager.method_30027(BlueRecipeTypeRegistry.BREWING.get()).stream().anyMatch(recipe -> ((BrewingRecipe)recipe.comp_1933()).getInputIngredient().method_8093(pItemStack));
    }

    public static class Serializer
    implements class_1865<BrewingRecipe> {
        @NotNull
        public static final MapCodec<BrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(BrewingRecipe::groupName), (App)class_1856.field_46095.fieldOf("input").forGetter(BrewingRecipe::getInputIngredient), (App)class_1856.field_46095.fieldOf("bottle").forGetter(BrewingRecipe::getBottleIngredient), (App)class_1799.field_51397.fieldOf("result").forGetter(BrewingRecipe::result)).apply((Applicative)instance, BrewingRecipe::new));
        @NotNull
        public static final class_9139<class_9129, BrewingRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        private static BrewingRecipe fromNetwork(@NotNull class_9129 pBuffer) {
            String group = pBuffer.method_10800(Short.MAX_VALUE);
            class_1856 input = (class_1856)class_1856.field_48355.decode((Object)pBuffer);
            class_1856 bottle = (class_1856)class_1856.field_48355.decode((Object)pBuffer);
            class_1799 result = (class_1799)class_1799.field_48349.decode((Object)pBuffer);
            return new BrewingRecipe(group, input, bottle, result);
        }

        private static void toNetwork(@NotNull class_9129 pBuffer, @NotNull BrewingRecipe pRecipe) {
            pBuffer.method_10814(pRecipe.groupName());
            class_1856.field_48355.encode((Object)pBuffer, (Object)pRecipe.getInputIngredient());
            class_1856.field_48355.encode((Object)pBuffer, (Object)pRecipe.getBottleIngredient());
            class_1799.field_48349.encode((Object)pBuffer, (Object)pRecipe.result());
        }

        @NotNull
        public MapCodec<BrewingRecipe> method_53736() {
            return CODEC;
        }

        @NotNull
        public class_9139<class_9129, BrewingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

