/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.datagen;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ItemTagsProvider;
import xxrexraptorxx.advancedtools.items.UpgradeItem;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModItems;
import xxrexraptorxx.advancedtools.registry.ModTags;
import xxrexraptorxx.advancedtools.utils.ToolUtils;
import xxrexraptorxx.magmacore.content.ItemHelper;
import xxrexraptorxx.magmacore.content.TagHelper;

public class ItemTagGen
extends ItemTagsProvider {
    public ItemTagGen(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider, "advancedtools");
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (String handle : ModItems.HANDLE_MATERIALS) {
            AdvancedTools.LOGGER.info("Generate item tags for " + handle);
            Item rodItem = (Item)BuiltInRegistries.ITEM.getValue(ItemHelper.getLocation((String)"advancedtools", (String)("stick_" + handle)));
            if (rodItem == Items.AIR) {
                AdvancedTools.LOGGER.error("Invalid item!!! [" + handle + "]");
            }
            TagKey rodTag = TagHelper.createCItemTag((String)("rods/" + ToolUtils.transformMaterialNames(handle)));
            TagKey stickTag = TagHelper.createCItemTag((String)("sticks/" + ToolUtils.transformMaterialNames(handle)));
            TagKey toolTag = TagHelper.createItemTag((String)"advancedtools", (String)(ToolUtils.transformMaterialNames(handle) + "_tools"));
            if (rodItem != Items.AIR) {
                this.tag(rodTag).add((Object)rodItem).addOptionalTag(stickTag);
                this.tag(stickTag).add((Object)rodItem);
            }
            this.tag(TagHelper.createCItemTag((String)"rods")).addOptionalTags(new TagKey[]{rodTag});
            this.tag(TagHelper.createCItemTag((String)"sticks")).addOptionalTags(new TagKey[]{stickTag});
            if (handle.contains("gold")) {
                this.tag(ItemTags.PIGLIN_LOVED).add((Object)((Item)BuiltInRegistries.ITEM.getValue(ItemHelper.getLocation((String)"advancedtools", (String)("stick_" + handle)))));
            } else if (handle.contains("soularium")) {
                this.tag(ItemTags.PIGLIN_REPELLENTS).add((Object)((Item)BuiltInRegistries.ITEM.getValue(ItemHelper.getLocation((String)"advancedtools", (String)("stick_" + handle)))));
            }
            for (String otherHandle : ModItems.HANDLE_MATERIALS) {
                for (String head : ModItems.TOOL_HEAD_MATERIALS) {
                    for (String tool : ModItems.TOOL_TYPES) {
                        ResourceLocation loc;
                        Item item;
                        if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(head) && handle.equals("wood") || (item = (Item)BuiltInRegistries.ITEM.getValue(loc = ItemHelper.getLocation((String)"advancedtools", (String)(otherHandle + "_stick_" + head + "_" + tool)))) == Items.AIR || !otherHandle.equals(handle) && !head.equals(handle)) continue;
                        this.tag(toolTag).add((Object)item);
                        switch (tool) {
                            case "sword": {
                                this.tag(ItemTags.SWORDS).add((Object)item);
                                break;
                            }
                            case "pickaxe": {
                                this.tag(ItemTags.PICKAXES).add((Object)item);
                                break;
                            }
                            case "axe": {
                                this.tag(ItemTags.AXES).add((Object)item);
                                break;
                            }
                            case "shovel": {
                                this.tag(ItemTags.SHOVELS).add((Object)item);
                                break;
                            }
                            case "hoe": {
                                this.tag(ItemTags.HOES).add((Object)item);
                            }
                        }
                        if (head.contains("gold") || handle.contains("gold")) {
                            this.tag(ItemTags.PIGLIN_LOVED).add((Object)item);
                            continue;
                        }
                        if (!head.contains("soularium") && !handle.contains("soularium")) continue;
                        this.tag(ItemTags.PIGLIN_REPELLENTS).add((Object)item);
                    }
                }
            }
        }
        for (String head : ModItems.TOOL_HEAD_MATERIALS) {
            if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(head)) continue;
            AdvancedTools.LOGGER.info("Generate crafting materials tag for " + head);
            TagKey craftingMaterialTag = TagHelper.createCItemTag((String)(ToolUtils.transformMaterialNames(head) + "_tool_materials"));
            for (TagKey<Item> key : ModTags.getPossibleTagsForMaterial(head)) {
                this.tag(craftingMaterialTag).addOptionalTag(key);
            }
        }
        TagKey woodStick = TagHelper.createCItemTag((String)"sticks/wood");
        this.tag(woodStick).add((Object)Items.STICK);
        this.tag(TagHelper.createCItemTag((String)"sticks")).addTags(new TagKey[]{woodStick});
        TagKey endRod = TagHelper.createCItemTag((String)"rods/end");
        this.tag(endRod).add((Object)Blocks.END_ROD.asItem());
        this.tag(TagHelper.createCItemTag((String)"rods")).addTags(new TagKey[]{endRod});
        this.tag(Tags.Items.TOOLS_BOW).add((Object[])new Item[]{(Item)ModItems.IRON_BOW.get(), ModItems.GOLD_BOW.asItem(), ModItems.DIAMOND_BOW.asItem(), ModItems.NETHERITE_BOW.asItem()});
        this.tag(ItemTags.BOW_ENCHANTABLE).add((Object[])new Item[]{(Item)ModItems.IRON_BOW.get(), ModItems.GOLD_BOW.asItem(), ModItems.DIAMOND_BOW.asItem(), ModItems.NETHERITE_BOW.asItem()});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"rarity_upgrade_materials")).addTags(new TagKey[]{Tags.Items.GEMS_EMERALD});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"netherite_upgrade_materials")).addTags(new TagKey[]{Tags.Items.INGOTS_NETHERITE});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"obsidian_upgrade_materials")).addTags(new TagKey[]{Tags.Items.OBSIDIANS});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"knockback_upgrade_materials")).add((Object)Items.TNT);
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"damage_upgrade_materials")).add((Object)Blocks.QUARTZ_BLOCK.asItem()).addOptionalTags(new TagKey[]{TagHelper.createCItemTag((String)"storage_blocks/quartz")});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"speed_upgrade_materials")).addTags(new TagKey[]{Tags.Items.STORAGE_BLOCKS_REDSTONE});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"luck_upgrade_materials")).add((Object)Blocks.AMETHYST_BLOCK.asItem()).addOptionalTags(new TagKey[]{TagHelper.createCItemTag((String)"storage_blocks/amethyst")});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"efficiency_upgrade_materials")).addTags(new TagKey[]{Tags.Items.STORAGE_BLOCKS_LAPIS});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"underwater_upgrade_materials")).addTags(new TagKey[]{Tags.Items.GEMS_PRISMARINE});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"attack_range_upgrade_materials")).addTags(new TagKey[]{Tags.Items.RODS_BLAZE});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"mining_range_upgrade_materials")).addTags(new TagKey[]{Tags.Items.RODS_BREEZE});
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"sweeping_upgrade_materials")).add((Object)Items.PHANTOM_MEMBRANE);
        this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"protection_upgrade_materials")).addTags(new TagKey[]{Tags.Items.STORAGE_BLOCKS_IRON});
        for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
            if (!(item instanceof UpgradeItem)) continue;
            this.tag(TagHelper.createItemTag((String)"advancedtools", (String)"upgrades")).add((Object)item);
        }
    }
}

