/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.datagen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.OrCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import org.jetbrains.annotations.NotNull;
import xxrexraptorxx.advancedtools.items.UpgradeItem;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModItems;
import xxrexraptorxx.advancedtools.registry.ModTags;
import xxrexraptorxx.advancedtools.utils.ToolUtils;
import xxrexraptorxx.advancedtools.utils.enums.Upgrades;
import xxrexraptorxx.magmacore.content.ItemHelper;
import xxrexraptorxx.magmacore.content.TagHelper;

public class RecipeGen
extends RecipeProvider {
    public RecipeGen(HolderLookup.Provider lookupProvider, RecipeOutput recipeOutput) {
        super(lookupProvider, recipeOutput);
    }

    protected void buildRecipes() {
        for (String handle : ModItems.HANDLE_MATERIALS) {
            TagKey rodTag = TagHelper.createItemTag((String)"c", (String)("rods/" + ToolUtils.transformMaterialNames(handle)));
            AdvancedTools.LOGGER.info("Generate Recipes with " + handle + "-handle of tag [" + String.valueOf(rodTag.location()) + "]");
            for (String tool : ModItems.TOOL_TYPES) {
                if (handle.equals("wood")) continue;
                AdvancedTools.LOGGER.info("Try smithing for [" + handle + "_stick_netherite_" + tool + "]");
                this.netheriteSmithing((Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_diamond_" + tool)), (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_netherite_" + tool)), handle);
            }
            for (String head : ModItems.TOOL_HEAD_MATERIALS) {
                if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(head) && handle.equals("wood")) continue;
                TagKey craftingMaterialTag = TagHelper.createItemTag((String)"c", (String)(ToolUtils.transformMaterialNames(head) + "_tool_materials"));
                AdvancedTools.LOGGER.info("Generate Recipes with " + head + "-head of tag [" + String.valueOf(craftingMaterialTag.location()) + "]");
                this.swordRecipe((TagKey<Item>)rodTag, (TagKey<Item>)craftingMaterialTag, head, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_sword")));
                this.axeRecipe((TagKey<Item>)rodTag, (TagKey<Item>)craftingMaterialTag, head, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_axe")));
                this.pickaxeRecipe((TagKey<Item>)rodTag, (TagKey<Item>)craftingMaterialTag, head, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_pickaxe")));
                this.shovelRecipe((TagKey<Item>)rodTag, (TagKey<Item>)craftingMaterialTag, head, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_shovel")));
                this.hoeRecipe((TagKey<Item>)rodTag, (TagKey<Item>)craftingMaterialTag, head, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_hoe")));
            }
        }
        for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
            if (!(item instanceof UpgradeItem)) continue;
            UpgradeItem upgradeItem = (UpgradeItem)item;
            if (item == ModItems.EMPTY_UPGRADE.get()) continue;
            this.upgradeRecipe(upgradeItem);
        }
    }

    public void swordRecipe(TagKey<Item> handleTag, TagKey<Item> headTag, String headMaterial, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handleTag).define(Character.valueOf('X'), headTag).pattern("X").pattern("X").pattern("#").unlockedBy("has_" + headTag.location().getPath(), this.has(headTag)).save(this.output.withConditions(new ICondition[]{this.createTagNotEmptyConditions(headTag, headMaterial, handleTag)}));
    }

    public void pickaxeRecipe(TagKey<Item> handleTag, TagKey<Item> headTag, String headMaterial, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handleTag).define(Character.valueOf('X'), headTag).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_" + headTag.location().getPath(), this.has(headTag)).save(this.output.withConditions(new ICondition[]{this.createTagNotEmptyConditions(headTag, headMaterial, handleTag)}));
    }

    public void axeRecipe(TagKey<Item> handleTag, TagKey<Item> headTag, String headMaterial, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handleTag).define(Character.valueOf('X'), headTag).pattern("XX").pattern("#X").pattern("# ").unlockedBy("has_" + headTag.location().getPath(), this.has(headTag)).save(this.output.withConditions(new ICondition[]{this.createTagNotEmptyConditions(headTag, headMaterial, handleTag)}));
    }

    public void shovelRecipe(TagKey<Item> handleTag, TagKey<Item> headTag, String headMaterial, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handleTag).define(Character.valueOf('X'), headTag).pattern("X").pattern("#").pattern("#").unlockedBy("has_" + headTag.location().getPath(), this.has(headTag)).save(this.output.withConditions(new ICondition[]{this.createTagNotEmptyConditions(headTag, headMaterial, handleTag)}));
    }

    public void hoeRecipe(TagKey<Item> handleTag, TagKey<Item> headTag, String headMaterial, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handleTag).define(Character.valueOf('X'), headTag).pattern("XX").pattern("# ").pattern("# ").unlockedBy("has_" + headTag.location().getPath(), this.has(headTag)).save(this.output.withConditions(new ICondition[]{this.createTagNotEmptyConditions(headTag, headMaterial, handleTag)}));
    }

    public void upgradeRecipe(UpgradeItem result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        TagKey<Item> craftingTag = Upgrades.fromItem(result).get().getCraftingTag();
        this.shapeless(RecipeCategory.MISC, (ItemLike)result).group("advancedtools_upgrades").requires(ModItems.EMPTY_UPGRADE).requires(craftingTag).unlockedBy(RecipeGen.getHasName(ModItems.EMPTY_UPGRADE), this.has((ItemLike)ModItems.EMPTY_UPGRADE)).save(this.output.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(craftingTag))}), "advancedtools:upgrades/" + RecipeGen.getItemName((ItemLike)result));
    }

    @Deprecated
    public void toolRecyclingRecipes() {
        for (String handle : ModItems.HANDLE_MATERIALS) {
            for (String tool : ModItems.TOOL_TYPES) {
                Item result = (Item)BuiltInRegistries.ITEM.getValue(ItemHelper.getLocation((String)"advancedtools", (String)(handle + "_stick_iron_" + tool)));
                AdvancedTools.LOGGER.info("Generate smelting recipes for " + RecipeGen.getItemName((ItemLike)result));
                SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)result), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, (float)0.1f, (int)200).unlockedBy(RecipeGen.getHasName((ItemLike)result), this.has((ItemLike)result)).save(this.output, "advancedtools:smelting/" + handle + "_stick_iron_" + tool);
                SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike)result), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, (float)0.1f, (int)100).unlockedBy(RecipeGen.getHasName((ItemLike)result), this.has((ItemLike)result)).save(this.output, "advancedtools:blasting/" + handle + "_stick_iron_" + tool);
                result = (Item)BuiltInRegistries.ITEM.getValue(ItemHelper.getLocation((String)"advancedtools", (String)(handle + "_stick_gold_" + tool)));
                AdvancedTools.LOGGER.info("Generate smelting recipes for " + RecipeGen.getItemName((ItemLike)result));
                SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)result), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, (float)0.1f, (int)200).unlockedBy(RecipeGen.getHasName((ItemLike)result), this.has((ItemLike)result)).save(this.output, "advancedtools:smelting/" + handle + "_stick_gold_" + tool);
                SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike)result), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, (float)0.1f, (int)100).unlockedBy(RecipeGen.getHasName((ItemLike)result), this.has((ItemLike)result)).save(this.output, "advancedtools:blasting/" + handle + "_stick_gold_" + tool);
            }
        }
    }

    private void netheriteSmithing(Item item, Item result, String conditionalMaterial) {
        AdvancedTools.LOGGER.info("Generate smithing recipe for " + RecipeGen.getItemName((ItemLike)result) + " from " + String.valueOf(item));
        TagKey rodTag = TagHelper.createCItemTag((String)("rods/" + ToolUtils.transformMaterialNames(conditionalMaterial)));
        TagKey craftingMaterialTag = TagHelper.createCItemTag((String)(ToolUtils.transformMaterialNames(conditionalMaterial) + "_tool_materials"));
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)item), (Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_INGOT), (RecipeCategory)RecipeCategory.COMBAT, (Item)result).unlocks("has_netherite_ingot", this.has((ItemLike)Items.NETHERITE_INGOT)).save(this.output.withConditions(new ICondition[]{new AndCondition(List.of(new NotCondition((ICondition)new TagEmptyCondition(rodTag)), new NotCondition((ICondition)new TagEmptyCondition(craftingMaterialTag))))}), "advancedtools:smithing/" + RecipeGen.getItemName((ItemLike)result));
    }

    private static ResourceLocation getItemLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)name);
    }

    @NotNull
    private ICondition createTagNotEmptyConditions(TagKey<Item> mainTag, String baseMaterialName, @Nullable TagKey<Item> optionalTag) {
        ArrayList<Object> andConditions = new ArrayList<Object>();
        andConditions.add(new NotCondition((ICondition)new TagEmptyCondition(mainTag)));
        if (optionalTag != null) {
            andConditions.add(new NotCondition((ICondition)new TagEmptyCondition(optionalTag)));
        }
        List<TagKey<Item>> materialTags = ModTags.getPossibleTagsForMaterial(baseMaterialName);
        ArrayList<NotCondition> materialTagConditions = new ArrayList<NotCondition>();
        for (TagKey<Item> tag : materialTags) {
            materialTagConditions.add(new NotCondition((ICondition)new TagEmptyCondition(tag)));
        }
        if (!materialTagConditions.isEmpty()) {
            andConditions.add(new OrCondition(materialTagConditions));
        }
        return new AndCondition(andConditions);
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
            return new RecipeGen(provider, output);
        }

        public String getName() {
            return "advancedtools_recipes";
        }
    }
}

