/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.registry;

import java.util.Arrays;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import xxrexraptorxx.advancedtools.items.CustomAxeItem;
import xxrexraptorxx.advancedtools.items.CustomBowItem;
import xxrexraptorxx.advancedtools.items.CustomHoeItem;
import xxrexraptorxx.advancedtools.items.CustomPickaxeItem;
import xxrexraptorxx.advancedtools.items.CustomShovelItem;
import xxrexraptorxx.advancedtools.items.CustomSwordItem;
import xxrexraptorxx.advancedtools.items.RodItem;
import xxrexraptorxx.advancedtools.items.UpgradeItem;
import xxrexraptorxx.advancedtools.registry.ModToolMaterials;
import xxrexraptorxx.advancedtools.utils.ToolUtils;

public class ModItems {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"advancedtools");
    public static final DeferredItem<CustomBowItem> IRON_BOW = ITEMS.register("iron_bow", () -> new CustomBowItem(new Item.Properties().durability(500).setId(ModItems.itemId("iron_bow"))));
    public static final DeferredItem<CustomBowItem> GOLD_BOW = ITEMS.register("gold_bow", () -> new CustomBowItem(new Item.Properties().durability(250).setId(ModItems.itemId("gold_bow"))));
    public static final DeferredItem<CustomBowItem> DIAMOND_BOW = ITEMS.register("diamond_bow", () -> new CustomBowItem(new Item.Properties().durability(1560).setId(ModItems.itemId("diamond_bow"))));
    public static final DeferredItem<CustomBowItem> NETHERITE_BOW = ITEMS.register("netherite_bow", () -> new CustomBowItem(new Item.Properties().durability(2030).setId(ModItems.itemId("netherite_bow"))));
    public static final DeferredItem<Item> EMPTY_SOCKET = ITEMS.register("empty_socket", () -> new Item(new Item.Properties().setId(ModItems.itemId("empty_socket"))));
    public static final DeferredItem<UpgradeItem> EMPTY_UPGRADE = ITEMS.register("empty_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("empty_upgrade"))));
    public static final DeferredItem<UpgradeItem> RARITY_UPGRADE = ITEMS.register("rarity_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("rarity_upgrade"))));
    public static final DeferredItem<UpgradeItem> NETHERITE_UPGRADE = ITEMS.register("netherite_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("netherite_upgrade"))));
    public static final DeferredItem<UpgradeItem> OBSIDIAN_UPGRADE = ITEMS.register("obsidian_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("obsidian_upgrade"))));
    public static final DeferredItem<UpgradeItem> KNOCKBACK_UPGRADE = ITEMS.register("knockback_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("knockback_upgrade"))));
    public static final DeferredItem<UpgradeItem> DAMAGE_UPGRADE = ITEMS.register("damage_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("damage_upgrade"))));
    public static final DeferredItem<UpgradeItem> SPEED_UPGRADE = ITEMS.register("speed_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("speed_upgrade"))));
    public static final DeferredItem<UpgradeItem> LUCK_UPGRADE = ITEMS.register("luck_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("luck_upgrade"))));
    public static final DeferredItem<UpgradeItem> EFFICIENCY_UPGRADE = ITEMS.register("efficiency_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("efficiency_upgrade"))));
    public static final DeferredItem<UpgradeItem> UNDERWATER_UPGRADE = ITEMS.register("underwater_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("underwater_upgrade"))));
    public static final DeferredItem<UpgradeItem> ATTACKRANGE_UPGRADE = ITEMS.register("attackrange_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("attackrange_upgrade"))));
    public static final DeferredItem<UpgradeItem> MININGRANGE_UPGRADE = ITEMS.register("miningrange_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("miningrange_upgrade"))));
    public static final DeferredItem<UpgradeItem> SWEEPING_UPGRADE = ITEMS.register("sweeping_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("sweeping_upgrade"))));
    public static final DeferredItem<UpgradeItem> PROTECTION_UPGRADE = ITEMS.register("protection_upgrade", () -> new UpgradeItem(new Item.Properties().setId(ModItems.itemId("protection_upgrade"))));
    public static final String[] TOOL_TYPES = new String[]{"sword", "pickaxe", "axe", "shovel", "hoe"};
    public static final String[] VANILLA_HEAD_MATERIALS = new String[]{"wood", "stone", "iron", "gold", "diamond", "netherite"};
    public static final String[] TOOL_HEAD_MATERIALS = new String[]{"wood", "stone", "iron", "gold", "diamond", "netherite", "obsidian", "bedrock", "steel", "titanium", "quartz", "nickel", "invar", "bone", "electrum", "lumium", "bronze", "constantan", "glowstone", "brass", "peridot", "copper", "signalum", "cinnabar", "redstone", "ruby", "amethyst", "fluorite", "sapphire", "enderium", "emerald", "prismarine", "uranium", "osmium", "aluminum", "platinum", "silver", "cobalt", "lead", "tin", "zinc"};
    public static final String[] HANDLE_MATERIALS;

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
    }

    public static ResourceKey<Item> itemId(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)name));
    }

    static {
        for (String handle : HANDLE_MATERIALS = new String[]{"witherbone", "obsidian", "highcarbonblacksteel", "blacksteel", "carbon", "netherite", "blastproofalloy", "darksteel", "weaksteel", "graphite", "bedrock", "compressediron", "pigiron", "silicon", "steel", "antimony", "iron", "wroughtiron", "titanium", "stone", "iridium", "quartz", "sterlingsilver", "nickel", "invar", "bone", "plastic", "energizedgold", "electrum", "anglesite", "lumium", "blaze", "allthemodium", "bronze", "constantan", "glowstone", "brass", "gold", "topaz", "pyrite", "kanthal", "peridot", "yellorium", "cadmium", "wood", "advancedalloy", "soularium", "solarium", "manganese", "cupronickel", "copper", "energizedcopper", "rosegold", "energeticalloy", "signalum", "horizonite", "cinnabar", "redstone", "infusedalloy", "ventium", "pyrope", "weakredsteel", "highcarbonredsteel", "redsteel", "inanite", "ruby", "plutonium", "tungsten", "duratium", "blackbronze", "amethyst", "ludicrite", "energite", "elementium", "magentite", "enchanted", "unobtainium", "fluix", "thorium", "zanite", "charoite", "atomicalloy", "pinkslime", "ridiculite", "fluorite", "falsite", "superconductor", "apatite", "certusquartzcrystal", "cyanite", "benitoite", "reinforcedalloy", "opal", "breeze", "aquite", "adamant", "manasteel", "sapphire", "blutonium", "highcarbonbluesteel", "bluesteel", "weakbluesteel", "highcarbonsteel", "enderium", "diamond", "biosteel", "beryllium", "emerald", "terrasteel", "diopside", "endercrystal", "insanite", "vibranium", "pulsatingalloy", "bismuthbronze", "bismuth", "prismarine", "uranium", "vibrantalloy", "endsteel", "end", "osmium", "aluminum", "platinum", "silver", "cobalt", "lead", "stainlesssteel", "tin", "zinc", "blitz", "certusquartz", "blizz", "advanced", "netheriteiron", "netheritediamond", "netheriteemerald", "netheritegold", "basalz"}) {
            if (!ToolUtils.isRod(handle)) {
                ITEMS.register("stick_" + handle, () -> new RodItem(new Item.Properties().setId(ModItems.itemId("stick_" + handle))));
            }
            for (String head : TOOL_HEAD_MATERIALS) {
                if (Arrays.asList(VANILLA_HEAD_MATERIALS).contains(head) && handle.equals("wood")) continue;
                ITEMS.registerItem(handle + "_stick_" + head + "_sword", props -> new CustomSwordItem(ModToolMaterials.getMaterial(handle, head), 3.0f, -4.0f + ModToolMaterials.getSpeed(head, "sword"), (Item.Properties)props));
                ITEMS.registerItem(handle + "_stick_" + head + "_pickaxe", props -> new CustomPickaxeItem(ModToolMaterials.getMaterial(handle, head), 1.0f, -4.0f + ModToolMaterials.getSpeed(head, "pickaxe"), (Item.Properties)props));
                ITEMS.registerItem(handle + "_stick_" + head + "_axe", props -> new CustomAxeItem(ModToolMaterials.getMaterial(handle, head), 6.0f, -4.0f + ModToolMaterials.getSpeed(head, "axe"), (Item.Properties)props));
                ITEMS.registerItem(handle + "_stick_" + head + "_shovel", props -> new CustomShovelItem(ModToolMaterials.getMaterial(handle, head), 1.5f, -4.0f + ModToolMaterials.getSpeed(head, "shovel"), (Item.Properties)props));
                ITEMS.registerItem(handle + "_stick_" + head + "_hoe", props -> new CustomHoeItem(ModToolMaterials.getMaterial(handle, head), 0.0f, -4.0f + ModToolMaterials.getSpeed(head, "hoe"), (Item.Properties)props));
            }
        }
    }
}

