/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.utils.Config;
import xxrexraptorxx.advancedtools.utils.ToolUtils;
import xxrexraptorxx.magmacore.content.TagHelper;

public class ModTags {
    public static boolean isTagValidAndHasMatchingItems(String material) {
        if (Minecraft.getInstance().level != null) {
            RegistryAccess lookupProvider = Minecraft.getInstance().level.registryAccess();
            List<TagKey<Item>> tagKeys = ModTags.getPossibleTagsForMaterial(material);
            if (Config.getDebugMode()) {
                AdvancedTools.LOGGER.info("Searching for items of material [" + ToolUtils.transformMaterialNames(material) + "] in multiple possible tags");
            }
            for (TagKey<Item> tagKey : tagKeys) {
                HolderLookup holderLookup;
                Optional tagEntries;
                Optional lookup = lookupProvider.lookup(BuiltInRegistries.ITEM.key());
                if (Config.getDebugMode()) {
                    AdvancedTools.LOGGER.info("Checking tag [" + String.valueOf(tagKey.location()) + "]");
                }
                if (!lookup.isPresent() || !(tagEntries = (holderLookup = (HolderLookup)lookup.get()).get(tagKey)).isPresent() || !((HolderSet.Named)tagEntries.get()).isBound()) continue;
                for (Holder itemHolder : (HolderSet.Named)tagEntries.get()) {
                    ResourceLocation itemName = BuiltInRegistries.ITEM.getKey((Object)((Item)itemHolder.value()));
                    if (Config.getDebugMode()) {
                        AdvancedTools.LOGGER.info("Entry found: " + String.valueOf(itemName));
                    }
                    if (!BuiltInRegistries.ITEM.containsKey(itemName)) continue;
                    if (Config.getDebugMode()) {
                        AdvancedTools.LOGGER.info("Item is registered!");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isTagContainedInAnother(TagKey<Block> innerTag, TagKey<Block> outerTag) {
        if (Config.getDebugMode()) {
            AdvancedTools.LOGGER.info("Compare if block tag [" + String.valueOf(innerTag.location()) + "] is in [" + String.valueOf(outerTag.location()) + "]");
        }
        if (Minecraft.getInstance().level != null) {
            Registry blockLookup = Minecraft.getInstance().level.registryAccess().lookupOrThrow(Registries.BLOCK);
            HolderSet.Named innerSet = blockLookup.getOrThrow(innerTag);
            HolderSet.Named outerSet = blockLookup.getOrThrow(outerTag);
            return innerSet.stream().anyMatch(arg_0 -> ((HolderSet.Named)outerSet).contains(arg_0));
        }
        return false;
    }

    public static List<TagKey<Item>> getPossibleTagsForMaterial(String material) {
        ArrayList<TagKey<Item>> tags = new ArrayList<TagKey<Item>>();
        if (ToolUtils.isSpecial(material = ToolUtils.transformMaterialNames(material))) {
            if (material.equals("wither_bone")) {
                tags.add(TagHelper.createCItemTag((String)"bones/wither"));
            } else if (material.equals("bone")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"bones/regular"));
            } else if (material.equals("carbon")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"plates/carbon"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/carbon"));
            } else if (material.equals("plastic")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"pellets/plastic"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"plastic_sheets"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"plastic"));
            } else if (material.equals("silicon")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"silicon"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/silicon"));
            } else if (material.equals("bedrock")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/bedrock"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/bedrock_alloy"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/refined_bedrock"));
            } else if (material.equals("redstone")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/redstone"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/refined_redstone"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/redstone_alloy"));
            } else if (material.equals("glowstone")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/glowstone"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/refined_glowstone"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/glowstone_alloy"));
            } else if (material.equals("obsidian")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/obsidian"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/obsidian_alloy"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/refined_obsidian"));
            } else if (material.equals("superconductor")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/superconductor"));
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"ingots/superconductor_alloy"));
            } else if (material.equals("wood") || material.equals("wooden")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"wooden_tool_materials"));
            } else if (material.equals("stone")) {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)"stone_tool_materials"));
            } else {
                tags.add((TagKey<Item>)TagHelper.createCItemTag((String)("rods/" + material)));
            }
        } else if (ToolUtils.isGem(material)) {
            tags.add(TagHelper.createCItemTag((String)("gems/" + material)));
        } else {
            tags.add(TagHelper.createCItemTag((String)("ingots/" + material)));
        }
        return tags;
    }
}

