/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.registry;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ToolMaterial;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModItems;
import xxrexraptorxx.advancedtools.utils.ToolUtils;
import xxrexraptorxx.advancedtools.utils.enums.Materials;
import xxrexraptorxx.magmacore.content.TagHelper;

public class ModToolMaterials {
    public static final Map<String, ToolMaterial> TOOL_MATERIALS = new HashMap<String, ToolMaterial>();
    public static final Map<String, Float> SPEED_MAP = new HashMap<String, Float>();
    public static final Map<ToolMaterial, String> MATERIAL_KEYS = new HashMap<ToolMaterial, String>();
    public static final float WOOD_SWORD_SPEED = 1.6f;
    public static final float WOOD_PICKAXE_SPEED = 1.2f;
    public static final float WOOD_AXE_SPEED = 0.8f;
    public static final float WOOD_SHOVEL_SPEED = 1.0f;
    public static final float WOOD_HOE_SPEED = 1.0f;
    public static final float STONE_SWORD_SPEED = 1.6f;
    public static final float STONE_PICKAXE_SPEED = 1.2f;
    public static final float STONE_AXE_SPEED = 0.8f;
    public static final float STONE_SHOVEL_SPEED = 1.0f;
    public static final float STONE_HOE_SPEED = 2.0f;
    public static final float IRON_SWORD_SPEED = 1.6f;
    public static final float IRON_PICKAXE_SPEED = 1.2f;
    public static final float IRON_AXE_SPEED = 0.9f;
    public static final float IRON_SHOVEL_SPEED = 1.0f;
    public static final float IRON_HOE_SPEED = 3.0f;
    public static final float GOLD_SWORD_SPEED = 1.6f;
    public static final float GOLD_PICKAXE_SPEED = 1.2f;
    public static final float GOLD_AXE_SPEED = 1.0f;
    public static final float GOLD_SHOVEL_SPEED = 1.0f;
    public static final float GOLD_HOE_SPEED = 1.0f;
    public static final float DIAMOND_SWORD_SPEED = 1.6f;
    public static final float DIAMOND_PICKAXE_SPEED = 1.2f;
    public static final float DIAMOND_AXE_SPEED = 1.0f;
    public static final float DIAMOND_SHOVEL_SPEED = 1.0f;
    public static final float DIAMOND_HOE_SPEED = 4.0f;
    public static final float NETHERITE_SWORD_SPEED = 1.6f;
    public static final float NETHERITE_PICKAXE_SPEED = 1.2f;
    public static final float NETHERITE_AXE_SPEED = 1.0f;
    public static final float NETHERITE_SHOVEL_SPEED = 1.0f;
    public static final float NETHERITE_HOE_SPEED = 4.0f;

    public static void registerToolMaterials() {
        TOOL_MATERIALS.put("wood_wood", ToolMaterial.WOOD);
        TOOL_MATERIALS.put("stone_wood", ToolMaterial.STONE);
        TOOL_MATERIALS.put("iron_wood", ToolMaterial.IRON);
        TOOL_MATERIALS.put("gold_wood", ToolMaterial.GOLD);
        TOOL_MATERIALS.put("diamond_wood", ToolMaterial.DIAMOND);
        TOOL_MATERIALS.put("netherite_wood", ToolMaterial.NETHERITE);
        for (String handle : ModItems.HANDLE_MATERIALS) {
            for (String base : ModItems.TOOL_HEAD_MATERIALS) {
                Materials handleMaterial = Materials.fromName(handle).orElseThrow(() -> new IllegalArgumentException("Unknown material: " + handle));
                Materials baseMaterial = Materials.fromName(base).orElseThrow(() -> new IllegalArgumentException("Unknown material: " + base));
                ModToolMaterials.addMaterial(baseMaterial.getRegistryName(), handleMaterial.getRegistryName(), baseMaterial.getUses(), handleMaterial.getUses(), baseMaterial.getSpeed(), handleMaterial.getSpeed(), baseMaterial.getDamage(), handleMaterial.getDamage(), baseMaterial.getEnchantability(), handleMaterial.getEnchantability());
            }
        }
        TOOL_MATERIALS.forEach((key, mat) -> MATERIAL_KEYS.put((ToolMaterial)mat, (String)key));
    }

    private static void addMaterial(String baseName, String handleName, int baseUses, int handleUses, float baseSpeed, float handleSpeed, float baseDamage, float handleDamage, int baseEnchantability, int handleEnchantability) {
        String materialName = baseName + "_" + handleName;
        ToolMaterial material = new ToolMaterial(TagHelper.createCBlockTag((String)("incorrect_for_" + ToolUtils.transformMaterialNames(baseName) + "_tool")), baseUses * 3 + handleUses * 2, baseSpeed * 3.0f + handleSpeed * 2.0f, baseDamage * 3.0f + handleDamage * 2.0f, baseEnchantability * 3 + handleEnchantability * 2, TagHelper.createCItemTag((String)(ToolUtils.transformMaterialNames(baseName) + "_tool_materials")));
        TOOL_MATERIALS.put(materialName, material);
    }

    public static ToolMaterial getMaterial(String name) {
        return TOOL_MATERIALS.get(name);
    }

    public static ToolMaterial getMaterial(String handleMaterial, String headMaterial) {
        String toolMaterial = headMaterial + "_" + handleMaterial;
        return TOOL_MATERIALS.get(toolMaterial);
    }

    @Deprecated
    public static float getSpeed(String handleMaterial, String baseMaterial, String toolType) {
        String key = handleMaterial.toLowerCase() + "_stick_" + baseMaterial.toLowerCase() + "_" + toolType.toLowerCase();
        Float speed = SPEED_MAP.get(key);
        if (speed == null) {
            AdvancedTools.LOGGER.error("No speed value set for " + key);
        }
        return SPEED_MAP.getOrDefault(key, Float.valueOf(2.0f)).floatValue();
    }

    public static float getSpeed(String baseMaterial, String toolType) {
        String key = baseMaterial.toLowerCase() + "_" + toolType.toLowerCase();
        Float speed = SPEED_MAP.get(key);
        if (speed == null) {
            String lowerKey = key.toLowerCase();
            if (lowerKey.contains("sword")) {
                return 1.6f;
            }
            if (lowerKey.contains("pickaxe")) {
                return 1.2f;
            }
            if (lowerKey.contains("hoe")) {
                return 3.0f;
            }
            if (lowerKey.contains("axe")) {
                return 0.9f;
            }
            if (lowerKey.contains("shovel")) {
                return 1.0f;
            }
            AdvancedTools.LOGGER.error("No speed value set for " + key);
            return 2.0f;
        }
        return speed.floatValue();
    }

    public static Pair<String, String> getPartsFromToolMaterial(ToolMaterial material) {
        String key = MATERIAL_KEYS.get(material);
        if (key == null) {
            throw new IllegalArgumentException("Unknown material: " + String.valueOf(material));
        }
        String[] parts = key.split("_", 2);
        return Pair.of((Object)parts[0], (Object)parts[1]);
    }

    public static String getHeadFromToolMaterial(ToolMaterial material) {
        return (String)ModToolMaterials.getPartsFromToolMaterial(material).getFirst();
    }

    public static String getHandleFromToolMaterial(ToolMaterial material) {
        return (String)ModToolMaterials.getPartsFromToolMaterial(material).getSecond();
    }

    static {
        SPEED_MAP.put("wood_sword", Float.valueOf(1.6f));
        SPEED_MAP.put("wood_pickaxe", Float.valueOf(1.2f));
        SPEED_MAP.put("wood_axe", Float.valueOf(0.8f));
        SPEED_MAP.put("wood_shovel", Float.valueOf(1.0f));
        SPEED_MAP.put("wood_hoe", Float.valueOf(1.0f));
        SPEED_MAP.put("stone_sword", Float.valueOf(1.6f));
        SPEED_MAP.put("stone_pickaxe", Float.valueOf(1.2f));
        SPEED_MAP.put("stone_axe", Float.valueOf(0.8f));
        SPEED_MAP.put("stone_shovel", Float.valueOf(1.0f));
        SPEED_MAP.put("stone_hoe", Float.valueOf(2.0f));
        SPEED_MAP.put("iron_sword", Float.valueOf(1.6f));
        SPEED_MAP.put("iron_pickaxe", Float.valueOf(1.2f));
        SPEED_MAP.put("iron_axe", Float.valueOf(0.9f));
        SPEED_MAP.put("iron_shovel", Float.valueOf(1.0f));
        SPEED_MAP.put("iron_hoe", Float.valueOf(3.0f));
        SPEED_MAP.put("gold_sword", Float.valueOf(1.6f));
        SPEED_MAP.put("gold_pickaxe", Float.valueOf(1.2f));
        SPEED_MAP.put("gold_axe", Float.valueOf(1.0f));
        SPEED_MAP.put("gold_shovel", Float.valueOf(1.0f));
        SPEED_MAP.put("gold_hoe", Float.valueOf(1.0f));
        SPEED_MAP.put("diamond_sword", Float.valueOf(1.6f));
        SPEED_MAP.put("diamond_pickaxe", Float.valueOf(1.2f));
        SPEED_MAP.put("diamond_axe", Float.valueOf(1.0f));
        SPEED_MAP.put("diamond_shovel", Float.valueOf(1.0f));
        SPEED_MAP.put("diamond_hoe", Float.valueOf(4.0f));
        SPEED_MAP.put("netherite_sword", Float.valueOf(1.6f));
        SPEED_MAP.put("netherite_pickaxe", Float.valueOf(1.2f));
        SPEED_MAP.put("netherite_axe", Float.valueOf(1.0f));
        SPEED_MAP.put("netherite_shovel", Float.valueOf(1.0f));
        SPEED_MAP.put("netherite_hoe", Float.valueOf(4.0f));
    }
}

