/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.utils;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.block.Block;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModToolMaterials;
import xxrexraptorxx.advancedtools.utils.ToolUtils;
import xxrexraptorxx.advancedtools.utils.enums.Materials;
import xxrexraptorxx.advancedtools.utils.enums.ToolMaterialStatTypes;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

public class FormattingUtils {
    public static final String AT_INFIX = "_stick_";

    public static Component getHandleEffectNamesFromMaterial(String material) {
        if (ToolUtils.getHandleMaterialRandomEffect(material) != null) {
            MobEffect effect = (MobEffect)ToolUtils.getHandleMaterialRandomEffect(material).getEffect().value();
            return FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"random").append(" " + effect.getDisplayName().getString()).withStyle(FormattingUtils.getMobEffectFormatting(effect));
        }
        if (ToolUtils.getHandleMaterialEffect(material) != null) {
            MobEffect effect = (MobEffect)ToolUtils.getHandleMaterialEffect(material).getEffect().value();
            return Component.literal((String)effect.getDisplayName().getString()).withStyle(FormattingUtils.getMobEffectFormatting(effect));
        }
        return Component.literal((String)"      /").withStyle(ChatFormatting.RED);
    }

    public static Component getHeadEffectNamesFromMaterial(String material) {
        if (ToolUtils.getHeadMaterialRandomEffect(material) != null) {
            MobEffect effect = (MobEffect)ToolUtils.getHeadMaterialRandomEffect(material).getEffect().value();
            return FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"random").append(" " + effect.getDisplayName().getString()).withStyle(FormattingUtils.getMobEffectFormatting(effect));
        }
        if (ToolUtils.getHeadMaterialEffect(material) != null) {
            MobEffect effect = (MobEffect)ToolUtils.getHeadMaterialEffect(material).getEffect().value();
            return Component.literal((String)effect.getDisplayName().getString()).withStyle(FormattingUtils.getMobEffectFormatting(effect));
        }
        return Component.literal((String)"        /").withStyle(ChatFormatting.RED);
    }

    public static int getMiningLevel(ToolMaterial material) {
        Materials headMaterial = Materials.fromName(ModToolMaterials.getHeadFromToolMaterial(material)).orElseThrow(() -> new IllegalArgumentException("Unknown material: " + material.toString()));
        TagKey<Block> tag = headMaterial.getIncorrectForMaterialKey();
        if (tag.equals((Object)BlockTags.INCORRECT_FOR_NETHERITE_TOOL)) {
            return 4;
        }
        if (tag.equals((Object)BlockTags.INCORRECT_FOR_DIAMOND_TOOL)) {
            return 3;
        }
        if (tag.equals((Object)BlockTags.INCORRECT_FOR_IRON_TOOL)) {
            return 2;
        }
        if (tag.equals((Object)BlockTags.INCORRECT_FOR_STONE_TOOL)) {
            return 1;
        }
        if (tag.equals((Object)BlockTags.INCORRECT_FOR_WOODEN_TOOL) || tag.equals((Object)BlockTags.INCORRECT_FOR_GOLD_TOOL)) {
            return 0;
        }
        AdvancedTools.LOGGER.error("Unknown 'harvest'- block tag: " + String.valueOf(tag.location()));
        return 2;
    }

    public static ChatFormatting getToolStatsFormatting(ToolMaterial material, ToolMaterialStatTypes type) {
        ChatFormatting bad = ChatFormatting.DARK_RED;
        ChatFormatting okay = ChatFormatting.RED;
        ChatFormatting normal = ChatFormatting.YELLOW;
        ChatFormatting good = ChatFormatting.GREEN;
        ChatFormatting top = ChatFormatting.DARK_GREEN;
        switch (type) {
            case MINING_LEVEL: {
                if (FormattingUtils.getMiningLevel(material) <= 0) {
                    return bad;
                }
                if (FormattingUtils.getMiningLevel(material) == 1) {
                    return okay;
                }
                if (FormattingUtils.getMiningLevel(material) == 2) {
                    return normal;
                }
                if (FormattingUtils.getMiningLevel(material) == 3) {
                    return good;
                }
                return top;
            }
            case DURABILITY: {
                if (material.durability() < 200) {
                    return bad;
                }
                if (material.durability() < 600) {
                    return okay;
                }
                if (material.durability() < 2000) {
                    return normal;
                }
                if (material.durability() < 3000) {
                    return good;
                }
                return top;
            }
            case DAMAGE: {
                if ((double)material.attackDamageBonus() < 1.5) {
                    return bad;
                }
                if ((double)material.attackDamageBonus() < 2.5) {
                    return okay;
                }
                if (material.attackDamageBonus() < 4.0f) {
                    return normal;
                }
                if ((double)material.attackDamageBonus() < 5.5) {
                    return good;
                }
                return top;
            }
            case MINING_SPEED: {
                if ((double)material.speed() < 2.5) {
                    return bad;
                }
                if ((double)material.speed() < 4.0) {
                    return okay;
                }
                if ((double)material.speed() < 7.0) {
                    return normal;
                }
                if ((double)material.speed() < 10.0) {
                    return good;
                }
                return top;
            }
            case ENCHANTABILITY: {
                if (material.enchantmentValue() < 8) {
                    return bad;
                }
                if (material.enchantmentValue() < 15) {
                    return okay;
                }
                if (material.enchantmentValue() < 25) {
                    return normal;
                }
                if (material.enchantmentValue() < 32) {
                    return good;
                }
                return top;
            }
            case SOCKETS: {
                Materials headMaterial = Materials.fromName(ModToolMaterials.getHeadFromToolMaterial(material)).orElseThrow(() -> new IllegalArgumentException("Unknown material: " + material.toString()));
                Materials handleMaterial = Materials.fromName(ModToolMaterials.getHandleFromToolMaterial(material)).orElseThrow(() -> new IllegalArgumentException("Unknown material: " + material.toString()));
                if (handleMaterial.getUpgradeSlots() + headMaterial.getUpgradeSlots() < 2) {
                    return bad;
                }
                if (handleMaterial.getUpgradeSlots() + headMaterial.getUpgradeSlots() < 3) {
                    return okay;
                }
                if (handleMaterial.getUpgradeSlots() + headMaterial.getUpgradeSlots() < 4) {
                    return normal;
                }
                if (handleMaterial.getUpgradeSlots() + headMaterial.getUpgradeSlots() < 6) {
                    return good;
                }
                return top;
            }
            case ATTACK_SPEED: {
                AdvancedTools.LOGGER.error("Not yet implemented!");
                return normal;
            }
        }
        AdvancedTools.LOGGER.error("Error with material: " + String.valueOf(material));
        return normal;
    }

    private static ChatFormatting getMobEffectFormatting(MobEffect effect) {
        if (effect.getCategory().equals((Object)MobEffectCategory.HARMFUL)) {
            return ChatFormatting.DARK_RED;
        }
        if (effect.getCategory().equals((Object)MobEffectCategory.BENEFICIAL)) {
            return ChatFormatting.GREEN;
        }
        return ChatFormatting.YELLOW;
    }
}

