/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import xxrexraptorxx.advancedtools.items.UpgradeItem;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModComponents;
import xxrexraptorxx.advancedtools.utils.enums.Upgrades;
import xxrexraptorxx.advancedtools.utils.sockets.ISocketTool;

public class SocketUtils {
    public static final String SEPARATOR = ";";
    public static final String EMPTY_SLOT = Items.AIR.toString();
    public static final String EMPTY_STACK = EMPTY_SLOT + ";1";

    public static void setSockets(ItemStack stack, List<String> socketStrings) {
        stack.set((DataComponentType)ModComponents.SOCKETS.value(), socketStrings);
    }

    public static List<String> getSockets(ItemStack stack) {
        return (List)stack.get((DataComponentType)ModComponents.SOCKETS.value());
    }

    public static String serializeItemStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return EMPTY_STACK;
        }
        return String.valueOf(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())) + SEPARATOR + stack.getCount();
    }

    public static ItemStack deserializeItemStack(String entry) {
        String[] parts = entry.split(SEPARATOR);
        if (parts.length != 2) {
            return ItemStack.EMPTY;
        }
        ResourceLocation id = ResourceLocation.parse((String)parts[0]);
        int count = Integer.parseInt(parts[1]);
        Item item = (Item)BuiltInRegistries.ITEM.getValue(id);
        if (item == null) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)item, count);
    }

    public static List<String> toStringList(List<ItemStack> stacks) {
        return stacks.stream().map(SocketUtils::serializeItemStack).toList();
    }

    public static List<ItemStack> fromStringList(List<String> entries) {
        return entries.stream().map(SocketUtils::deserializeItemStack).toList();
    }

    public static boolean hasSockets(ItemStack stack) {
        return stack.has((DataComponentType)ModComponents.SOCKETS.get());
    }

    public static boolean hasEmptySocket(ItemStack stack) {
        if (!SocketUtils.hasSockets(stack)) {
            return false;
        }
        List sockets = (List)stack.get((DataComponentType)ModComponents.SOCKETS.get());
        return sockets.stream().anyMatch(s -> s.startsWith(EMPTY_SLOT));
    }

    public static boolean allSocketsEmpty(ItemStack stack) {
        if (!SocketUtils.hasSockets(stack)) {
            return false;
        }
        List sockets = (List)stack.get((DataComponentType)ModComponents.SOCKETS.get());
        return sockets.stream().allMatch(s -> s.startsWith(EMPTY_SLOT));
    }

    public static boolean insertOrStackUpgrade(ItemStack tool, ItemStack upgrade) {
        ItemStack s;
        int i;
        Item item = tool.getItem();
        if (!(item instanceof ISocketTool)) {
            return false;
        }
        ISocketTool socketTool = (ISocketTool)item;
        Item item2 = upgrade.getItem();
        if (!(item2 instanceof UpgradeItem)) {
            return false;
        }
        UpgradeItem upItem = (UpgradeItem)item2;
        AdvancedTools.LOGGER.info("Try to place a " + String.valueOf((Object)upItem) + " into a " + String.valueOf(tool.getItem()));
        int maxSlots = socketTool.getSocketCount(tool);
        ArrayList<String> raw = new ArrayList<String>(SocketUtils.getSockets(tool));
        String empty = SocketUtils.serializeItemStack(ItemStack.EMPTY);
        while (raw.size() < maxSlots) {
            raw.add(empty);
        }
        if (raw.size() > maxSlots) {
            raw = new ArrayList(raw.subList(0, maxSlots));
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(SocketUtils.fromStringList(raw));
        AdvancedTools.LOGGER.info("Old socket list: " + String.valueOf(SocketUtils.toStringList(stacks)));
        int maxCount = Upgrades.fromItem(upItem).get().getMaxCount();
        for (i = 0; i < stacks.size(); ++i) {
            s = (ItemStack)stacks.get(i);
            if (s.getItem() != upgrade.getItem() || s.getCount() >= maxCount) continue;
            s.grow(1);
            SocketUtils.setSockets(tool, SocketUtils.toStringList(stacks));
            AdvancedTools.LOGGER.info("New socket list: " + String.valueOf(SocketUtils.toStringList(stacks)));
            return true;
        }
        for (i = 0; i < stacks.size(); ++i) {
            s = (ItemStack)stacks.get(i);
            if (!s.isEmpty() && s.getItem() != Items.AIR) continue;
            stacks.set(i, new ItemStack((ItemLike)upgrade.getItem(), 1));
            SocketUtils.setSockets(tool, SocketUtils.toStringList(stacks));
            AdvancedTools.LOGGER.info("New socket list: " + String.valueOf(SocketUtils.toStringList(stacks)));
            return true;
        }
        AdvancedTools.LOGGER.info("No free sockets!");
        return false;
    }

    public static void setAttributes(ItemStack stack, Holder<Attribute> attribute, float amount) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        AttributeModifier attackDamageModifier = new AttributeModifier(ResourceLocation.parse((String)attribute.getRegisteredName()), (double)amount, AttributeModifier.Operation.ADD_VALUE);
        ItemAttributeModifiers newModifiers = modifiers.withModifierAdded(attribute, attackDamageModifier, EquipmentSlotGroup.MAINHAND);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)newModifiers);
    }
}

