/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.utils;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ToolMaterial;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModItems;
import xxrexraptorxx.advancedtools.registry.ModTags;
import xxrexraptorxx.advancedtools.registry.ModToolMaterials;
import xxrexraptorxx.advancedtools.utils.Config;
import xxrexraptorxx.advancedtools.utils.FormattingUtils;
import xxrexraptorxx.advancedtools.utils.enums.Materials;
import xxrexraptorxx.advancedtools.utils.enums.ToolMaterialStatTypes;
import xxrexraptorxx.magmacore.utils.FormattingHelper;

public class ToolUtils {
    private static final Pattern MODDED_NAME_PATTERN = Pattern.compile("^([a-zA-Z0-9]+)_stick_([a-zA-Z0-9]+)_([a-zA-Z0-9]+)$");
    private static final Pattern VANILLA_NAME_PATTERN = Pattern.compile("^([a-zA-Z0-9]+)_([a-zA-Z0-9]+)$");
    private static final Pattern TM_NAME_PATTERN = Pattern.compile("^([a-zA-Z0-9]+)_([a-zA-Z0-9]+)$");

    public static String getStickFromName(Item item) {
        String name = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        if (BuiltInRegistries.ITEM.getKey((Object)item).getNamespace().equals("minecraft")) {
            return FormattingHelper.setModLangComponent((String)"item", (String)"advancedtools", (String)"stick_wood").getString();
        }
        String handle = Objects.requireNonNull(ToolUtils.getPartsFromTool(name))[0];
        if (ToolUtils.isVanillaRod(handle)) {
            if (handle.equals("end")) {
                return FormattingHelper.setModLangComponent((String)"block", (String)"minecraft", (String)(handle + "_rod")).getString();
            }
            return FormattingHelper.setModLangComponent((String)"item", (String)"minecraft", (String)(handle + "_rod")).getString();
        }
        return FormattingHelper.setModLangComponent((String)"item", (String)"advancedtools", (String)("stick_" + handle)).getString();
    }

    public static String[] getPartsFromTool(String toolName) {
        Matcher modMatcher = MODDED_NAME_PATTERN.matcher(toolName);
        if (modMatcher.matches()) {
            return new String[]{modMatcher.group(1), modMatcher.group(2), modMatcher.group(3)};
        }
        Matcher vanillaMatcher = VANILLA_NAME_PATTERN.matcher(toolName);
        if (vanillaMatcher.matches()) {
            String headMaterial = vanillaMatcher.group(1);
            String toolType = vanillaMatcher.group(2);
            return new String[]{"wood", headMaterial, toolType};
        }
        AdvancedTools.LOGGER.error("Invalid input: " + toolName);
        return null;
    }

    public static String getBaseMaterialFromVanillaItem(String name) {
        if ((name = name.replace("wooden", "wood").replace("golden", "gold")).contains("_sword")) {
            return name.replace("_sword", "");
        }
        if (name.contains("_pickaxe")) {
            return name.replace("_pickaxe", "");
        }
        if (name.contains("_axe")) {
            return name.replace("_axe", "");
        }
        if (name.contains("_shovel")) {
            return name.replace("_shovel", "");
        }
        if (name.contains("hoe")) {
            return name.replace("_hoe", "");
        }
        AdvancedTools.LOGGER.error("Invalid input: " + name);
        return null;
    }

    public static Component getToolTranslationKey(Item item) {
        String itemName = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        String handleMaterial = Objects.requireNonNull(ToolUtils.getPartsFromTool(itemName))[0];
        String headMaterial = Objects.requireNonNull(ToolUtils.getPartsFromTool(itemName))[1];
        String toolType = Objects.requireNonNull(ToolUtils.getPartsFromTool(itemName))[2];
        if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(headMaterial) && handleMaterial.equals("wood")) {
            if (headMaterial.equals("wood")) {
                headMaterial = "wooden";
            } else if (headMaterial.equals("gold")) {
                headMaterial = "golden";
            }
            String vanillaItemName = headMaterial + "_" + toolType;
            Item vanillaItem = BuiltInRegistries.ITEM.getOptional(ResourceLocation.withDefaultNamespace((String)vanillaItemName)).orElse(Items.AIR);
            if (vanillaItem == Items.AIR) {
                AdvancedTools.LOGGER.error("Invalid item! [" + String.valueOf(item) + "]");
            }
            return Component.translatable((String)vanillaItem.getDescriptionId());
        }
        return FormattingHelper.setModLangComponent((String)"material", (String)"advancedtools", (String)headMaterial).append(" ").append((Component)FormattingHelper.setModLangComponent((String)"tooltype", (String)"advancedtools", (String)toolType));
    }

    public static boolean isGem(String material) {
        return switch (material) {
            case "diamond", "emerald", "amethyst", "quartz", "topaz", "peridot", "ruby", "sapphire", "certusquartz", "fluorite", "cinnabar", "apatite", "aquite", "certusquartzcrystal", "charoite", "diopside", "fluix", "prismarine", "pyrope", "opal", "anglesite", "benitoite", "zanite", "endercrystal", "pyrite" -> true;
            default -> false;
        };
    }

    public static boolean isSpecial(String material) {
        return switch (material) {
            case "advanced", "enchanted", "bone", "witherbone", "end", "blaze", "breeze", "basalz", "blizz", "blitz", "carbon", "plastic", "glowstone", "redstone", "superconductor", "obsidian", "bedrock", "silicon", "wood", "wooden", "stone" -> true;
            default -> false;
        };
    }

    public static boolean isRod(String material) {
        return switch (material) {
            case "end", "blaze", "breeze", "basalz", "blizz", "blitz", "wood", "stick" -> true;
            default -> false;
        };
    }

    public static boolean isVanillaRod(String material) {
        return switch (material) {
            case "end", "blaze", "breeze" -> true;
            default -> false;
        };
    }

    public static boolean isFireResistant(String material) {
        return switch (material) {
            case "netherite", "netheriteiron", "netheritegold", "netheritediamond", "netheriteemerald", "bedrock", "obsidian", "allthemodium", "vibranium", "unobtainium" -> true;
            default -> false;
        };
    }

    public static boolean isValidRodForCreative(String rod) {
        if (Config.getForceAllMaterials()) {
            return true;
        }
        return Config.getHandleMaterials().contains(rod) && ModTags.isTagValidAndHasMatchingItems(rod);
    }

    public static boolean isValidForCreative(String head, String handle) {
        if (Config.getForceAllMaterials()) {
            return true;
        }
        return Config.getHandleMaterials().contains(handle) && Config.getToolHeadMaterials().contains(head) && ModTags.isTagValidAndHasMatchingItems(handle) && ModTags.isTagValidAndHasMatchingItems(head);
    }

    public static boolean isToolType(String path) {
        return path.contains("pickaxe") || path.contains("axe") || path.contains("sword") || path.contains("shovel") || path.contains("hoe");
    }

    public static boolean excludedMods(String namespace) {
        return namespace.equals("tconstruct") || namespace.equals("silentgems") || namespace.equals("tetra");
    }

    public static String transformMaterialNames(String material) {
        if (material.equals("certusquartz")) {
            material = "certus_quartz";
        }
        if (material.equals("witherbone")) {
            material = "wither_bone";
        }
        if (material.equals("blastproofalloy")) {
            material = "blast_proofalloy";
        }
        if (material.equals("certusquartzcrystal")) {
            material = "certus_quartz_crystal";
        }
        if (material.equals("darksteel")) {
            material = "dark_steel";
        }
        if (material.equals("endsteel")) {
            material = "end_steel";
        }
        if (material.equals("energizedcopper")) {
            material = "energized_copper";
        }
        if (material.equals("energizedgold")) {
            material = "energized_gold";
        }
        if (material.equals("stainlesssteel")) {
            material = "stainless_steel";
        }
        if (material.equals("bloodiron")) {
            material = "blood_infused_iron";
        }
        if (material.equals("enchantedbloodiron")) {
            material = "blood_infused_enchanted_iron";
        }
        if (material.equals("netheritediamond")) {
            material = "netherite_diamond";
        }
        if (material.equals("netheriteemerald")) {
            material = "netherite_emerald";
        }
        if (material.equals("netheritegold")) {
            material = "netherite_gold";
        }
        if (material.equals("netheriteiron")) {
            material = "netherite_iron";
        }
        if (material.equals("compressediron")) {
            material = "compressed_iron";
        }
        if (material.equals("pinkslime")) {
            material = "pink_slime";
        }
        if (material.equals("endercrystal")) {
            material = "ender_crystal";
        }
        if (material.equals("hdpe")) {
            material = "plastic";
        }
        if (material.equals("bluesteel")) {
            material = "blue_steel";
        }
        if (material.equals("highcarbonbluesteel")) {
            material = "high_carbon_blue_steel";
        }
        if (material.equals("wroughtiron")) {
            material = "wrought_iron";
        }
        if (material.equals("weaksteel")) {
            material = "weak_steel";
        }
        if (material.equals("highcarbonblacksteel")) {
            material = "high_carbon_black_steel";
        }
        if (material.equals("blackbronze")) {
            material = "black_bronze";
        }
        if (material.equals("bismuthbronze")) {
            material = "bismuth_bronze";
        }
        if (material.equals("highcarbonredsteel")) {
            material = "high_carbon_red_steel";
        }
        if (material.equals("redsteel")) {
            material = "red_steel";
        }
        if (material.equals("highcarbonsteel")) {
            material = "high_carbon_steel";
        }
        if (material.equals("rosegold")) {
            material = "rose_gold";
        }
        if (material.equals("weakredsteel")) {
            material = "weak_red_steel";
        }
        if (material.equals("pigiron")) {
            material = "pig_iron";
        }
        if (material.equals("weakbluesteel")) {
            material = "weak_blue_steel";
        }
        if (material.equals("sterlingsilver")) {
            material = "sterling_silver";
        }
        if (material.equals("blacksteel")) {
            material = "black_steel";
        }
        if (material.contains("alloy")) {
            material = material.replace("alloy", "_alloy");
        }
        return material;
    }

    @Nullable
    public static MobEffectInstance getHandleMaterialEffect(String material) {
        if (Config.getDisabledMaterialEffects().contains(material)) {
            return null;
        }
        return switch (material) {
            case "lumium", "glowstone" -> new MobEffectInstance(MobEffects.GLOWING, 30);
            case "breeze" -> new MobEffectInstance(MobEffects.JUMP_BOOST, 30);
            case "bloodiron", "soularium" -> new MobEffectInstance(MobEffects.BAD_OMEN, 30);
            case "enchantedbloodiron" -> new MobEffectInstance(MobEffects.BAD_OMEN, 30, 1);
            case "endsteel" -> new MobEffectInstance(MobEffects.SLOW_FALLING, 30);
            case "rosegold" -> ToolUtils.getOptionalEffect("love", 30, 0, (Holder<MobEffect>)MobEffects.LUCK);
            case "sterlingsilver" -> new MobEffectInstance(MobEffects.LUCK, 30);
            case "vibranium" -> new MobEffectInstance(MobEffects.RESISTANCE, 30);
            case "end" -> new MobEffectInstance(MobEffects.NIGHT_VISION, 30);
            case "blaze", "pyrope" -> ToolUtils.getOptionalEffect("warming", 30, 0, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE);
            case "solarium", "elementium" -> ToolUtils.getOptionalEffect("photosynthesis", 30, 0, (Holder<MobEffect>)MobEffects.GLOWING);
            case "aquite", "prismarine" -> new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 30);
            case "pinkslime" -> new MobEffectInstance(MobEffects.OOZING, 30);
            case "emerald" -> new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 30);
            case "amethyst" -> ToolUtils.getOptionalEffect("magic_resistance", 30, 0, (Holder<MobEffect>)MobEffects.LUCK);
            case "superconductor", "electrum" -> ToolUtils.getOptionalEffect("conductive", 30, 0, null);
            case "opal" -> ToolUtils.getOptionalEffect("nullifier", "remove_effects", 30, 0, (Holder<MobEffect>)MobEffects.LUCK);
            case "magnetite" -> ToolUtils.getOptionalEffect("magnetizing", "magnetic", 30, 0, null);
            case "enchanted" -> ToolUtils.getOptionalEffect("water_walk", 30, 0, (Holder<MobEffect>)MobEffects.SLOW_FALLING);
            case "blastproofalloy" -> ToolUtils.getOptionalEffect("explosion_resistance", 30, 0, null);
            case "horizonite" -> ToolUtils.getOptionalEffect("spiderclimb", "spider_climb", 30, 0, null);
            default -> null;
        };
    }

    @Nullable
    public static MobEffectInstance getHandleMaterialRandomEffect(String material) {
        if (Config.getDisabledMaterialEffects().contains(material)) {
            return null;
        }
        Random random = new Random();
        return switch (material) {
            case "uranium", "thorium", "yellorium", "cyanite", "ludicrite" -> ToolUtils.getOptionalEffect("radiation", random.nextInt(100, 1000), 0, (Holder<MobEffect>)MobEffects.POISON);
            case "plutonium", "blutonium", "magentite", "ridiculite", "inanite", "insanite" -> ToolUtils.getOptionalEffect("radiation", random.nextInt(100, 1000), 1, (Holder<MobEffect>)MobEffects.POISON);
            case "witherbone" -> new MobEffectInstance(MobEffects.WITHER, random.nextInt(100, 300));
            case "darksteel" -> new MobEffectInstance(MobEffects.DARKNESS, random.nextInt(100, 300));
            case "energeticalloy", "fluix" -> ToolUtils.getOptionalEffect("hyperactive", random.nextInt(100, 300), 0, (Holder<MobEffect>)MobEffects.HASTE);
            case "terrasteel" -> ToolUtils.getOptionalEffect("ore_sense", random.nextInt(100, 500), 0, (Holder<MobEffect>)MobEffects.HASTE);
            case "prismarine" -> ToolUtils.getOptionalEffect("swimspeed", random.nextInt(100, 300), 0, (Holder<MobEffect>)MobEffects.DOLPHINS_GRACE);
            case "manasteel", "certusquartz" -> ToolUtils.getOptionalEffect("mana", "manafruit", random.nextInt(100, 500), 0, (Holder<MobEffect>)MobEffects.LUCK);
            case "pulsatingalloy" -> new MobEffectInstance(MobEffects.NIGHT_VISION, random.nextInt(100, 800));
            case "atomicalloy" -> new MobEffectInstance(MobEffects.REGENERATION, random.nextInt(100, 300));
            case "enderium" -> ToolUtils.getOptionalEffect("teleportation", "enderlock", random.nextInt(100, 300), 0, (Holder<MobEffect>)MobEffects.INFESTED);
            case "duratium", "falsite", "pigiron" -> new MobEffectInstance(MobEffects.SATURATION, random.nextInt(100, 500));
            case "energizedcopper", "energizedgold", "energite" -> ToolUtils.getOptionalEffect("supercharge", "hyperactive", random.nextInt(300, 500), 0, (Holder<MobEffect>)MobEffects.SPEED);
            case "basalz" -> new MobEffectInstance(MobEffects.WEAKNESS, random.nextInt(100, 300));
            case "blitz" -> new MobEffectInstance(MobEffects.WIND_CHARGED, random.nextInt(100, 300));
            case "blizz" -> ToolUtils.getOptionalEffect("freezing", random.nextInt(100, 300), 0, null);
            case "allthemodium", "unobtainium" -> new MobEffectInstance(MobEffects.STRENGTH, random.nextInt(100, 300));
            case "endercrystal" -> ToolUtils.getOptionalEffect("enderlock", "air_swim", random.nextInt(100, 300), 0, (Holder<MobEffect>)MobEffects.NIGHT_VISION);
            default -> null;
        };
    }

    @Nullable
    public static MobEffectInstance getHeadMaterialEffect(String material) {
        if (Config.getDisabledMaterialEffects().contains(material)) {
            return null;
        }
        Random random = new Random();
        return switch (material) {
            case "lumium", "solarium", "glowstone" -> new MobEffectInstance(MobEffects.GLOWING, random.nextInt(50, 100));
            case "breeze" -> new MobEffectInstance(MobEffects.JUMP_BOOST, random.nextInt(50, 100));
            case "bloodiron" -> ToolUtils.getOptionalEffect("fear", random.nextInt(50, 300), 0, (Holder<MobEffect>)MobEffects.BAD_OMEN);
            case "soularium" -> ToolUtils.getOptionalEffect("soulpierced", "fear", random.nextInt(50, 300), 0, (Holder<MobEffect>)MobEffects.BAD_OMEN);
            case "enchantedbloodiron" -> ToolUtils.getOptionalEffect("fear", random.nextInt(100, 300), 1, (Holder<MobEffect>)MobEffects.BAD_OMEN);
            case "endsteel" -> new MobEffectInstance(MobEffects.SLOW_FALLING, random.nextInt(50, 100));
            case "rosegold", "sterlingsilver" -> new MobEffectInstance(MobEffects.LUCK, random.nextInt(50, 100));
            case "end" -> ToolUtils.getOptionalEffect("flashed", random.nextInt(50, 80), 0, (Holder<MobEffect>)MobEffects.NIGHT_VISION);
            case "blaze", "pyrope" -> ToolUtils.getOptionalEffect("burning", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE);
            case "pinkslime" -> ToolUtils.getOptionalEffect("sticky", random.nextInt(50, 200), 0, (Holder<MobEffect>)MobEffects.OOZING);
            case "amethyst" -> ToolUtils.getOptionalEffect("nullifier", "remove_effects", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.LUCK);
            case "superconductor", "electrum" -> ToolUtils.getOptionalEffect("conductive", random.nextInt(50, 100), 0, null);
            case "opal" -> ToolUtils.getOptionalEffect("curing", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.UNLUCK);
            case "magnetite" -> ToolUtils.getOptionalEffect("magnetizing", "magnetic", random.nextInt(50, 100), 0, null);
            case "enchanted" -> ToolUtils.getOptionalEffect("slippery", "weakened_soul", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.UNLUCK);
            case "terrasteel" -> ToolUtils.getOptionalEffect("gravity", "concrete_feet", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.SLOWNESS);
            default -> null;
        };
    }

    @Nullable
    public static MobEffectInstance getHeadMaterialRandomEffect(String material) {
        if (Config.getDisabledMaterialEffects().contains(material)) {
            return null;
        }
        Random random = new Random();
        return switch (material) {
            case "uranium", "thorium", "yellorium", "cyanite", "ludicrite" -> ToolUtils.getOptionalEffect("radiation", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.POISON);
            case "plutonium", "blutonium", "magentite", "ridiculite", "inanite", "insanite" -> ToolUtils.getOptionalEffect("radiation", random.nextInt(100, 150), 1, (Holder<MobEffect>)MobEffects.POISON);
            case "witherbone" -> new MobEffectInstance(MobEffects.WITHER, random.nextInt(50, 100));
            case "darksteel" -> new MobEffectInstance(MobEffects.DARKNESS, random.nextInt(50, 100));
            case "energeticalloy", "fluix" -> ToolUtils.getOptionalEffect("explosive", "explosion", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.HASTE);
            case "manasteel" -> ToolUtils.getOptionalEffect("mana_impedance", "mana", random.nextInt(100, 500), 0, (Holder<MobEffect>)MobEffects.UNLUCK);
            case "pulsatingalloy" -> new MobEffectInstance(MobEffects.NIGHT_VISION, random.nextInt(100, 300));
            case "atomicalloy" -> ToolUtils.getOptionalEffect("bleeding", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.WEAKNESS);
            case "enderium" -> ToolUtils.getOptionalEffect("teleportation", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.INFESTED);
            case "duratium", "falsite", "pigiron" -> new MobEffectInstance(MobEffects.HUNGER, random.nextInt(50, 120));
            case "energizedcopper", "energizedgold", "energite" -> ToolUtils.getOptionalEffect("supercharge", "hyperactive", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.SPEED);
            case "basalz" -> ToolUtils.getOptionalEffect("concrete_feet", "fear", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.WEAKNESS);
            case "blitz" -> new MobEffectInstance(MobEffects.WIND_CHARGED, random.nextInt(100, 500));
            case "infusedalloy" -> ToolUtils.getOptionalEffect("corrosive", random.nextInt(50, 100), 0, null);
            case "blizz" -> ToolUtils.getOptionalEffect("freezing", random.nextInt(50, 100), 0, null);
            case "bedrock" -> ToolUtils.getOptionalEffect("stunned", "stun", random.nextInt(10, 80), 0, null);
            case "endercrystal" -> ToolUtils.getOptionalEffect("teleportation", random.nextInt(50, 100), 0, (Holder<MobEffect>)MobEffects.LEVITATION);
            default -> null;
        };
    }

    public static Component getToolStatDescription(String handle, String base) {
        DecimalFormat df = new DecimalFormat("#.##");
        String textSeparator = ": ";
        String lineSeperator = "\n";
        ToolMaterial material = ModToolMaterials.getMaterial(handle, base);
        Materials handleMaterial = Materials.fromName(handle).orElseThrow(() -> new IllegalArgumentException("Unknown material: " + handle));
        Materials baseMaterial = Materials.fromName(base).orElseThrow(() -> new IllegalArgumentException("Unknown material: " + base));
        if (material == null) {
            throw new NullPointerException("Material is null: " + base + "_" + handle);
        }
        MutableComponent description = Component.translatable((String)FormattingHelper.setLangTag((String)"message", (String)"advancedtools", (String)"material_stats")).withStyle(ChatFormatting.BLUE);
        description.append((Component)Component.literal((String)lineSeperator));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"base").withStyle(ChatFormatting.WHITE).append(" "));
        description.append((Component)FormattingHelper.setModLangComponent((String)"material", (String)"advancedtools", (String)base).withStyle(ChatFormatting.YELLOW));
        description.append((Component)Component.literal((String)lineSeperator));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"handle").withStyle(ChatFormatting.WHITE).append(" "));
        description.append((Component)FormattingHelper.setModLangComponent((String)"material", (String)"advancedtools", (String)handle).withStyle(ChatFormatting.YELLOW));
        description.append((Component)Component.literal((String)(lineSeperator + lineSeperator)));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"mining_level.jei_desc").append(textSeparator).withStyle(ChatFormatting.WHITE));
        description.append((Component)Component.literal((String)("     " + FormattingUtils.getMiningLevel(material))).withStyle(FormattingUtils.getToolStatsFormatting(material, ToolMaterialStatTypes.MINING_LEVEL)));
        description.append((Component)Component.literal((String)lineSeperator));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"durability.jei_desc").append(textSeparator).withStyle(ChatFormatting.WHITE));
        description.append((Component)Component.literal((String)("        " + material.durability())).withStyle(FormattingUtils.getToolStatsFormatting(material, ToolMaterialStatTypes.DURABILITY)));
        description.append((Component)Component.literal((String)lineSeperator));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"mining_speed.jei_desc").append(textSeparator).withStyle(ChatFormatting.WHITE));
        description.append((Component)Component.literal((String)("    " + df.format(material.speed()))).withStyle(FormattingUtils.getToolStatsFormatting(material, ToolMaterialStatTypes.MINING_SPEED)));
        description.append((Component)Component.literal((String)lineSeperator));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"damage.jei_desc").append(textSeparator).withStyle(ChatFormatting.WHITE));
        description.append((Component)Component.literal((String)("           " + df.format(material.attackDamageBonus()))).withStyle(FormattingUtils.getToolStatsFormatting(material, ToolMaterialStatTypes.DAMAGE)));
        description.append((Component)Component.literal((String)lineSeperator));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"enchantability.jei_desc").append(textSeparator).withStyle(ChatFormatting.WHITE));
        description.append((Component)Component.literal((String)("   " + material.enchantmentValue())).withStyle(FormattingUtils.getToolStatsFormatting(material, ToolMaterialStatTypes.ENCHANTABILITY)));
        description.append((Component)Component.literal((String)lineSeperator));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"sockets.jei_desc").append(textSeparator).withStyle(ChatFormatting.WHITE));
        description.append((Component)Component.literal((String)("  " + String.valueOf(baseMaterial.getUpgradeSlots() + handleMaterial.getUpgradeSlots()))).withStyle(FormattingUtils.getToolStatsFormatting(material, ToolMaterialStatTypes.SOCKETS)));
        description.append((Component)Component.literal((String)lineSeperator));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"hit_effect.jei_desc").append(textSeparator).withStyle(ChatFormatting.WHITE));
        description.append(FormattingUtils.getHeadEffectNamesFromMaterial(base));
        description.append((Component)Component.literal((String)lineSeperator));
        description.append((Component)FormattingHelper.setModLangComponent((String)"message", (String)"advancedtools", (String)"hold_effect.jei_desc").append(textSeparator).withStyle(ChatFormatting.WHITE));
        description.append(FormattingUtils.getHandleEffectNamesFromMaterial(handle));
        return description;
    }

    @Nullable
    public static MobEffectInstance getOptionalEffect(String effectId, int duration, int amplifier, @Nullable Holder<MobEffect> alternativeEffect) {
        if (effectId == null) {
            return null;
        }
        for (MobEffect effect : BuiltInRegistries.MOB_EFFECT) {
            ResourceLocation key = BuiltInRegistries.MOB_EFFECT.getKey((Object)effect);
            if (key == null || !key.getPath().equals(effectId)) continue;
            return new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), duration, amplifier);
        }
        if (alternativeEffect == null) {
            return null;
        }
        return new MobEffectInstance(alternativeEffect, duration, amplifier);
    }

    @Nullable
    public static MobEffectInstance getOptionalEffect(String effectId, String alternativeEffectId, int duration, int amplifier, @Nullable Holder<MobEffect> fallbackEffect) {
        if (effectId == null && alternativeEffectId == null) {
            return null;
        }
        for (MobEffect effect : BuiltInRegistries.MOB_EFFECT) {
            ResourceLocation key = BuiltInRegistries.MOB_EFFECT.getKey((Object)effect);
            if (key != null && key.getPath().equals(effectId)) {
                return new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), duration, amplifier);
            }
            if (key == null || !key.getPath().equals(alternativeEffectId)) continue;
            return new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), duration, amplifier);
        }
        if (fallbackEffect == null) {
            return null;
        }
        return new MobEffectInstance(fallbackEffect, duration, amplifier);
    }
}

