/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.utils.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import xxrexraptorxx.advancedtools.items.UpgradeItem;
import xxrexraptorxx.magmacore.content.TagHelper;

public enum Upgrades {
    EMPTY_UPGRADE(0, null, null, null),
    RARITY_UPGRADE(3, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"rarity_upgrade_materials"), null, DataComponents.RARITY),
    NETHERITE_UPGRADE(1, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"netherite_upgrade_materials"), null, DataComponents.DAMAGE_RESISTANT),
    OBSIDIAN_UPGRADE(1, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"obsidian_upgrade_materials"), null, DataComponents.DAMAGE_RESISTANT),
    KNOCKBACK_UPGRADE(10, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"knockback_upgrade_materials"), (Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, null),
    DAMAGE_UPGRADE(10, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"damage_upgrade_materials"), (Holder<Attribute>)Attributes.LUCK, null),
    SPEED_UPGRADE(10, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"speed_upgrade_materials"), (Holder<Attribute>)Attributes.ATTACK_DAMAGE, null),
    LUCK_UPGRADE(10, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"luck_upgrade_materials"), (Holder<Attribute>)Attributes.ATTACK_SPEED, null),
    EFFICIENCY_UPGRADE(10, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"efficiency_upgrade_materials"), (Holder<Attribute>)Attributes.BLOCK_BREAK_SPEED, null),
    UNDERWATER_UPGRADE(10, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"underwater_upgrade_materials"), (Holder<Attribute>)Attributes.MINING_EFFICIENCY, null),
    ATTACKRANGE_UPGRADE(10, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"attack_range_upgrade_materials"), (Holder<Attribute>)Attributes.SUBMERGED_MINING_SPEED, null),
    MININGRANGE_UPGRADE(10, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"mining_range_upgrade_materials"), (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, null),
    SWEEPING_UPGRADE(10, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"sweeping_upgrade_materials"), (Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, null),
    PROTECTION_UPGRADE(5, (TagKey<Item>)TagHelper.createItemTag((String)"advancedtools", (String)"protection_upgrade_materials"), (Holder<Attribute>)Attributes.SWEEPING_DAMAGE_RATIO, null);

    private static final Map<ResourceLocation, Upgrades> ITEM_TO_UPGRADE;
    private final int maxCount;
    private final TagKey<Item> craftingTag;
    private final Holder<Attribute> attribute;
    private final DataComponentType<?> component;

    private Upgrades(int maxCount, TagKey<Item> craftingTag, Holder<Attribute> attribute, DataComponentType<?> component) {
        this.maxCount = maxCount;
        this.craftingTag = craftingTag;
        this.attribute = attribute;
        this.component = component;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public TagKey<Item> getCraftingTag() {
        return this.craftingTag;
    }

    public Holder<Attribute> getAttribute() {
        return this.attribute;
    }

    public DataComponentType<?> getComponent() {
        return this.component;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public static Optional<Upgrades> fromItem(Item item) {
        if (!(item instanceof UpgradeItem)) {
            return Optional.empty();
        }
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)item);
        return Optional.ofNullable(ITEM_TO_UPGRADE.get(key));
    }

    static {
        ITEM_TO_UPGRADE = Arrays.stream(Upgrades.values()).collect(Collectors.toMap(u -> ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)u.name().toLowerCase()), Function.identity()));
    }
}

