/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.world;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import xxrexraptorxx.advancedtools.registry.ModComponents;
import xxrexraptorxx.advancedtools.registry.ModItems;
import xxrexraptorxx.advancedtools.utils.SocketUtils;
import xxrexraptorxx.advancedtools.utils.ToolUtils;
import xxrexraptorxx.advancedtools.utils.sockets.ISocketTool;
import xxrexraptorxx.magmacore.content.ItemHelper;

@EventBusSubscriber(modid="advancedtools")
public class ModEvents {
    @SubscribeEvent
    public static void modifyComponents(ModifyDefaultComponentsEvent event) {
        for (String handle : ModItems.HANDLE_MATERIALS) {
            if (ToolUtils.isFireResistant(handle)) {
                event.modify((ItemLike)BuiltInRegistries.ITEM.getValue(ItemHelper.getLocation((String)"advancedtools", (String)("stick_" + handle))), builder -> builder.set(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_FIRE)));
            }
            for (String head : ModItems.TOOL_HEAD_MATERIALS) {
                if (!ToolUtils.isFireResistant(handle) && !ToolUtils.isFireResistant(head)) continue;
                for (String tool : ModItems.TOOL_TYPES) {
                    if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(head) && handle.equals("wood")) continue;
                    event.modify((ItemLike)BuiltInRegistries.ITEM.getValue(ItemHelper.getLocation((String)"advancedtools", (String)(handle + "_stick_" + head + "_" + tool))), builder -> builder.set(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_FIRE)));
                }
            }
        }
        for (Item item : event.getAllItems().toList()) {
            if (!(item instanceof ISocketTool)) continue;
            ISocketTool socketTool = (ISocketTool)item;
            int sockets = socketTool.getSocketCount(new ItemStack((ItemLike)item));
            List<String> emptySockets = IntStream.range(0, sockets).mapToObj(i -> SocketUtils.EMPTY_STACK).toList();
            event.modify((ItemLike)item, builder -> builder.set((DataComponentType)ModComponents.SOCKETS.get(), (Object)emptySockets));
        }
    }
}

