/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.datagen;

import java.util.Arrays;
import java.util.function.BiConsumer;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModItems;
import xxrexraptorxx.advancedtools.utils.ToolUtils;

public class ItemModelGen
extends ItemModelGenerators {
    ModelTemplate TWO_LAYERED_HANDHELD_ITEM = ModelTemplates.createItem((String)"handheld", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1});

    public ItemModelGen(ItemModelOutput itemModelOutput, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        super(itemModelOutput, modelOutput);
    }

    public void run() {
        this.generateBow((Item)ModItems.IRON_BOW.get());
        this.generateBow((Item)ModItems.GOLD_BOW.get());
        this.generateBow((Item)ModItems.DIAMOND_BOW.get());
        this.generateBow((Item)ModItems.NETHERITE_BOW.get());
        for (String handle : ModItems.HANDLE_MATERIALS) {
            if (!ToolUtils.isRod(handle)) {
                AdvancedTools.LOGGER.info("Generate item model of " + handle);
                this.generateFlatItem((Item)BuiltInRegistries.ITEM.getValue(ItemModelGen.getStickLoc(handle)), ModelTemplates.FLAT_HANDHELD_ROD_ITEM);
            }
            for (String head : ModItems.TOOL_HEAD_MATERIALS) {
                for (String tool : ModItems.TOOL_TYPES) {
                    if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(head) && handle.equals("wood")) continue;
                    AdvancedTools.LOGGER.info("Generate " + tool + " item model of " + head + " head with " + handle + " handle");
                    this.generateLayeredHandheldItem((Item)BuiltInRegistries.ITEM.getValue(ItemModelGen.getItemLoc(handle + "_stick_" + head + "_" + tool)));
                }
            }
        }
    }

    public void generateLayeredHandheldItem(Item item) {
        String toolType;
        Object stickType;
        String name = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        String[] parts = name.split("_");
        if (parts.length == 4) {
            stickType = parts[0];
            toolType = parts[2] + "_" + parts[3] + "_overlay";
            stickType = parts[3].equals("shovel") ? (String)stickType + "_shovel_base" : (parts[3].equals("sword") ? (String)stickType + "_sword_base" : (parts[3].equals("axe") ? (String)stickType + "_axe_base" : (String)stickType + "_tool_base"));
        } else {
            throw new IllegalArgumentException("Invalid input format: " + name);
        }
        this.itemModelOutput.accept(item, ItemModelUtils.plainModel((ResourceLocation)this.TWO_LAYERED_HANDHELD_ITEM.create(ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)("item/" + name)), TextureMapping.layered((ResourceLocation)ItemModelGen.getTextureLoc((String)stickType), (ResourceLocation)ItemModelGen.getTextureLoc(toolType)), this.modelOutput)));
    }

    public static ResourceLocation getTextureLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)("item/" + name));
    }

    public static ResourceLocation getStickLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)("stick_" + name));
    }

    public static ResourceLocation getItemLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)name);
    }
}

