/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.datagen;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import xxrexraptorxx.advancedtools.datagen.ItemModelGen;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModItems;
import xxrexraptorxx.advancedtools.registry.ModTags;
import xxrexraptorxx.advancedtools.utils.ToolUtils;

public class ItemTagGen
extends ItemTagsProvider {
    public ItemTagGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> provider) {
        super(output, lookupProvider, provider, "advancedtools");
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (String handle : ModItems.HANDLE_MATERIALS) {
            AdvancedTools.LOGGER.info("Generate item tags for " + handle);
            Item rodItem = (Item)BuiltInRegistries.ITEM.getValue(ItemModelGen.getItemLoc("stick_" + handle));
            if (rodItem == Items.AIR) {
                AdvancedTools.LOGGER.error("Invalid item!!! [" + handle + "]");
            }
            TagKey<Item> rodTag = ModTags.createCItemTag("rods/" + ToolUtils.transformMaterialNames(handle));
            TagKey<Item> stickTag = ModTags.createCItemTag("sticks/" + ToolUtils.transformMaterialNames(handle));
            TagKey<Item> toolTag = ModTags.createItemTag("advancedtools", ToolUtils.transformMaterialNames(handle) + "_tools");
            if (rodItem != Items.AIR) {
                this.tag(rodTag).add((Object)rodItem).addOptionalTag(stickTag);
                this.tag(stickTag).add((Object)rodItem);
            }
            this.tag(ModTags.createCItemTag("rods")).addOptionalTags(new TagKey[]{rodTag});
            this.tag(ModTags.createCItemTag("sticks")).addOptionalTags(new TagKey[]{stickTag});
            if (handle.contains("gold")) {
                this.tag(ItemTags.PIGLIN_LOVED).add((Object)((Item)BuiltInRegistries.ITEM.getValue(ItemModelGen.getItemLoc("stick_" + handle))));
            }
            for (String otherHandle : ModItems.HANDLE_MATERIALS) {
                for (String head : ModItems.TOOL_HEAD_MATERIALS) {
                    for (String tool : ModItems.TOOL_TYPES) {
                        ResourceLocation loc;
                        Item item;
                        if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(head) && handle.equals("wood") || (item = (Item)BuiltInRegistries.ITEM.getValue(loc = ItemModelGen.getItemLoc(otherHandle + "_stick_" + head + "_" + tool))) == Items.AIR || !otherHandle.equals(handle) && !head.equals(handle)) continue;
                        this.tag(toolTag).add((Object)item);
                        switch (tool) {
                            case "sword": {
                                this.tag(ItemTags.SWORDS).add((Object)item);
                                break;
                            }
                            case "pickaxe": {
                                this.tag(ItemTags.PICKAXES).add((Object)item);
                                break;
                            }
                            case "axe": {
                                this.tag(ItemTags.AXES).add((Object)item);
                                break;
                            }
                            case "shovel": {
                                this.tag(ItemTags.SHOVELS).add((Object)item);
                                break;
                            }
                            case "hoe": {
                                this.tag(ItemTags.HOES).add((Object)item);
                            }
                        }
                        if (!head.contains("gold") && !handle.contains("gold")) continue;
                        this.tag(ItemTags.PIGLIN_LOVED).add((Object)item);
                    }
                }
            }
        }
        for (String head : ModItems.TOOL_HEAD_MATERIALS) {
            if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(head)) continue;
            AdvancedTools.LOGGER.info("Generate crafting materials tag for " + head);
            TagKey<Item> craftingMaterialTag = ModTags.createCItemTag(ToolUtils.transformMaterialNames(head) + "_tool_materials");
            for (TagKey<Item> key : ModTags.getPossibleTagsForMaterial(head)) {
                this.tag(craftingMaterialTag).addOptionalTag(key);
            }
        }
        TagKey<Item> woodStick = ModTags.createItemTag("c", "sticks/wood");
        this.tag(woodStick).add((Object)Items.STICK);
        this.tag(ModTags.createCItemTag("sticks")).addTags(new TagKey[]{woodStick});
        TagKey<Item> endRod = ModTags.createCItemTag("rods/end");
        this.tag(endRod).add((Object)Blocks.END_ROD.asItem());
        this.tag(ModTags.createCItemTag("rods")).addTags(new TagKey[]{endRod});
        this.tag(Tags.Items.TOOLS_BOW).add((Object[])new Item[]{(Item)ModItems.IRON_BOW.get(), ModItems.GOLD_BOW.asItem(), ModItems.DIAMOND_BOW.asItem(), ModItems.NETHERITE_BOW.asItem()});
        this.tag(ItemTags.BOW_ENCHANTABLE).add((Object[])new Item[]{(Item)ModItems.IRON_BOW.get(), ModItems.GOLD_BOW.asItem(), ModItems.DIAMOND_BOW.asItem(), ModItems.NETHERITE_BOW.asItem()});
    }
}

